/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.configuration.editors.csv12;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.jboss.tools.smooks.configuration.editors.csv12.CSV12DataConfigurationWizardPage;
import org.jboss.tools.smooks.configuration.editors.csv12.Messages;
import org.jboss.tools.smooks.configuration.editors.uitls.SmooksUIUtils;
import org.jboss.tools.smooks.configuration.editors.xml.AbstractFileSelectionWizardPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSV12DataPathWizardPage
extends AbstractFileSelectionWizardPage {
    private CSV12DataConfigurationWizardPage configPage;

    public CSV12DataPathWizardPage(String pageName, boolean multiSelect, Object[] initSelections, List<ViewerFilter> filters, CSV12DataConfigurationWizardPage configPage) {
        super(pageName, multiSelect, initSelections, filters);
        this.configPage = configPage;
    }

    public CSV12DataPathWizardPage(String pageName, String[] fileExtensionNames, CSV12DataConfigurationWizardPage configPage) {
        super(pageName, fileExtensionNames);
        this.setTitle(Messages.CSV12DataPathWizardPage_WizardTitle);
        this.setDescription(Messages.CSV12DataPathWizardPage_WizardDes);
        this.configPage = configPage;
    }

    @Override
    protected void hookFileTextModifyListener() {
        super.hookFileTextModifyListener();
        this.fileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (CSV12DataPathWizardPage.this.configPage != null) {
                    CSV12DataPathWizardPage.this.configPage.setFilePath(CSV12DataPathWizardPage.this.fileText.getText());
                }
            }
        });
    }

    @Override
    protected Object loadedTheObject(String path) throws Exception {
        return null;
    }

    @Override
    protected void changeWizardPageStatus() {
        super.changeWizardPageStatus();
        String text = this.fileText.getText();
        String error = null;
        try {
            String filePath = SmooksUIUtils.parseFilePath(text);
            if (!new File(filePath).exists()) {
                error = String.valueOf(Messages.CSV12DataPathWizardPage_CantFindFileErrorMessage) + filePath;
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            error = Messages.CSV12DataPathWizardPage_ErrorFilePathErrorMessage;
        }
        this.setErrorMessage(error);
        this.setPageComplete(error == null);
    }

    public boolean canFlipToNextPage() {
        return super.canFlipToNextPage();
    }
}

