/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.configuration.editors.csv12;

import java.math.BigInteger;
import java.util.List;
import java.util.Properties;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.jboss.tools.smooks.configuration.editors.SmooksMultiFormEditor;
import org.jboss.tools.smooks.configuration.editors.csv12.CSV12DataConfigurationWizardPage;
import org.jboss.tools.smooks.configuration.editors.csv12.CSV12DataPathWizardPage;
import org.jboss.tools.smooks.configuration.editors.csv12.Messages;
import org.jboss.tools.smooks.configuration.editors.wizard.IStructuredDataSelectionWizard;
import org.jboss.tools.smooks.model.csv12.CSV12Reader;
import org.jboss.tools.smooks.model.csv12.Csv12Factory;
import org.jboss.tools.smooks.model.csv12.Csv12Package;
import org.jboss.tools.smooks.model.smooks.DocumentRoot;
import org.jboss.tools.smooks.model.smooks.SmooksPackage;
import org.jboss.tools.smooks.model.smooks.SmooksResourceListType;

public class CSV12InputDataWizard
extends Wizard
implements IStructuredDataSelectionWizard,
INewWizard {
    private SmooksResourceListType resourceList;
    private EditingDomain editingDomain;
    private CSV12DataConfigurationWizardPage configPage;
    private CSV12DataPathWizardPage pathPage;

    public CSV12InputDataWizard() {
        this.setWindowTitle(Messages.CSV12InputDataWizard_0);
    }

    public void addPages() {
        if (this.pathPage == null) {
            this.pathPage = new CSV12DataPathWizardPage(Messages.CSV12InputDataWizard_1, new String[]{Messages.CSV12InputDataWizard_ExtensionName}, this.configPage);
        }
        this.addPage((IWizardPage)this.pathPage);
        super.addPages();
    }

    public boolean performFinish() {
        boolean createCSVReader;
        if (this.configPage != null && (createCSVReader = this.configPage.isCreateCSVReader())) {
            String indent;
            String recordName;
            CSV12Reader reader = Csv12Factory.eINSTANCE.createCSV12Reader();
            String encoding = this.configPage.getEncoding();
            reader.setEncoding(encoding);
            String separator = this.configPage.getSeparator();
            reader.setSeparator(separator);
            String skipLines = this.configPage.getSkipLines();
            long skip = -1L;
            try {
                skip = Long.parseLong(skipLines);
            }
            catch (Throwable throwable) {}
            if (skip >= 0L) {
                reader.setSkipLines(BigInteger.valueOf(skip));
            }
            String quoteChar = this.configPage.getQuoteChar();
            reader.setQuote(quoteChar);
            String rootName = this.configPage.getRootName();
            if (rootName != null) {
                reader.setRootElementName(rootName);
            }
            if ((recordName = this.configPage.getRecordName()) != null) {
                reader.setRecordElementName(recordName);
            }
            if ((indent = this.configPage.getIndent()) != null && indent.length() != 0) {
                boolean indentValue = Boolean.valueOf(indent);
                reader.setIndent(indentValue);
            }
            String fields = null;
            List<CSV12DataConfigurationWizardPage.FieldString> fieldList = this.configPage.getFieldsList();
            if (fieldList != null && !fieldList.isEmpty()) {
                fields = "";
                for (CSV12DataConfigurationWizardPage.FieldString fieldString : fieldList) {
                    String f = fieldString.getText();
                    fields = String.valueOf(fields) + f + ",";
                }
                if (fields.length() > 1) {
                    fields = fields.substring(0, fields.length() - 1);
                }
            }
            reader.setFields(fields);
            Command command = AddCommand.create((EditingDomain)this.editingDomain, (Object)this.resourceList, (Object)SmooksPackage.Literals.SMOOKS_RESOURCE_LIST_TYPE__ABSTRACT_READER_GROUP, (Object)FeatureMapUtil.createEntry((EStructuralFeature)Csv12Package.Literals.CSV12_DOCUMENT_ROOT__READER, (Object)reader));
            this.editingDomain.getCommandStack().execute(command);
        }
        return true;
    }

    public boolean canFinish() {
        if (this.pathPage != null) {
            return this.pathPage.isPageComplete();
        }
        return this.configPage != null && this.pathPage != null && this.configPage.isPageComplete() && this.pathPage.isPageComplete();
    }

    public void complate(SmooksMultiFormEditor formEditor) {
    }

    public String getInputDataTypeID() {
        return "input.csv";
    }

    public Properties getProperties() {
        Properties pro = new Properties();
        this.fillProperties(pro);
        return pro;
    }

    private void fillProperties(Properties pro) {
        if (this.configPage != null) {
            String indent;
            String skiplines;
            String recordName;
            String rootName;
            String quoteChar;
            String separator;
            String encoding;
            boolean createCSVReader = this.configPage.isCreateCSVReader();
            boolean useAvailabelReader = this.configPage.isUseAvailabelReader();
            if (useAvailabelReader || createCSVReader) {
                pro.put("linkCSVReader", "true");
                return;
            }
            String fields = null;
            List<CSV12DataConfigurationWizardPage.FieldString> fieldList = this.configPage.getFieldsList();
            if (fieldList != null && !fieldList.isEmpty()) {
                fields = "";
                for (CSV12DataConfigurationWizardPage.FieldString fieldString : fieldList) {
                    String f = fieldString.getText();
                    fields = String.valueOf(fields) + f + ",";
                }
                if (fields.length() > 1) {
                    fields = fields.substring(0, fields.length() - 1);
                }
            }
            if (fields != null && fields.length() != 0) {
                pro.put("fields", fields);
            }
            if ((encoding = this.configPage.getEncoding()) != null && encoding.length() != 0) {
                pro.put("encoding", encoding);
            }
            if ((separator = this.configPage.getSeparator()) != null && separator.length() != 0) {
                pro.put("separator", separator);
            }
            if ((quoteChar = this.configPage.getQuoteChar()) != null && quoteChar.length() != 0) {
                pro.put("quoteChar", quoteChar);
            }
            if ((rootName = this.configPage.getRootName()) != null && rootName.length() != 0) {
                pro.put("rootElementName", rootName);
            }
            if ((recordName = this.configPage.getRecordName()) != null && recordName.length() != 0) {
                pro.put("recordName", recordName);
            }
            if ((skiplines = this.configPage.getSkipLines()) != null && skiplines.length() != 0) {
                pro.put("skiplines", skiplines);
            }
            if ((indent = this.configPage.getIndent()) != null && indent.length() != 0) {
                pro.setProperty("indent", indent);
            }
        }
    }

    public Object getReturnData() {
        return null;
    }

    public String getStructuredDataSourcePath() {
        if (this.pathPage != null) {
            return this.pathPage.getFilePath();
        }
        return null;
    }

    public void init(IEditorSite site, IEditorInput input) {
        IEditorPart editorPart = site.getWorkbenchWindow().getActivePage().findEditor(input);
        if (editorPart != null && editorPart instanceof SmooksMultiFormEditor) {
            SmooksMultiFormEditor formEditor = (SmooksMultiFormEditor)editorPart;
            EObject smooksModel = formEditor.getSmooksModel();
            if (smooksModel instanceof DocumentRoot) {
                this.resourceList = ((DocumentRoot)smooksModel).getSmooksResourceList();
            }
            this.editingDomain = formEditor.getEditingDomain();
        }
        if (this.pathPage != null && input != null && input instanceof IFileEditorInput) {
            this.pathPage.setInitSelections(new Object[]{((IFileEditorInput)input).getFile().getParent()});
        }
        if (this.configPage != null) {
            this.configPage.setSmooksResourceList(this.resourceList);
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }
}

