/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.configuration.editors.edi;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.jboss.tools.smooks.configuration.editors.edi.Messages;
import org.jboss.tools.smooks.configuration.editors.uitls.SmooksUIUtils;
import org.jboss.tools.smooks.configuration.editors.xml.TagList;
import org.jboss.tools.smooks.configuration.editors.xml.XMLObjectAnalyzer;
import org.jboss.tools.smooks.model.edi12.EDI12Reader;
import org.jboss.tools.smooks.model.smooks.AbstractReader;
import org.jboss.tools.smooks.model.smooks.SmooksResourceListType;
import org.milyn.ReaderConfigurator;
import org.milyn.Smooks;
import org.milyn.smooks.edi.EDIReaderConfigurator;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;

public class EDIDataParser {
    public static final String USE_AVAILABEL_READER = "use_availableReader";
    public static final String ENCODING = "encoding";
    public static final Object MAPPING_MODEL = "mappingModelFile";
    public static final Object VALIDATE = "validate";

    public TagList parseEDIFile(InputStream stream, SmooksResourceListType resourceList, IProject project) throws IOException {
        EList readers = resourceList.getAbstractReader();
        int count = 0;
        int index = -1;
        for (AbstractReader abstractReader : readers) {
            if (!(abstractReader instanceof EDI12Reader)) continue;
            ++count;
            if (index != -1) continue;
            index = readers.indexOf(abstractReader);
        }
        if (index != -1) {
            return this.parseEDIFile(stream, (EObject)readers.get(index), project);
        }
        return null;
    }

    public TagList parseEDIFile(InputStream stream, SmooksResourceListType resourceList) throws IOException {
        EList readers = resourceList.getAbstractReader();
        int count = 0;
        int index = -1;
        for (AbstractReader abstractReader : readers) {
            if (!(abstractReader instanceof EDI12Reader)) continue;
            ++count;
            if (index != -1) continue;
            index = readers.indexOf(abstractReader);
        }
        if (index != -1) {
            return this.parseEDIFile(stream, (EObject)readers.get(index));
        }
        return null;
    }

    public TagList parseEDIFile(InputStream ediInputStream, EObject readerObj, IProject project) throws IOException {
        String encoding = null;
        String mappingModel = null;
        String validate = null;
        if (readerObj instanceof EDI12Reader) {
            EDI12Reader reader = (EDI12Reader)readerObj;
            encoding = reader.getEncoding();
            mappingModel = reader.getMappingModel();
        }
        return this.parseEDIFile(ediInputStream, mappingModel, encoding, validate, project);
    }

    public TagList parseEDIFile(InputStream ediInputStream, EObject readerObj) throws IOException {
        String encoding = null;
        String mappingModel = null;
        if (readerObj instanceof EDI12Reader) {
            EDI12Reader reader = (EDI12Reader)readerObj;
            encoding = reader.getEncoding();
            mappingModel = reader.getMappingModel();
        }
        return this.parseEDIFile(ediInputStream, mappingModel, encoding, null, readerObj);
    }

    public TagList parseEDIFile(InputStream ediInputStream, String mappingModel, String ediFileEncoding, String validate, EObject emodel) throws IOException {
        IResource resource = SmooksUIUtils.getResource(emodel);
        IProject project = null;
        if (resource != null) {
            project = resource.getProject();
        }
        return this.parseEDIFile(ediInputStream, mappingModel, ediFileEncoding, validate, project);
    }

    public TagList parseEDIFile(InputStream ediInputStream, String mappingModel, String ediFileEncoding, String validate, IProject project) throws IOException {
        Smooks smooks = new Smooks();
        if (mappingModel == null) {
            throw new RuntimeException(Messages.EDIDataParser_Exception_EDI_Mapping_Cannot_Be_Empty);
        }
        File f = new File(mappingModel);
        String modelPath = mappingModel;
        if (f.exists()) {
            modelPath = f.toURI().toString();
        } else {
            IFile tf = SmooksUIUtils.getFile(mappingModel, project);
            if (tf != null) {
                modelPath = tf.getLocation().toFile().toURI().toString();
            } else {
                URL ur;
                Bundle bundle = Platform.getBundle((String)"org.jboss.tools.smooks.core.test");
                if (bundle != null && (ur = bundle.getEntry("/src" + mappingModel)) != null) {
                    try {
                        ur = FileLocator.resolve((URL)ur);
                        modelPath = ur.toURI().toString();
                    }
                    catch (URISyntaxException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        EDIReaderConfigurator readerConfig = new EDIReaderConfigurator(modelPath);
        if (ediFileEncoding == null || ediFileEncoding.trim().length() == 0) {
            ediFileEncoding = "UTF-8";
        }
        smooks.setReaderConfig((ReaderConfigurator)readerConfig);
        DOMResult result = new DOMResult();
        smooks.filterSource((Source)new StreamSource(ediInputStream), new Result[]{result});
        Document resultXMLContent = (Document)result.getNode();
        XMLObjectAnalyzer analyzer = new XMLObjectAnalyzer();
        TagList tagList = analyzer.analyze(resultXMLContent, null, null);
        try {
            if (smooks != null) {
                smooks.close();
                smooks = null;
            }
            if (ediInputStream != null) {
                ediInputStream.close();
                ediInputStream = null;
            }
            result = null;
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return tagList;
    }

    public TagList parseEDIFile(String path, SmooksResourceListType smooksResourceListType) throws InvocationTargetException, FileNotFoundException, IOException {
        String filePath = SmooksUIUtils.parseFilePath(path);
        return this.parseEDIFile((InputStream)new FileInputStream(filePath), smooksResourceListType);
    }
}

