/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.configuration.editors.edi;

import java.util.Properties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.jboss.tools.smooks.configuration.editors.SmooksMultiFormEditor;
import org.jboss.tools.smooks.configuration.editors.edi.EDIDataParser;
import org.jboss.tools.smooks.configuration.editors.edi.EDIDataPathWizardPage;
import org.jboss.tools.smooks.configuration.editors.edi.EDIMappingDataPathWizardPage;
import org.jboss.tools.smooks.configuration.editors.edi.Messages;
import org.jboss.tools.smooks.configuration.editors.wizard.IStructuredDataSelectionWizard;
import org.jboss.tools.smooks.model.smooks.DocumentRoot;
import org.jboss.tools.smooks.model.smooks.SmooksResourceListType;

public class EDIDataWizard
extends Wizard
implements IStructuredDataSelectionWizard,
INewWizard {
    private EDIMappingDataPathWizardPage mappingFilePage;
    private EDIDataPathWizardPage ediFilePage;
    private SmooksResourceListType resourceList;
    private EditingDomain editingDomain;
    private IContainer folder = null;

    public EDIDataWizard() {
        this.setWindowTitle(Messages.EDIDataWizard_WizardTitle);
    }

    public void addPages() {
        this.ediFilePage = new EDIDataPathWizardPage(Messages.EDIDataWizard_0, new String[]{Messages.EDIDataWizard_2});
        this.addPage((IWizardPage)this.ediFilePage);
        if (this.folder != null) {
            this.ediFilePage.setInitSelections(new Object[]{this.folder});
        }
        super.addPages();
    }

    public boolean performFinish() {
        if (this.mappingFilePage != null) {
            if (this.mappingFilePage.isUseAvaliableReader()) {
                return true;
            }
            if (this.mappingFilePage.isCreateNewReader()) {
                this.mappingFilePage.getEncoding();
                this.mappingFilePage.getFilePath();
            }
        }
        return true;
    }

    public void complate(SmooksMultiFormEditor formEditor) {
    }

    public String getInputDataTypeID() {
        return "input.edi";
    }

    public Properties getProperties() {
        Properties pros = new Properties();
        if (this.mappingFilePage != null) {
            if (this.mappingFilePage.isUseAvaliableReader() || this.mappingFilePage.isCreateNewReader()) {
                pros.put("use_availableReader", "true");
                return pros;
            }
            String encoding = this.mappingFilePage.getEncoding();
            pros.put("encoding", encoding);
            String path = this.mappingFilePage.getFilePath();
            pros.put(EDIDataParser.MAPPING_MODEL, path);
        }
        return pros;
    }

    public Object getReturnData() {
        return null;
    }

    public String getStructuredDataSourcePath() {
        if (this.ediFilePage.getFilePath() != null) {
            return this.ediFilePage.getFilePath();
        }
        return null;
    }

    public void init(IEditorSite site, IEditorInput input) {
        IEditorPart editorPart = site.getWorkbenchWindow().getActivePage().findEditor(input);
        if (editorPart != null && editorPart instanceof SmooksMultiFormEditor) {
            SmooksMultiFormEditor formEditor = (SmooksMultiFormEditor)editorPart;
            EObject smooksModel = formEditor.getSmooksModel();
            if (smooksModel instanceof DocumentRoot) {
                this.resourceList = ((DocumentRoot)smooksModel).getSmooksResourceList();
            }
            this.editingDomain = formEditor.getEditingDomain();
        }
        this.folder = ((IFileEditorInput)input).getFile().getParent();
        if (this.ediFilePage != null && this.folder != null) {
            this.ediFilePage.setInitSelections(new Object[]{this.folder});
        }
        if (this.mappingFilePage != null) {
            this.mappingFilePage.setSmooksResourceList(this.resourceList);
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }
}

