/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.configuration.editors.edireader12;

import java.util.Properties;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.jboss.tools.smooks.configuration.editors.SmooksMultiFormEditor;
import org.jboss.tools.smooks.configuration.editors.edi.EDIDataParser;
import org.jboss.tools.smooks.configuration.editors.edireader12.EDIReader12DataPathWizardPage;
import org.jboss.tools.smooks.configuration.editors.edireader12.EDIReader12MappingDataPathWizardPage;
import org.jboss.tools.smooks.configuration.editors.edireader12.Messages;
import org.jboss.tools.smooks.configuration.editors.wizard.IStructuredDataSelectionWizard;
import org.jboss.tools.smooks.model.edi12.EDI12Reader;
import org.jboss.tools.smooks.model.edi12.Edi12Factory;
import org.jboss.tools.smooks.model.edi12.Edi12Package;
import org.jboss.tools.smooks.model.smooks.DocumentRoot;
import org.jboss.tools.smooks.model.smooks.SmooksPackage;
import org.jboss.tools.smooks.model.smooks.SmooksResourceListType;

public class EDIReader12DataWizard
extends Wizard
implements IStructuredDataSelectionWizard,
INewWizard {
    private EDIReader12MappingDataPathWizardPage mappingFilePage;
    private EDIReader12DataPathWizardPage ediFilePage;
    private SmooksResourceListType resourceList;
    private EditingDomain editingDomain;

    public void addPages() {
        this.ediFilePage = new EDIReader12DataPathWizardPage(Messages.EDIReader12DataWizard_Page_Title_EDI_Data_Page, new String[0]);
        this.addPage((IWizardPage)this.ediFilePage);
        this.mappingFilePage = new EDIReader12MappingDataPathWizardPage(Messages.EDIReader12DataWizard_Page_Title_EDI_Config_Page, null);
        this.addPage((IWizardPage)this.mappingFilePage);
        super.addPages();
    }

    public boolean performFinish() {
        if (this.mappingFilePage.isUseAvaliableReader()) {
            return true;
        }
        if (this.mappingFilePage.isCreateNewReader()) {
            String encoding = this.mappingFilePage.getEncoding();
            String path = this.mappingFilePage.getFilePath();
            String validate = this.mappingFilePage.getValidate();
            EDI12Reader reader = Edi12Factory.eINSTANCE.createEDI12Reader();
            reader.setEncoding(encoding);
            reader.setMappingModel(path);
            if (validate != null && validate.length() != 0) {
                reader.setValidate(Boolean.valueOf(validate).booleanValue());
            }
            Command command = AddCommand.create((EditingDomain)this.editingDomain, (Object)this.resourceList, (Object)SmooksPackage.Literals.SMOOKS_RESOURCE_LIST_TYPE__ABSTRACT_READER_GROUP, (Object)FeatureMapUtil.createEntry((EStructuralFeature)Edi12Package.Literals.EDI12_DOCUMENT_ROOT__READER, (Object)reader));
            this.editingDomain.getCommandStack().execute(command);
        }
        return true;
    }

    public void complate(SmooksMultiFormEditor formEditor) {
    }

    public String getInputDataTypeID() {
        return "input.edi";
    }

    public Properties getProperties() {
        String validate;
        String path;
        Properties pros = new Properties();
        if (this.mappingFilePage.isUseAvaliableReader() || this.mappingFilePage.isCreateNewReader()) {
            pros.put("use_availableReader", "true");
            return pros;
        }
        String encoding = this.mappingFilePage.getEncoding();
        if (encoding != null && encoding.length() != 0) {
            pros.put("encoding", encoding);
        }
        if ((path = this.mappingFilePage.getFilePath()) != null && path.length() != 0) {
            pros.put(EDIDataParser.MAPPING_MODEL, path);
        }
        if ((validate = this.mappingFilePage.getValidate()) != null && validate.length() != 0) {
            pros.put(EDIDataParser.VALIDATE, validate);
        }
        return pros;
    }

    public Object getReturnData() {
        return null;
    }

    public String getStructuredDataSourcePath() {
        if (this.ediFilePage.getFilePath() != null) {
            return this.ediFilePage.getFilePath();
        }
        return null;
    }

    public void init(IEditorSite site, IEditorInput input) {
        IEditorPart editorPart = site.getWorkbenchWindow().getActivePage().findEditor(input);
        if (editorPart != null && editorPart instanceof SmooksMultiFormEditor) {
            SmooksMultiFormEditor formEditor = (SmooksMultiFormEditor)editorPart;
            EObject smooksModel = formEditor.getSmooksModel();
            if (smooksModel instanceof DocumentRoot) {
                this.resourceList = ((DocumentRoot)smooksModel).getSmooksResourceList();
            }
            this.editingDomain = formEditor.getEditingDomain();
        }
        if (this.mappingFilePage != null) {
            this.mappingFilePage.setSmooksResourceList(this.resourceList);
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }
}

