/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.configuration.editors.edireader12;

import java.util.List;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.smooks.configuration.editors.ClassPathFileProcessor;
import org.jboss.tools.smooks.configuration.editors.edireader12.Messages;
import org.jboss.tools.smooks.configuration.editors.uitls.SmooksUIUtils;
import org.jboss.tools.smooks.configuration.editors.xml.AbstractFileSelectionWizardPage;
import org.jboss.tools.smooks.model.edi12.EDI12Reader;
import org.jboss.tools.smooks.model.edi12.impl.EDI12ReaderImpl;
import org.jboss.tools.smooks.model.smooks.SmooksResourceListType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EDIReader12MappingDataPathWizardPage
extends AbstractFileSelectionWizardPage {
    private boolean hasReader = false;
    private boolean createNewReader = true;
    private String mappingFile = null;
    private Composite fileComposite = null;
    private String encoding = "UTF-8";
    private Button createNewReaderButton;
    private boolean useAvaliableReader = false;
    private String validate = null;
    private SmooksResourceListType resourceList;

    public EDIReader12MappingDataPathWizardPage(String pageName, boolean multiSelect, Object[] initSelections, List<ViewerFilter> filters) {
        super(pageName, multiSelect, initSelections, filters);
        this.setTitle(Messages.EDIReader12MappingDataPathWizardPage_Page_Title_EDI_Mapping_File);
        this.setDescription(Messages.EDIReader12MappingDataPathWizardPage_Page_Description_EDI_Mapping_File);
        this.setFilePathProcessor(new ClassPathFileProcessor());
    }

    public EDIReader12MappingDataPathWizardPage(String pageName, String[] fileExtensionNames) {
        super(pageName, fileExtensionNames);
        this.setTitle(Messages.EDIReader12MappingDataPathWizardPage_Page_Title_EDI_12_Mapping_File);
        this.setDescription(Messages.EDIReader12MappingDataPathWizardPage_Page_Description_EDI_12_Mapping_File);
        this.setFilePathProcessor(new ClassPathFileProcessor());
    }

    public String getEncoding() {
        return this.encoding;
    }

    public boolean isUseAvaliableReader() {
        return this.useAvaliableReader;
    }

    public SmooksResourceListType getSmooksResourceList() {
        return this.resourceList;
    }

    public void setSmooksResourceList(SmooksResourceListType resourceList) {
        this.resourceList = resourceList;
    }

    private void initData() {
        this.encoding = "UTF-8";
        this.validate = null;
        this.hasReader = false;
        this.useAvaliableReader = false;
        this.createNewReader = true;
        if (SmooksUIUtils.hasReaderAlready(EDI12Reader.class, this.resourceList) || SmooksUIUtils.hasReaderAlready(EDI12ReaderImpl.class, this.resourceList)) {
            this.hasReader = true;
        }
        this.mappingFile = null;
        if (this.hasReader) {
            this.useAvaliableReader = true;
            this.createNewReader = false;
        }
    }

    public boolean isHasReader() {
        return this.hasReader;
    }

    public boolean isCreateNewReader() {
        return this.createNewReader;
    }

    public String getValidate() {
        return this.validate;
    }

    public void setValidate(String validate) {
        this.validate = validate;
    }

    @Override
    public void createControl(Composite parent) {
        this.initData();
        super.createControl(parent);
    }

    public String getMappingFile() {
        return this.mappingFile;
    }

    @Override
    protected void createExtensionGUIFirst(Composite parent) {
        Label encodingLabel = new Label(parent, 0);
        encodingLabel.setText(Messages.EDIReader12MappingDataPathWizardPage_Label_Encoding);
        final Text encodingText = new Text(parent, 2048);
        encodingText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EDIReader12MappingDataPathWizardPage.this.mappingFile = encodingText.getText();
            }
        });
        GridData gd = new GridData(768);
        encodingText.setLayoutData((Object)gd);
        Label validateLabel = new Label(parent, 0);
        validateLabel.setText(Messages.EDIReader12MappingDataPathWizardPage_Label_Validate);
        Combo validateCombo = new Combo(parent, 2056);
        validateCombo.add("");
        validateCombo.add("TRUE");
        validateCombo.add("FALSE");
        validateCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EDIReader12MappingDataPathWizardPage.this.validate = encodingText.getText();
            }
        });
        gd = new GridData(768);
        validateCombo.setLayoutData((Object)gd);
    }

    @Override
    protected Composite createFileSelectionComposite(Composite parent) {
        Composite chooseComposite = new Composite(parent, 0);
        GridData gd = new GridData(768);
        chooseComposite.setLayoutData((Object)gd);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        chooseComposite.setLayout((Layout)gl);
        Button newReaderButton = new Button(chooseComposite, 16);
        newReaderButton.setText(Messages.EDIReader12MappingDataPathWizardPage_Button_Create_New_Configs);
        final Button useReaderButton = new Button(chooseComposite, 16);
        useReaderButton.setText(Messages.EDIReader12MappingDataPathWizardPage_Button_Use_Existing_Configs);
        this.fileComposite = super.createFileSelectionComposite(parent);
        this.createNewReaderButton = new Button(this.fileComposite, 32);
        this.createNewReaderButton.setText(Messages.EDIReader12MappingDataPathWizardPage_Button_Create_New_Config);
        this.createNewReaderButton.setSelection(true);
        if (this.hasReader) {
            this.createNewReaderButton.setSelection(false);
            this.createNewReaderButton.setEnabled(false);
            useReaderButton.setSelection(true);
            this.setConfigCompositeStates(false);
        } else {
            newReaderButton.setSelection(true);
            this.createNewReaderButton.setSelection(true);
        }
        this.createNewReaderButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EDIReader12MappingDataPathWizardPage.this.createNewReader = EDIReader12MappingDataPathWizardPage.this.createNewReaderButton.getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        newReaderButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EDIReader12MappingDataPathWizardPage.this.useAvaliableReader = useReaderButton.getSelection();
                EDIReader12MappingDataPathWizardPage.this.setConfigCompositeStates(true);
                EDIReader12MappingDataPathWizardPage.this.changeWizardPageStatus();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        useReaderButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EDIReader12MappingDataPathWizardPage.this.useAvaliableReader = useReaderButton.getSelection();
                EDIReader12MappingDataPathWizardPage.this.setConfigCompositeStates(false);
                EDIReader12MappingDataPathWizardPage.this.changeWizardPageStatus();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.createNewReaderButton.setLayoutData((Object)gd);
        return this.fileComposite;
    }

    private void setConfigCompositeStates(boolean enabled) {
        this.fileComposite.setEnabled(enabled);
        Control[] controls = this.fileComposite.getChildren();
        int i = 0;
        while (i < controls.length) {
            Control c = controls[i];
            if (c == this.createNewReaderButton && this.hasReader) {
                c.setEnabled(false);
            } else {
                if (c == this.fileTextComposite) {
                    Control[] cs = ((Composite)c).getChildren();
                    int j = 0;
                    while (j < cs.length) {
                        Control cc = cs[j];
                        cc.setEnabled(enabled);
                        ++j;
                    }
                }
                c.setEnabled(enabled);
            }
            ++i;
        }
    }

    @Override
    protected Object loadedTheObject(String path) throws Exception {
        return null;
    }

    @Override
    protected void changeWizardPageStatus() {
        if (!this.useAvaliableReader) {
            super.changeWizardPageStatus();
        } else {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }
    }

    public boolean canFlipToNextPage() {
        return super.canFlipToNextPage();
    }
}

