/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.configuration.editors.javabean;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.jboss.tools.smooks.configuration.editors.javabean.JavaBeanModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaBeanModelFactory {
    private static final List<Object> PRIMITIVE_CLASSES = new ArrayList<Object>();

    static {
        PRIMITIVE_CLASSES.add(Integer.class);
        PRIMITIVE_CLASSES.add(Double.class);
        PRIMITIVE_CLASSES.add(Float.class);
        PRIMITIVE_CLASSES.add(String.class);
        PRIMITIVE_CLASSES.add(Long.class);
        PRIMITIVE_CLASSES.add(Date.class);
        PRIMITIVE_CLASSES.add(Character.class);
        PRIMITIVE_CLASSES.add(BigInteger.class);
        PRIMITIVE_CLASSES.add(BigDecimal.class);
        PRIMITIVE_CLASSES.add(Boolean.class);
        PRIMITIVE_CLASSES.add(Byte.class);
        PRIMITIVE_CLASSES.add(Calendar.class);
    }

    public static synchronized JavaBeanModel getJavaBeanModelWithLazyLoad(Class<?> beanClass) {
        JavaBeanModel m = new JavaBeanModel(beanClass, true);
        m.setRootClassModel(true);
        return m;
    }

    public static synchronized JavaBeanModel getJavaBeanModel(Class<?> beanClass) {
        JavaBeanModel m = new JavaBeanModel(beanClass, false);
        m.setRootClassModel(true);
        return m;
    }

    public static boolean isPrimitiveObject(Class<?> clazz) {
        if (clazz.isEnum()) {
            return true;
        }
        return PRIMITIVE_CLASSES.indexOf(clazz) != -1;
    }
}

