/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.configuration.editors.javabean;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.smooks.configuration.editors.javabean.JavaBeanModel;
import org.jboss.tools.smooks.configuration.editors.javabean.JavaBeanModelFactory;
import org.jboss.tools.smooks.configuration.editors.javabean.Messages;
import org.jboss.tools.smooks.configuration.editors.uitls.JavaTypeFieldDialog;
import org.jboss.tools.smooks.configuration.editors.uitls.ProjectClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaBeanSelectionWizardPage
extends WizardPage {
    private String beanID = null;
    private String beanClass = null;
    private IJavaProject project;
    private String collectionClass = null;
    private boolean isArray = false;
    private boolean isCollection = false;
    private JavaBeanModel javaBeanModel = null;
    private Button arrayButton;
    private Button collectionClassBrowseButton;
    private Text colllectionClassText;

    public JavaBeanSelectionWizardPage(String pageName, String title, ImageDescriptor titleImage, IJavaProject project) {
        super(pageName, title, titleImage);
        this.project = project;
        this.setTitle(Messages.JavaBeanSelectionWizardPage_WizardTitle);
        this.setDescription(Messages.JavaBeanSelectionWizardPage_WizardDes);
    }

    public JavaBeanSelectionWizardPage(String pageName, IJavaProject project) {
        super(pageName);
        this.project = project;
        this.setTitle(Messages.JavaBeanSelectionWizardPage_WizardTitle);
        this.setDescription(Messages.JavaBeanSelectionWizardPage_WizardDes);
    }

    public List<JavaBeanModel> getJavaBeanModelList() {
        if (this.getJavaBeanModel() != null) {
            ArrayList<JavaBeanModel> list = new ArrayList<JavaBeanModel>();
            list.add(this.javaBeanModel);
            return list;
        }
        return Collections.emptyList();
    }

    public JavaBeanModel getJavaBeanModel() {
        return this.javaBeanModel;
    }

    public void createControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        GridData gd = new GridData(1808);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        mainComposite.setLayout((Layout)gl);
        mainComposite.setLayoutData((Object)gd);
        this.createBeanClassControls(mainComposite);
        this.createBeanTypeControls(mainComposite);
        Label seperator = new Label(mainComposite, 258);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.heightHint = 18;
        seperator.setLayoutData((Object)gd);
        this.setControl((Control)mainComposite);
        this.setPageComplete(false);
    }

    private void createBeanTypeControls(Composite mainComposite) {
        GridData gd = new GridData(768);
        Label beanTypeLabel = new Label(mainComposite, 0);
        beanTypeLabel.setText(Messages.JavaBeanSelectionWizardPage_BeanTypeLabel);
        Composite composite = new Composite(mainComposite, 0);
        gd = new GridData(768);
        composite.setLayoutData((Object)gd);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.makeColumnsEqualWidth = false;
        composite.setLayout((Layout)gl);
        this.arrayButton = new Button(composite, 32);
        this.arrayButton.setText(Messages.JavaBeanSelectionWizardPage_ArrayCheckBoxLabel);
        final Button collectionButton = new Button(composite, 32);
        collectionButton.setText(Messages.JavaBeanSelectionWizardPage_CollectionLabel);
        Label beanClassLabel = new Label(mainComposite, 0);
        beanClassLabel.setText(Messages.JavaBeanSelectionWizardPage_CollectionClassLabel);
        Composite beanClassComposite = new Composite(mainComposite, 0);
        GridLayout gl1 = new GridLayout();
        gl1.numColumns = 2;
        gl1.marginHeight = 0;
        gl1.marginWidth = 0;
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        beanClassComposite.setLayoutData((Object)gd);
        beanClassComposite.setLayout((Layout)gl);
        this.colllectionClassText = new Text(beanClassComposite, 2048);
        gd = new GridData(768);
        this.colllectionClassText.setLayoutData((Object)gd);
        this.colllectionClassText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text t = (Text)e.getSource();
                JavaBeanSelectionWizardPage.this.collectionClass = t.getText();
                JavaBeanSelectionWizardPage.this.refreshJavaBeanModel();
                JavaBeanSelectionWizardPage.this.updateWizardPageStatus();
            }
        });
        this.colllectionClassText.setEnabled(false);
        beanClassComposite.setLayoutData((Object)gd);
        this.collectionClassBrowseButton = new Button(beanClassComposite, 0);
        this.collectionClassBrowseButton.setText(Messages.JavaBeanSelectionWizardPage_BrowseButtonLabel);
        this.collectionClassBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String classString = JavaTypeFieldDialog.openJavaTypeDialog(JavaBeanSelectionWizardPage.this.getShell(), JavaBeanSelectionWizardPage.this.project);
                JavaBeanSelectionWizardPage.this.colllectionClassText.setText(classString);
            }
        });
        this.collectionClassBrowseButton.setEnabled(false);
        this.arrayButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.getSource();
                if (button.getSelection()) {
                    JavaBeanSelectionWizardPage.this.isArray = true;
                    collectionButton.setSelection(false);
                    JavaBeanSelectionWizardPage.this.isCollection = false;
                    JavaBeanSelectionWizardPage.this.collectionClassBrowseButton.setEnabled(false);
                    JavaBeanSelectionWizardPage.this.colllectionClassText.setEnabled(false);
                } else {
                    JavaBeanSelectionWizardPage.this.isArray = false;
                }
                JavaBeanSelectionWizardPage.this.refreshJavaBeanModel();
                JavaBeanSelectionWizardPage.this.updateWizardPageStatus();
            }
        });
        collectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.getSource();
                if (button.getSelection()) {
                    JavaBeanSelectionWizardPage.this.isCollection = true;
                    JavaBeanSelectionWizardPage.this.arrayButton.setSelection(false);
                    JavaBeanSelectionWizardPage.this.isArray = false;
                    JavaBeanSelectionWizardPage.this.collectionClassBrowseButton.setEnabled(true);
                    JavaBeanSelectionWizardPage.this.colllectionClassText.setEnabled(true);
                } else {
                    JavaBeanSelectionWizardPage.this.isCollection = false;
                    JavaBeanSelectionWizardPage.this.collectionClassBrowseButton.setEnabled(false);
                    JavaBeanSelectionWizardPage.this.colllectionClassText.setEnabled(false);
                }
                JavaBeanSelectionWizardPage.this.updateWizardPageStatus();
            }
        });
        collectionButton.setVisible(false);
        beanClassComposite.setVisible(false);
        beanClassLabel.setVisible(false);
    }

    protected void refreshJavaBeanModel() {
        if (this.beanClass != null && !"".equals(this.beanClass.trim())) {
            try {
                ProjectClassLoader loader = new ProjectClassLoader(this.project);
                this.javaBeanModel = null;
                this.isCollection = this.isCollectionClass(this.beanClass);
                this.isCollection = false;
                if (this.isCollection) {
                    if (this.collectionClass != null) {
                        Class<?> clazz = loader.loadClass(this.beanClass);
                        Class<?> cclazz = loader.loadClass(this.collectionClass);
                        this.javaBeanModel = JavaBeanModelFactory.getJavaBeanModelWithLazyLoad(clazz);
                        this.javaBeanModel.setComponentClass(cclazz);
                    }
                } else {
                    Class<?> clazz = loader.loadClass(this.beanClass);
                    if (this.isArray) {
                        Object arrayInstance = Array.newInstance(clazz, 0);
                        clazz = arrayInstance.getClass();
                    }
                    this.javaBeanModel = JavaBeanModelFactory.getJavaBeanModelWithLazyLoad(clazz);
                }
                if (this.javaBeanModel != null && this.beanID != null) {
                    this.javaBeanModel.setName(this.beanID);
                }
            }
            catch (JavaModelException javaModelException) {
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
    }

    private void createBeanClassControls(Composite mainComposite) {
        Label beanClassLabel = new Label(mainComposite, 0);
        beanClassLabel.setText(Messages.JavaBeanSelectionWizardPage_BeanClassLabel);
        Composite beanClassComposite = new Composite(mainComposite, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        beanClassComposite.setLayout((Layout)gl);
        final Text beanClassText = new Text(beanClassComposite, 2048);
        GridData gd = new GridData(768);
        beanClassText.setLayoutData((Object)gd);
        beanClassText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text t = (Text)e.getSource();
                JavaBeanSelectionWizardPage.this.arrayButton.setEnabled(true);
                JavaBeanSelectionWizardPage.this.beanClass = t.getText();
                if (JavaBeanSelectionWizardPage.this.beanClass != null) {
                    JavaBeanSelectionWizardPage.this.beanClass = JavaBeanSelectionWizardPage.this.beanClass.trim();
                }
                JavaBeanSelectionWizardPage.this.isCollection = JavaBeanSelectionWizardPage.this.isCollectionClass(JavaBeanSelectionWizardPage.this.beanClass);
                JavaBeanSelectionWizardPage.this.refreshJavaBeanModel();
                JavaBeanSelectionWizardPage.this.updateWizardPageStatus();
            }
        });
        beanClassComposite.setLayoutData((Object)gd);
        Button javaTypeBrowseButton = new Button(beanClassComposite, 0);
        javaTypeBrowseButton.setText(Messages.JavaBeanSelectionWizardPage_BrowseButtonLabel);
        javaTypeBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String classString = JavaTypeFieldDialog.openJavaTypeDialog(JavaBeanSelectionWizardPage.this.getShell(), JavaBeanSelectionWizardPage.this.project);
                beanClassText.setText(classString);
            }
        });
    }

    private boolean isCollectionClass(String classString) {
        if (this.project != null) {
            try {
                ProjectClassLoader loader = new ProjectClassLoader(this.project);
                Class<?> clazz = loader.loadClass(classString);
                if (Collection.class.isAssignableFrom(clazz)) {
                    return true;
                }
            }
            catch (Throwable throwable) {}
        }
        return false;
    }

    protected void updateWizardPageStatus() {
        ProjectClassLoader loader;
        String error = null;
        if (this.beanClass == null || "".equals(this.beanClass.trim())) {
            error = Messages.JavaBeanSelectionWizardPage_BeanClassEmptyErrorMessage;
        } else {
            try {
                this.beanClass = this.beanClass.trim();
                loader = new ProjectClassLoader(this.project);
                loader.loadClass(this.beanClass);
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException classNotFoundException) {
                error = String.valueOf(Messages.JavaBeanSelectionWizardPage_CantFindClass1) + this.beanClass + Messages.JavaBeanSelectionWizardPage_QuoteChar;
            }
        }
        if (this.isCollection) {
            if (this.collectionClass == null || "".equals(this.collectionClass.trim())) {
                error = Messages.JavaBeanSelectionWizardPage_CollectionComponentClassEmptyErrorMessage;
            } else {
                try {
                    loader = new ProjectClassLoader(this.project);
                    loader.loadClass(this.collectionClass);
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    error = String.valueOf(Messages.JavaBeanSelectionWizardPage_CantFindClass1) + this.beanClass;
                }
            }
        }
        this.setErrorMessage(error);
        this.setPageComplete(error == null);
    }
}

