/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.configuration.editors.javabean;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.jboss.tools.smooks.configuration.editors.SmooksMultiFormEditor;
import org.jboss.tools.smooks.configuration.editors.javabean.JavaBeanList;
import org.jboss.tools.smooks.configuration.editors.javabean.JavaBeanModel;
import org.jboss.tools.smooks.configuration.editors.javabean.JavaBeanModelFactory;
import org.jboss.tools.smooks.configuration.editors.javabean.JavaBeanSelectionWizardPage;
import org.jboss.tools.smooks.configuration.editors.javabean.Messages;
import org.jboss.tools.smooks.configuration.editors.wizard.IStructuredDataSelectionWizard;

public class JavabeanStrucutredDataWizard
extends Wizard
implements IStructuredDataSelectionWizard,
INewWizard {
    JavaBeanSelectionWizardPage page = null;
    IJavaProject project = null;
    Object result = null;
    Properties properties = new Properties();

    public JavabeanStrucutredDataWizard() {
        this.setWindowTitle(Messages.JavabeanStrucutredDataWizard_WizardTitle);
    }

    public IJavaProject getProject() {
        return this.project;
    }

    public void setProject(IJavaProject project) {
        this.project = project;
    }

    public void addPages() {
        super.addPages();
        if (this.page == null) {
            this.page = new JavaBeanSelectionWizardPage("javaclass", this.project);
            this.addPage((IWizardPage)this.page);
        }
    }

    public boolean performFinish() {
        this.result = this.page.getJavaBeanModelList();
        return true;
    }

    public JavaBeanList getJavaBeanList() {
        JavaBeanList list = new JavaBeanList();
        if (this.result != null && this.result instanceof List) {
            for (JavaBeanModel javabean : (List)this.result) {
                boolean isArray = "array".equals(javabean.getExtendProperty("many"));
                boolean isList = "list".equals(javabean.getExtendProperty("many"));
                if (isArray) {
                    Object arrayInstance = Array.newInstance(javabean.getBeanClass(), 0);
                    JavaBeanModel model = JavaBeanModelFactory.getJavaBeanModelWithLazyLoad(arrayInstance.getClass());
                    list.addJavaBean(model);
                    continue;
                }
                if (isList) {
                    JavaBeanModel model = JavaBeanModelFactory.getJavaBeanModelWithLazyLoad(ArrayList.class);
                    model.setComponentClass(javabean.getBeanClass());
                    list.addJavaBean(model);
                    continue;
                }
                list.addJavaBean(javabean);
            }
        }
        if (list.getChildren().size() <= 0) {
            return null;
        }
        return list;
    }

    public Object getResult() {
        return this.result;
    }

    public Object getReturnData() {
        return this.getJavaBeanList();
    }

    public void init(IEditorSite site, IEditorInput input) {
        if (input != null && input instanceof IFileEditorInput) {
            IFileEditorInput fi = (IFileEditorInput)input;
            IProject project = fi.getFile().getProject();
            this.project = project instanceof IJavaProject ? (IJavaProject)project : JavaCore.create((IProject)project);
        }
    }

    public String getInputDataTypeID() {
        return "input.java";
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        if (selection != null) {
            Object obj = selection.getFirstElement();
            if (obj instanceof IJavaProject) {
                this.project = (IJavaProject)obj;
            }
            if (obj instanceof IResource) {
                IProject project = ((IResource)obj).getProject();
                this.project = JavaCore.create((IProject)project);
            }
            if (this.project == null && obj instanceof IAdaptable) {
                IResource relateResource = (IResource)((IAdaptable)obj).getAdapter(IResource.class);
                IProject project = relateResource.getProject();
                this.project = JavaCore.create((IProject)project);
            }
        }
    }

    public String getStructuredDataSourcePath() {
        List<JavaBeanModel> list = this.page.getJavaBeanModelList();
        StringBuffer buffer = new StringBuffer();
        for (JavaBeanModel javaBeanModel : list) {
            Class clazz = javaBeanModel.getBeanClass();
            if (clazz != null) {
                boolean isArray = clazz.isArray();
                String cname = clazz.getName();
                if (isArray) {
                    cname = clazz.getComponentType().getName();
                    cname = String.valueOf(cname) + "[]";
                }
                buffer.append(cname);
            }
            buffer.append(";");
        }
        if (buffer.toString().endsWith(";")) {
            return buffer.substring(0, buffer.length() - 1);
        }
        return buffer.toString();
    }

    public void complate(SmooksMultiFormEditor formEditor) {
    }
}

