/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.configuration.editors.javabean;

import java.util.ArrayList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.jboss.tools.smooks.configuration.editors.IXMLStructuredObject;
import org.jboss.tools.smooks.configuration.editors.javabean.JavaBeanModel;
import org.jboss.tools.smooks.configuration.editors.javabean.JavaBeanTableLabelProvider;
import org.jboss.tools.smooks.configuration.editors.javabean.JavabeanContentProvider;
import org.jboss.tools.smooks.configuration.editors.javabean.Messages;

public class ValueWiringBindingSelectionDialog
extends Dialog {
    private JavaBeanModel beanModel;
    private String[] ignoreProperties = null;
    private CheckboxTableViewer viewer = null;
    private Object[] checkedObject = null;
    private FormToolkit toolkit;

    public ValueWiringBindingSelectionDialog(IShellProvider parentShell, JavaBeanModel beanModel, String[] ignoreProperties) {
        super(parentShell);
        this.beanModel = beanModel;
        this.ignoreProperties = ignoreProperties;
    }

    public ValueWiringBindingSelectionDialog(Shell parentShell, JavaBeanModel beanModel, String[] ignoreProperties) {
        super(parentShell);
        this.beanModel = beanModel;
        this.ignoreProperties = ignoreProperties;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData gd = new GridData(1808);
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)gd);
        label.setText(Messages.ValueWiringBindingSelectionDialog_SelectJavaLabel);
        this.viewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
        gd = new GridData(1808);
        gd.heightHint = 300;
        gd.widthHint = 300;
        this.viewer.getControl().setLayoutData((Object)gd);
        this.viewer.setContentProvider((IContentProvider)new JavabeanContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new JavaBeanTableLabelProvider());
        ArrayList<JavaBeanModel> list = new ArrayList<JavaBeanModel>();
        for (IXMLStructuredObject child : this.beanModel.getChildren()) {
            if (!(child instanceof JavaBeanModel) || this.ignoreProperty((JavaBeanModel)child)) continue;
            list.add((JavaBeanModel)child);
        }
        this.viewer.setInput(list);
        this.viewer.setSorter(new ViewerSorter(){

            public int category(Object element) {
                if (element instanceof JavaBeanModel) {
                    if (((JavaBeanModel)element).isPrimitive()) {
                        return 1;
                    }
                    return 2;
                }
                return super.category(element);
            }
        });
        Composite linkComposite = new Composite(composite, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        gd = new GridData(768);
        linkComposite.setLayoutData((Object)gd);
        linkComposite.setLayout((Layout)gl);
        this.toolkit = new FormToolkit(parent.getDisplay());
        Hyperlink allselectlink = this.toolkit.createHyperlink(linkComposite, Messages.ValueWiringBindingSelectionDialog_SelectAllLink, 0);
        allselectlink.setBackground(linkComposite.getBackground());
        allselectlink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
                ValueWiringBindingSelectionDialog.this.viewer.setAllChecked(true);
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }
        });
        Hyperlink allunselectlink = this.toolkit.createHyperlink(linkComposite, Messages.ValueWiringBindingSelectionDialog_DeselectAllLink, 0);
        allunselectlink.setBackground(linkComposite.getBackground());
        allunselectlink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
                ValueWiringBindingSelectionDialog.this.viewer.setAllChecked(false);
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }
        });
        this.getShell().setText(Messages.ValueWiringBindingSelectionDialog_AddBindingLabel);
        return composite;
    }

    public boolean close() {
        this.checkedObject = this.viewer.getCheckedElements();
        if (this.toolkit != null) {
            this.toolkit.dispose();
        }
        return super.close();
    }

    public Object[] getCheckedObject() {
        return this.checkedObject;
    }

    private boolean ignoreProperty(JavaBeanModel model) {
        if (this.ignoreProperties == null) {
            return false;
        }
        int i = 0;
        while (i < this.ignoreProperties.length) {
            if (model.getName().equals(this.ignoreProperties[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

