/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.configuration.editors.javabean12;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.jboss.tools.smooks.configuration.editors.AttributeFieldEditPart;
import org.jboss.tools.smooks.configuration.editors.PropertyUICreator;
import org.jboss.tools.smooks.configuration.editors.javabean.JavaBeanModel;
import org.jboss.tools.smooks.configuration.editors.javabean.JavaBeanModelFactory;
import org.jboss.tools.smooks.configuration.editors.javabean.ValueWiringBindingSelectionDialog;
import org.jboss.tools.smooks.configuration.editors.javabean12.Messages;
import org.jboss.tools.smooks.configuration.editors.uitls.SmooksUIUtils;
import org.jboss.tools.smooks.editor.ISmooksModelProvider;
import org.jboss.tools.smooks.model.javabean12.BeanType;
import org.jboss.tools.smooks.model.javabean12.Javabean12Factory;
import org.jboss.tools.smooks.model.javabean12.Javabean12Package;
import org.jboss.tools.smooks.model.javabean12.ValueType;
import org.jboss.tools.smooks.model.javabean12.WiringType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaBean12PropertyUICreator
extends PropertyUICreator {
    public boolean canCreate(IItemPropertyDescriptor itemPropertyDescriptor, Object model, EAttribute feature) {
        return feature == Javabean12Package.eINSTANCE.getBeanType_Class();
    }

    @Override
    public boolean ignoreProperty(EAttribute feature) {
        if (feature == Javabean12Package.eINSTANCE.getBeanType_CreateOnElement()) {
            return true;
        }
        if (feature == Javabean12Package.eINSTANCE.getBeanType_CreateOnElementNS()) {
            return true;
        }
        return super.ignoreProperty(feature);
    }

    @Override
    public AttributeFieldEditPart createPropertyUI(FormToolkit toolkit, Composite parent, IItemPropertyDescriptor propertyDescriptor, Object model, EAttribute feature, ISmooksModelProvider formEditor, IEditorPart part) {
        if (feature == Javabean12Package.eINSTANCE.getBeanType_Class()) {
            return this.createBeanClassTextWithButton(parent, toolkit, propertyDescriptor, model, formEditor);
        }
        return super.createPropertyUI(toolkit, parent, propertyDescriptor, model, feature, formEditor, part);
    }

    @Override
    public List<AttributeFieldEditPart> createExtendUIOnTop(AdapterFactoryEditingDomain editingdomain, FormToolkit toolkit, Composite parent, Object model, ISmooksModelProvider formEditor, IEditorPart part) {
        return super.createExtendUIOnTop(editingdomain, toolkit, parent, model, formEditor, part);
    }

    @Override
    public List<AttributeFieldEditPart> createExtendUIOnBottom(AdapterFactoryEditingDomain editingdomain, FormToolkit toolkit, Composite parent, Object model, ISmooksModelProvider formEditor, IEditorPart part) {
        List<AttributeFieldEditPart> lists = super.createExtendUIOnBottom(editingdomain, toolkit, parent, model, formEditor, part);
        Composite separator = toolkit.createCompositeSeparator(parent);
        GridData gd = new GridData(768);
        gd.heightHint = 1;
        gd.horizontalSpan = 2;
        separator.setLayoutData((Object)gd);
        Hyperlink link = toolkit.createHyperlink(parent, "Add Binding", 0);
        link.setEnabled(false);
        link.setVisible(false);
        final Composite fp = parent;
        final BeanType fb = (BeanType)model;
        final IEditorPart ff = part;
        link.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
                JavaBean12PropertyUICreator.this.addValueWiringAuto(fp, fb, ff);
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }
        });
        gd = new GridData();
        gd.horizontalSpan = 2;
        link.setLayoutData((Object)gd);
        return lists;
    }

    private void addValueWiringAuto(Composite parent, BeanType bindings, IEditorPart formEditor) {
        boolean haveClassValue = false;
        if (bindings.eIsSet((EStructuralFeature)Javabean12Package.Literals.BEAN_TYPE__CLASS)) {
            haveClassValue = true;
        }
        if (!haveClassValue) {
            MessageDialog.openError((Shell)parent.getShell(), (String)Messages.JavaBean12PropertyUICreator_ErrorDialogTitle, (String)Messages.JavaBean12PropertyUICreator_CantGetClassValueErrorMessage);
            return;
        }
        String className = bindings.getClass_();
        if (className == null || className.length() == 0) {
            MessageDialog.openError((Shell)parent.getShell(), (String)Messages.JavaBean12PropertyUICreator_ErrorDialogTitle, (String)Messages.JavaBean12PropertyUICreator_ClassValueEmptyErrorMessage);
            return;
        }
        try {
            Class<?> clazz = SmooksUIUtils.loadClass(className, ((IFileEditorInput)formEditor.getEditorInput()).getFile());
            JavaBeanModel beanModel = JavaBeanModelFactory.getJavaBeanModelWithLazyLoad(clazz);
            if (beanModel != null) {
                String[] ignores = this.findoutIgnoreProperty(bindings);
                ValueWiringBindingSelectionDialog dialog = new ValueWiringBindingSelectionDialog(parent.getShell(), beanModel, ignores);
                if (dialog.open() == 0) {
                    Object[] checkedModels = dialog.getCheckedObject();
                    if (checkedModels == null) {
                        return;
                    }
                    if (formEditor instanceof IEditingDomainProvider) {
                        this.generateValueWiringModel(checkedModels, (IEditingDomainProvider)formEditor, bindings);
                    }
                }
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    private void generateValueWiringModel(Object[] models, IEditingDomainProvider editor, BeanType owner) {
        EditingDomain domain = editor.getEditingDomain();
        CompoundCommand command = new CompoundCommand();
        command.setDescription("Add Binding");
        command.setLabel("Auto add binding");
        int i = 0;
        while (i < models.length) {
            Object model = models[i];
            if (model instanceof JavaBeanModel) {
                Command c = this.generateAddCommand((JavaBeanModel)model, domain, owner);
                command.append(c);
            }
            ++i;
        }
        domain.getCommandStack().execute((Command)command);
    }

    private Command generateAddCommand(JavaBeanModel beanModel, EditingDomain domain, BeanType owner) {
        if (beanModel.isPrimitive()) {
            ValueType valueType = Javabean12Factory.eINSTANCE.createValueType();
            valueType.setProperty(beanModel.getName());
            return AddCommand.create((EditingDomain)domain, (Object)owner, (Object)Javabean12Package.Literals.BEAN_TYPE__VALUE, (Object)valueType);
        }
        WiringType wiring = Javabean12Factory.eINSTANCE.createWiringType();
        wiring.setProperty(beanModel.getName());
        return AddCommand.create((EditingDomain)domain, (Object)owner, (Object)Javabean12Package.Literals.BEAN_TYPE__WIRING, (Object)wiring);
    }

    private String[] findoutIgnoreProperty(BeanType bindings) {
        ArrayList<String> ignores = new ArrayList<String>();
        EList valueList = bindings.getValue();
        for (ValueType valueType : valueList) {
            String pro = valueType.getProperty();
            if (pro == null || pro.length() == 0) continue;
            ignores.add(pro);
        }
        EList wiringList = bindings.getWiring();
        for (WiringType wiringType : wiringList) {
            String pro = wiringType.getProperty();
            if (pro == null || pro.length() == 0) continue;
            ignores.add(pro);
        }
        if (ignores.isEmpty()) {
            return null;
        }
        return ignores.toArray(new String[0]);
    }

    @Override
    public boolean isSelectorFeature(EAttribute attribute) {
        return super.isSelectorFeature(attribute);
    }

    protected AttributeFieldEditPart createBeanClassTextWithButton(Composite composite, FormToolkit toolkit, IItemPropertyDescriptor propertyDescriptor, Object model, ISmooksModelProvider provider) {
        return SmooksUIUtils.createJavaTypeSearchFieldEditor(composite, toolkit, propertyDescriptor, (EObject)model, provider);
    }
}

