/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.configuration.editors.json;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.smooks.model.smooks.SmooksResourceListType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonDataConfiguraitonWizardPage
extends WizardPage {
    private String rootName = null;
    private String arrayElementName = "element";
    private String keyWhitspaceReplacement = "-";
    private String keyPrefixOnNumeric;
    private String illegalElementNameCharReplacement;
    private String nullValueReplacement = "";
    private String encoding = "UTF-8";
    private Text rootNameText;
    private Text arrayElementNameText;
    private Text keyWhitspaceReplacementText;
    private Text keyPrefixOnNumericText;
    private Text illegalElementNameCharReplacementText;
    private Text nullValueReplacementText;
    private Text encodingText;
    private TableViewer keyMapViewer;
    private ArrayList<KeyValueModel> keyValueList;
    private Button addButton;
    private Button removeButton;
    private Button createJsonReaderButton;
    protected boolean createJsonReader = true;
    private Button newReaderConfigButton;
    private Button useAvailableReaderConfigButton;
    private SmooksResourceListType resourceList;
    private boolean hasReader = false;
    private boolean useAvailabelReader = false;
    private Composite configComposite;
    private Composite keyMapComposite;

    private void initValue() {
        this.hasReader = false;
        this.useAvailabelReader = false;
        this.rootName = null;
        this.createJsonReader = true;
        this.arrayElementName = "element";
        this.keyWhitspaceReplacement = "-";
        this.keyPrefixOnNumeric = null;
        this.illegalElementNameCharReplacement = null;
        this.nullValueReplacement = "";
        this.encoding = "UTF-8";
        if (this.keyValueList != null) {
            this.keyValueList.clear();
        } else {
            this.keyValueList = new ArrayList();
        }
        if (this.hasReader) {
            this.useAvailabelReader = true;
            this.createJsonReader = false;
        }
    }

    public void createControl(Composite parent) {
        this.initValue();
        Composite mainComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        mainComposite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        mainComposite.setLayoutData((Object)gd);
        Composite radioButtonComposite = new Composite(mainComposite, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        radioButtonComposite.setLayoutData((Object)gd);
        GridLayout rgl = new GridLayout();
        rgl.numColumns = 2;
        rgl.marginHeight = 0;
        rgl.marginWidth = 0;
        radioButtonComposite.setLayout((Layout)rgl);
        Composite spaceComposite = new Composite(mainComposite, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.heightHint = 20;
        spaceComposite.setLayoutData((Object)gd);
        this.newReaderConfigButton = new Button(radioButtonComposite, 16);
        this.newReaderConfigButton.setText("Create new JSON reader configurations");
        this.newReaderConfigButton.setSelection(true);
        this.useAvailableReaderConfigButton = new Button(radioButtonComposite, 16);
        this.useAvailableReaderConfigButton.setText("Use available JSON reader configurations");
        this.configComposite = new Composite(mainComposite, 0);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.configComposite.setLayoutData((Object)gd);
        GridLayout cgl = new GridLayout();
        cgl.marginHeight = 0;
        cgl.marginWidth = 0;
        cgl.numColumns = 2;
        this.configComposite.setLayout((Layout)cgl);
        gd = new GridData(768);
        Label rootnameLabel = new Label(this.configComposite, 0);
        rootnameLabel.setText("Root Element Name");
        this.rootNameText = new Text(this.configComposite, 2048);
        this.rootNameText.setLayoutData((Object)gd);
        Label arrayElementNameLabel = new Label(this.configComposite, 0);
        arrayElementNameLabel.setText("Array Element Name");
        this.arrayElementNameText = new Text(this.configComposite, 2048);
        this.arrayElementNameText.setLayoutData((Object)gd);
        this.arrayElementNameText.setText(this.arrayElementName);
        Label keyWhitspaceReplacementLabel = new Label(this.configComposite, 0);
        keyWhitspaceReplacementLabel.setText("Space Replacement");
        this.keyWhitspaceReplacementText = new Text(this.configComposite, 2048);
        this.keyWhitspaceReplacementText.setLayoutData((Object)gd);
        if (this.keyWhitspaceReplacement == null) {
            this.keyWhitspaceReplacement = "";
        }
        this.keyWhitspaceReplacementText.setText(this.keyWhitspaceReplacement);
        Label keyPrefixOnNumeric = new Label(this.configComposite, 0);
        keyPrefixOnNumeric.setText("Prefix On Numeric");
        this.keyPrefixOnNumericText = new Text(this.configComposite, 2048);
        this.keyPrefixOnNumericText.setLayoutData((Object)gd);
        Label illegalElementNameCharReplacementLabel = new Label(this.configComposite, 0);
        illegalElementNameCharReplacementLabel.setText("IllegalChar Replacement");
        this.illegalElementNameCharReplacementText = new Text(this.configComposite, 2048);
        this.illegalElementNameCharReplacementText.setLayoutData((Object)gd);
        Label nullValueReplacementlabel = new Label(this.configComposite, 0);
        nullValueReplacementlabel.setText("NullValue Replacement");
        this.nullValueReplacementText = new Text(this.configComposite, 2048);
        this.nullValueReplacementText.setLayoutData((Object)gd);
        this.nullValueReplacementText.setText(this.nullValueReplacement);
        Label encodingLabel = new Label(this.configComposite, 0);
        encodingLabel.setText("Encoding");
        this.encodingText = new Text(this.configComposite, 2048);
        this.encodingText.setLayoutData((Object)gd);
        this.encodingText.setText(this.encoding);
        Label keyMapLabel = new Label(this.configComposite, 0);
        keyMapLabel.setText("Key Map:");
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        keyMapLabel.setLayoutData((Object)gd);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.keyMapComposite = new Composite(this.configComposite, 0);
        this.keyMapComposite.setLayoutData((Object)gd);
        GridLayout kgl = new GridLayout();
        kgl.numColumns = 2;
        this.keyMapComposite.setLayout((Layout)kgl);
        gd = new GridData(1808);
        this.keyMapViewer = new TableViewer(this.keyMapComposite, 2050);
        this.keyMapViewer.getControl().setLayoutData((Object)gd);
        this.keyMapViewer.getTable().setHeaderVisible(true);
        this.keyMapViewer.getTable().setLinesVisible(true);
        this.keyMapViewer.setContentProvider((IContentProvider)new KeyMapContentProvider());
        this.keyMapViewer.setLabelProvider((IBaseLabelProvider)new KeyMapLabelProvider());
        TextCellEditor keyCellEditor = new TextCellEditor((Composite)this.keyMapViewer.getTable(), 2048);
        TextCellEditor valueCellEditor = new TextCellEditor((Composite)this.keyMapViewer.getTable(), 2048);
        this.keyMapViewer.setCellEditors(new CellEditor[]{keyCellEditor, valueCellEditor});
        this.keyMapViewer.setColumnProperties(new String[]{"key", "value"});
        this.keyMapViewer.setCellModifier(new ICellModifier(){

            public void modify(Object element, String property, Object value) {
                Object el = null;
                if (element instanceof Item) {
                    el = ((Item)element).getData();
                }
                if (el == null) {
                    return;
                }
                if (el instanceof KeyValueModel && value instanceof String) {
                    if (property.equals("key")) {
                        ((KeyValueModel)el).setKey(value.toString());
                    }
                    if (property.equals("value")) {
                        ((KeyValueModel)el).setValue(value.toString());
                    }
                    JsonDataConfiguraitonWizardPage.this.keyMapViewer.refresh(el);
                }
            }

            public Object getValue(Object element, String property) {
                if (element instanceof KeyValueModel) {
                    if (property.equals("key")) {
                        return ((KeyValueModel)element).getKey();
                    }
                    if (property.equals("value")) {
                        return ((KeyValueModel)element).getValue();
                    }
                }
                return null;
            }

            public boolean canModify(Object element, String property) {
                return element instanceof KeyValueModel && (property.equals("key") || property.equals("value"));
            }
        });
        TableColumn keyColumn = new TableColumn(this.keyMapViewer.getTable(), 2048);
        keyColumn.setWidth(150);
        keyColumn.setText("Key");
        TableColumn replaceColumn = new TableColumn(this.keyMapViewer.getTable(), 2048);
        replaceColumn.setWidth(150);
        replaceColumn.setText("Replace");
        this.keyMapViewer.setInput(this.keyValueList);
        Composite buttonComposite = new Composite(this.keyMapComposite, 0);
        gd = new GridData(1040);
        buttonComposite.setLayoutData((Object)gd);
        GridLayout bgl = new GridLayout();
        buttonComposite.setLayout((Layout)bgl);
        gd = new GridData(768);
        this.addButton = new Button(buttonComposite, 0);
        this.addButton.setLayoutData((Object)gd);
        this.addButton.setText("Add");
        this.removeButton = new Button(buttonComposite, 0);
        this.removeButton.setLayoutData((Object)gd);
        this.removeButton.setText("Remove");
        this.createJsonReaderButton = new Button(this.configComposite, 32);
        this.createJsonReaderButton.setText("Create a JSON Reader");
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.createJsonReaderButton.setLayoutData((Object)gd);
        this.createJsonReaderButton.setSelection(this.createJsonReader);
        if (this.hasReader) {
            this.createJsonReaderButton.setEnabled(false);
            this.newReaderConfigButton.setSelection(false);
            this.useAvailableReaderConfigButton.setSelection(true);
            this.setConfigCompositeStates(false);
        }
        this.hookControls();
        this.changePageStatus();
        this.setControl((Control)mainComposite);
    }

    private void setConfigCompositeStates(boolean enabled) {
        this.configComposite.setEnabled(enabled);
        Control[] controls = this.configComposite.getChildren();
        int i = 0;
        while (i < controls.length) {
            Control c = controls[i];
            if (c == this.createJsonReaderButton && this.hasReader) {
                c.setEnabled(false);
            } else {
                if (c == this.keyMapComposite) {
                    Control[] cs = ((Composite)c).getChildren();
                    int j = 0;
                    while (j < cs.length) {
                        Control cc = cs[j];
                        cc.setEnabled(enabled);
                        ++j;
                    }
                }
                c.setEnabled(enabled);
            }
            ++i;
        }
    }

    private void hookControls() {
        this.newReaderConfigButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (JsonDataConfiguraitonWizardPage.this.newReaderConfigButton.getSelection()) {
                    JsonDataConfiguraitonWizardPage.this.useAvailabelReader = false;
                    JsonDataConfiguraitonWizardPage.this.changePageStatus();
                    JsonDataConfiguraitonWizardPage.this.setConfigCompositeStates(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.useAvailableReaderConfigButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (JsonDataConfiguraitonWizardPage.this.useAvailableReaderConfigButton.getSelection()) {
                    JsonDataConfiguraitonWizardPage.this.useAvailabelReader = true;
                    JsonDataConfiguraitonWizardPage.this.changePageStatus();
                    JsonDataConfiguraitonWizardPage.this.setConfigCompositeStates(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                JsonDataConfiguraitonWizardPage.this.keyValueList.add(new KeyValueModel("key", "value"));
                JsonDataConfiguraitonWizardPage.this.keyMapViewer.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)JsonDataConfiguraitonWizardPage.this.keyMapViewer.getSelection();
                List selections = selection.toList();
                for (Object object : selections) {
                    JsonDataConfiguraitonWizardPage.this.keyValueList.remove(object);
                }
                JsonDataConfiguraitonWizardPage.this.keyMapViewer.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.createJsonReaderButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                JsonDataConfiguraitonWizardPage.this.createJsonReader = JsonDataConfiguraitonWizardPage.this.createJsonReaderButton.getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.encodingText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JsonDataConfiguraitonWizardPage.this.encoding = JsonDataConfiguraitonWizardPage.this.encodingText.getText();
                JsonDataConfiguraitonWizardPage.this.changePageStatus();
            }
        });
        this.nullValueReplacementText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JsonDataConfiguraitonWizardPage.this.nullValueReplacement = JsonDataConfiguraitonWizardPage.this.nullValueReplacementText.getText();
                JsonDataConfiguraitonWizardPage.this.changePageStatus();
            }
        });
        this.illegalElementNameCharReplacementText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JsonDataConfiguraitonWizardPage.this.illegalElementNameCharReplacement = JsonDataConfiguraitonWizardPage.this.illegalElementNameCharReplacementText.getText();
                JsonDataConfiguraitonWizardPage.this.changePageStatus();
            }
        });
        this.keyPrefixOnNumericText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JsonDataConfiguraitonWizardPage.this.keyPrefixOnNumeric = JsonDataConfiguraitonWizardPage.this.keyPrefixOnNumericText.getText();
                JsonDataConfiguraitonWizardPage.this.changePageStatus();
            }
        });
        this.keyWhitspaceReplacementText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JsonDataConfiguraitonWizardPage.this.keyWhitspaceReplacement = JsonDataConfiguraitonWizardPage.this.keyWhitspaceReplacementText.getText();
                JsonDataConfiguraitonWizardPage.this.changePageStatus();
            }
        });
        this.arrayElementNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JsonDataConfiguraitonWizardPage.this.arrayElementName = JsonDataConfiguraitonWizardPage.this.arrayElementNameText.getText();
                JsonDataConfiguraitonWizardPage.this.changePageStatus();
            }
        });
        this.rootNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JsonDataConfiguraitonWizardPage.this.rootName = JsonDataConfiguraitonWizardPage.this.rootNameText.getText();
                JsonDataConfiguraitonWizardPage.this.changePageStatus();
            }
        });
    }

    private void changePageStatus() {
        String error = null;
        if (this.useAvailabelReader) {
            this.setErrorMessage(null);
            this.setPageComplete(true);
            return;
        }
        this.rootName = this.rootNameText.getText();
        if (this.rootName == null || this.rootName.length() == 0) {
            error = "Root Name can't be null";
        }
        this.arrayElementName = this.arrayElementNameText.getText();
        if (this.arrayElementName == null || this.arrayElementName.length() == 0) {
            error = "Array Element Name can't be null";
        }
        this.encoding = this.encodingText.getText();
        if (this.encoding == null || this.encoding.length() == 0) {
            error = "Encoding can't be null";
        }
        this.setErrorMessage(error);
        this.setPageComplete(error == null);
    }

    public JsonDataConfiguraitonWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public JsonDataConfiguraitonWizardPage(String pageName) {
        super(pageName);
        this.setTitle("JSON Reader configurations");
        this.setDescription("Set the configurations for parsing JSON file.");
    }

    public String getRootName() {
        return this.rootName;
    }

    public void setRootName(String rootName) {
        this.rootName = rootName;
    }

    public String getArrayElementName() {
        return this.arrayElementName;
    }

    public void setArrayElementName(String arrayElementName) {
        this.arrayElementName = arrayElementName;
    }

    public String getKeyWhitspaceReplacement() {
        return this.keyWhitspaceReplacement;
    }

    public void setKeyWhitspaceReplacement(String keyWhitspaceReplacement) {
        this.keyWhitspaceReplacement = keyWhitspaceReplacement;
    }

    public String getKeyPrefixOnNumeric() {
        return this.keyPrefixOnNumeric;
    }

    public void setKeyPrefixOnNumeric(String keyPrefixOnNumeric) {
        this.keyPrefixOnNumeric = keyPrefixOnNumeric;
    }

    public String getIllegalElementNameCharReplacement() {
        return this.illegalElementNameCharReplacement;
    }

    public void setIllegalElementNameCharReplacement(String illegalElementNameCharReplacement) {
        this.illegalElementNameCharReplacement = illegalElementNameCharReplacement;
    }

    public String getNullValueReplacement() {
        return this.nullValueReplacement;
    }

    public void setNullValueReplacement(String nullValueReplacement) {
        this.nullValueReplacement = nullValueReplacement;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public boolean isUseAvailabelReader() {
        return this.useAvailabelReader;
    }

    public void setUseAvailabelReader(boolean useAvailabelReader) {
        this.useAvailabelReader = useAvailabelReader;
    }

    public SmooksResourceListType getSmooksResourceList() {
        return this.resourceList;
    }

    public void setSmooksResourceList(SmooksResourceListType resourceList) {
        this.resourceList = resourceList;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public ArrayList<KeyValueModel> getKeyValueList() {
        return this.keyValueList;
    }

    public void setKeyValueList(ArrayList<KeyValueModel> keyValueList) {
        this.keyValueList = keyValueList;
    }

    public boolean isCreateJsonReader() {
        return this.createJsonReader;
    }

    public void setCreateJsonReader(boolean createJsonReader) {
        this.createJsonReader = createJsonReader;
    }

    private class KeyMapContentProvider
    implements IStructuredContentProvider {
        private KeyMapContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class KeyMapLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private KeyMapLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof KeyValueModel) {
                switch (columnIndex) {
                    case 0: {
                        return ((KeyValueModel)element).getKey();
                    }
                    case 1: {
                        return ((KeyValueModel)element).getValue();
                    }
                }
            }
            return this.getText(element);
        }
    }

    public class KeyValueModel {
        private String key;
        private String value;

        public KeyValueModel(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

