/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.configuration.editors.json;

import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.jboss.tools.smooks.configuration.editors.SmooksMultiFormEditor;
import org.jboss.tools.smooks.configuration.editors.json.JsonDataConfiguraitonWizardPage;
import org.jboss.tools.smooks.configuration.editors.json.JsonDataPathWizardPage;
import org.jboss.tools.smooks.configuration.editors.json.Messages;
import org.jboss.tools.smooks.configuration.editors.wizard.IStructuredDataSelectionWizard;
import org.jboss.tools.smooks.model.smooks.DocumentRoot;
import org.jboss.tools.smooks.model.smooks.SmooksResourceListType;

public class JsonDataWizard
extends Wizard
implements IStructuredDataSelectionWizard,
INewWizard {
    private JsonDataPathWizardPage pathPage = null;
    private JsonDataConfiguraitonWizardPage configPage = null;
    private SmooksResourceListType resourceList;
    private EditingDomain editingDomain;
    private IContainer folder = null;

    public JsonDataWizard() {
        this.setWindowTitle(Messages.JsonDataWizard_WizardTitle);
    }

    public boolean canFinish() {
        if (this.pathPage != null) {
            return this.pathPage.isPageComplete();
        }
        return this.configPage != null && this.pathPage != null && this.configPage.isPageComplete() && this.pathPage.isPageComplete();
    }

    public void addPages() {
        super.addPages();
        if (this.pathPage == null) {
            this.pathPage = new JsonDataPathWizardPage(Messages.JsonDataWizard_PageText, new String[]{"jsn"});
            if (this.folder != null) {
                this.pathPage.setInitSelections(new Object[]{this.folder});
            }
        }
        this.addPage((IWizardPage)this.pathPage);
    }

    public boolean performFinish() {
        if (this.editingDomain == null || this.resourceList == null) {
            return true;
        }
        if (this.configPage != null) {
            this.configPage.isCreateJsonReader();
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public String getInputDataTypeID() {
        return "input.json";
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        this.fillProperties(properties);
        return properties;
    }

    private void fillProperties(Properties p) {
        if (this.configPage != null) {
            String ier;
            String nvr;
            String pon;
            String sr;
            String encoding;
            String rn;
            boolean createJsonReader = this.configPage.isCreateJsonReader();
            boolean useJsonReader = this.configPage.isUseAvailabelReader();
            if (createJsonReader || useJsonReader) {
                p.setProperty("linkJSONReader", "true");
                return;
            }
            ArrayList<JsonDataConfiguraitonWizardPage.KeyValueModel> keyMapList = this.configPage.getKeyValueList();
            for (JsonDataConfiguraitonWizardPage.KeyValueModel keyValueModel : keyMapList) {
                String key = keyValueModel.getKey();
                String value = keyValueModel.getValue();
                p.setProperty("_key_" + key, value);
            }
            String aen = this.configPage.getArrayElementName();
            if (aen != null && aen.length() != 0) {
                p.setProperty("arrayElementName", aen);
            }
            if ((rn = this.configPage.getRootName()) != null && rn.length() != 0) {
                p.setProperty("rootName", rn);
            }
            if ((encoding = this.configPage.getEncoding()) != null && encoding.length() != 0) {
                p.setProperty("encoding", encoding);
            }
            if ((sr = this.configPage.getKeyWhitspaceReplacement()) != null && sr.length() != 0) {
                p.setProperty("spaceReplace", sr);
            }
            if ((pon = this.configPage.getKeyPrefixOnNumeric()) != null && pon.length() != 0) {
                p.setProperty("prefixOnNumeric", pon);
            }
            if ((nvr = this.configPage.getNullValueReplacement()) != null && nvr.length() != 0) {
                p.setProperty("nullReplace", nvr);
            }
            if ((ier = this.configPage.getIllegalElementNameCharReplacement()) != null && ier.length() != 0) {
                p.setProperty("illegalReplace", ier);
            }
        }
    }

    public Object getReturnData() {
        return null;
    }

    public String getStructuredDataSourcePath() {
        if (this.pathPage != null) {
            return this.pathPage.getFilePath();
        }
        return null;
    }

    public void init(IEditorSite site, IEditorInput input) {
        IEditorPart editorPart = site.getWorkbenchWindow().getActivePage().findEditor(input);
        if (editorPart != null && editorPart instanceof SmooksMultiFormEditor) {
            SmooksMultiFormEditor formEditor = (SmooksMultiFormEditor)editorPart;
            EObject smooksModel = formEditor.getSmooksModel();
            if (smooksModel instanceof DocumentRoot) {
                this.resourceList = ((DocumentRoot)smooksModel).getSmooksResourceList();
            }
            this.editingDomain = formEditor.getEditingDomain();
        }
        this.folder = ((IFileEditorInput)input).getFile().getParent();
        if (this.pathPage != null && this.folder != null) {
            this.pathPage.setInitSelections(new Object[]{this.folder});
        }
        if (this.configPage != null) {
            this.configPage.setSmooksResourceList(this.resourceList);
        }
    }

    public void complate(SmooksMultiFormEditor formEditor) {
    }
}

