/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.configuration.editors.json12;

import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.jboss.tools.smooks.configuration.editors.SmooksMultiFormEditor;
import org.jboss.tools.smooks.configuration.editors.json12.Json12DataConfiguraitonWizardPage;
import org.jboss.tools.smooks.configuration.editors.json12.Json12DataPathWizardPage;
import org.jboss.tools.smooks.configuration.editors.json12.Messages;
import org.jboss.tools.smooks.configuration.editors.wizard.IStructuredDataSelectionWizard;
import org.jboss.tools.smooks.model.json12.Json12Factory;
import org.jboss.tools.smooks.model.json12.Json12Package;
import org.jboss.tools.smooks.model.json12.Json12Reader;
import org.jboss.tools.smooks.model.json12.Key;
import org.jboss.tools.smooks.model.json12.KeyMap;
import org.jboss.tools.smooks.model.smooks.DocumentRoot;
import org.jboss.tools.smooks.model.smooks.SmooksPackage;
import org.jboss.tools.smooks.model.smooks.SmooksResourceListType;

public class Json12DataWizard
extends Wizard
implements IStructuredDataSelectionWizard,
INewWizard {
    private Json12DataPathWizardPage pathPage = null;
    private Json12DataConfiguraitonWizardPage configPage = null;
    private SmooksResourceListType resourceList;
    private EditingDomain editingDomain;

    public Json12DataWizard() {
        this.setWindowTitle(Messages.Json12DataWizard_WizardTitle);
    }

    public boolean canFinish() {
        if (this.pathPage != null) {
            return this.pathPage.isPageComplete();
        }
        return this.configPage != null && this.pathPage != null && this.configPage.isPageComplete() && this.pathPage.isPageComplete();
    }

    public void addPages() {
        super.addPages();
        if (this.pathPage == null) {
            this.pathPage = new Json12DataPathWizardPage(Messages.Json12DataWizard_WizardDes, new String[0]);
        }
        this.addPage((IWizardPage)this.pathPage);
    }

    public boolean performFinish() {
        if (this.editingDomain == null || this.resourceList == null) {
            return true;
        }
        if (this.configPage != null && this.configPage.isCreateJsonReader()) {
            String indent;
            String ier;
            String nvr;
            String pon;
            String sr;
            String encoding;
            String rn;
            String aen;
            ArrayList<Json12DataConfiguraitonWizardPage.KeyValueModel> keyMapList = this.configPage.getKeyValueList();
            Json12Reader reader = Json12Factory.eINSTANCE.createJson12Reader();
            if (keyMapList != null && !keyMapList.isEmpty()) {
                KeyMap map = Json12Factory.eINSTANCE.createKeyMap();
                for (Json12DataConfiguraitonWizardPage.KeyValueModel keyValueModel : keyMapList) {
                    String key = keyValueModel.getKey();
                    String value = keyValueModel.getValue();
                    Key k = Json12Factory.eINSTANCE.createKey();
                    k.setFrom(key);
                    k.setTo(value);
                    map.getKey().add((Object)k);
                }
                reader.setKeyMap(map);
            }
            if ((aen = this.configPage.getArrayElementName()) != null && aen.length() != 0) {
                reader.setArrayElementName(aen);
            }
            if ((rn = this.configPage.getRootName()) != null && rn.length() != 0) {
                reader.setRootName(rn);
            }
            if ((encoding = this.configPage.getEncoding()) != null && encoding.length() != 0) {
                reader.setEncoding(encoding);
            }
            if ((sr = this.configPage.getKeyWhitspaceReplacement()) != null && sr.length() != 0) {
                reader.setKeyWhitspaceReplacement(sr);
            }
            if ((pon = this.configPage.getKeyPrefixOnNumeric()) != null && pon.length() != 0) {
                reader.setKeyPrefixOnNumeric(pon);
            }
            if ((nvr = this.configPage.getNullValueReplacement()) != null && nvr.length() != 0) {
                reader.setNullValueReplacement(nvr);
            }
            if ((ier = this.configPage.getIllegalElementNameCharReplacement()) != null && ier.length() != 0) {
                reader.setIllegalElementNameCharReplacement(ier);
            }
            if ((indent = this.configPage.getIndent()) != null && indent.length() != 0) {
                boolean indentValue = Boolean.valueOf(indent);
                reader.setIndent(indentValue);
            }
            Command command = AddCommand.create((EditingDomain)this.editingDomain, (Object)this.resourceList, (Object)SmooksPackage.Literals.SMOOKS_RESOURCE_LIST_TYPE__ABSTRACT_READER_GROUP, (Object)FeatureMapUtil.createEntry((EStructuralFeature)Json12Package.Literals.JSON12_DOCUMENT_ROOT__READER, (Object)reader));
            this.editingDomain.getCommandStack().execute(command);
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public String getInputDataTypeID() {
        return "input.json";
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        this.fillProperties(properties);
        return properties;
    }

    private void fillProperties(Properties p) {
        if (this.configPage != null) {
            String indent;
            String ier;
            String nvr;
            String pon;
            String sr;
            String encoding;
            String rn;
            boolean createJsonReader = this.configPage.isCreateJsonReader();
            boolean useJsonReader = this.configPage.isUseAvailabelReader();
            if (createJsonReader || useJsonReader) {
                p.setProperty("linkJSONReader", "true");
                return;
            }
            ArrayList<Json12DataConfiguraitonWizardPage.KeyValueModel> keyMapList = this.configPage.getKeyValueList();
            for (Json12DataConfiguraitonWizardPage.KeyValueModel keyValueModel : keyMapList) {
                String key = keyValueModel.getKey();
                String value = keyValueModel.getValue();
                p.setProperty("_key_" + key, value);
            }
            String aen = this.configPage.getArrayElementName();
            if (aen != null && aen.length() != 0) {
                p.setProperty("arrayElementName", aen);
            }
            if ((rn = this.configPage.getRootName()) != null && rn.length() != 0) {
                p.setProperty("rootName", rn);
            }
            if ((encoding = this.configPage.getEncoding()) != null && encoding.length() != 0) {
                p.setProperty("encoding", encoding);
            }
            if ((sr = this.configPage.getKeyWhitspaceReplacement()) != null && sr.length() != 0) {
                p.setProperty("spaceReplace", sr);
            }
            if ((pon = this.configPage.getKeyPrefixOnNumeric()) != null && pon.length() != 0) {
                p.setProperty("prefixOnNumeric", pon);
            }
            if ((nvr = this.configPage.getNullValueReplacement()) != null && nvr.length() != 0) {
                p.setProperty("nullReplace", nvr);
            }
            if ((ier = this.configPage.getIllegalElementNameCharReplacement()) != null && ier.length() != 0) {
                p.setProperty("illegalReplace", ier);
            }
            if ((indent = this.configPage.getIndent()) != null && indent.length() != 0) {
                p.setProperty("indent", indent);
            }
        }
    }

    public Object getReturnData() {
        return null;
    }

    public String getStructuredDataSourcePath() {
        if (this.pathPage != null) {
            return this.pathPage.getFilePath();
        }
        return null;
    }

    public void init(IEditorSite site, IEditorInput input) {
        IEditorPart editorPart = site.getWorkbenchWindow().getActivePage().findEditor(input);
        if (editorPart != null && editorPart instanceof SmooksMultiFormEditor) {
            SmooksMultiFormEditor formEditor = (SmooksMultiFormEditor)editorPart;
            EObject smooksModel = formEditor.getSmooksModel();
            if (smooksModel instanceof DocumentRoot) {
                this.resourceList = ((DocumentRoot)smooksModel).getSmooksResourceList();
            }
            this.editingDomain = formEditor.getEditingDomain();
        }
        if (this.configPage != null) {
            this.configPage.setSmooksResourceList(this.resourceList);
        }
    }

    public void complate(SmooksMultiFormEditor formEditor) {
    }
}

