/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.configuration.editors.uitls;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.jboss.tools.smooks.configuration.editors.uitls.SmooksUIUtils;
import org.jboss.tools.smooks.model.smooks.SmooksResourceListType;

public class BeanIdRefProposalProvider
implements IContentProposalProvider {
    private EObject model;

    public BeanIdRefProposalProvider(EObject model) {
        this.model = model;
    }

    public IContentProposal[] getProposals(String contents, int position) {
        ArrayList<BeanIDRefContentProposal> proposalList = new ArrayList<BeanIDRefContentProposal>();
        SmooksResourceListType listType = this.getSmooksResourceList(this.model);
        if (listType != null) {
            List<String> idList = SmooksUIUtils.getBeanIdStringList(listType);
            for (String id : idList) {
                if (!id.toLowerCase().startsWith(contents.toLowerCase())) continue;
                proposalList.add(new BeanIDRefContentProposal(id));
            }
            return proposalList.toArray(new IContentProposal[0]);
        }
        return new IContentProposal[0];
    }

    protected SmooksResourceListType getSmooksResourceList(EObject model) {
        EObject parent = model.eContainer();
        while (parent != null && !(parent instanceof SmooksResourceListType)) {
            parent = parent.eContainer();
        }
        if (parent instanceof SmooksResourceListType) {
            return (SmooksResourceListType)parent;
        }
        return null;
    }

    private class BeanIDRefContentProposal
    implements IContentProposal {
        private String id;

        public BeanIDRefContentProposal(String id) {
            this.id = id;
        }

        public String getContent() {
            return this.id;
        }

        public int getCursorPosition() {
            if (this.id != null) {
                return this.id.length();
            }
            return 0;
        }

        public String getDescription() {
            return null;
        }

        public String getLabel() {
            return this.id;
        }
    }
}

