/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.configuration.editors.uitls;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.search.JavaSearchScopeFactory;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.jboss.tools.smooks.configuration.SmooksConfigurationActivator;
import org.jboss.tools.smooks.configuration.editors.uitls.IFieldDialog;
import org.jboss.tools.smooks.configuration.editors.uitls.IModelProcsser;
import org.jboss.tools.smooks.configuration.editors.uitls.Messages;

public class JavaTypeFieldDialog
implements IFieldDialog {
    IResource workspaceResource = null;

    public JavaTypeFieldDialog(IResource resource) {
        this.workspaceResource = resource;
    }

    public Object open(Shell shell) {
        IProject project;
        IJavaProject jp;
        if (this.workspaceResource != null && this.workspaceResource instanceof IFile && (jp = JavaCore.create((IProject)(project = ((IFile)this.workspaceResource).getProject()))) != null) {
            return JavaTypeFieldDialog.openJavaTypeDialog(shell, jp);
        }
        MessageDialog.openInformation((Shell)shell, (String)Messages.JavaTypeFieldDialog_CantOpenErrorTitle, (String)Messages.JavaTypeFieldDialog_CantOpenErrorMessage);
        return null;
    }

    public static String openJavaTypeDialog(Shell shell, IJavaProject javaProject) {
        return JavaTypeFieldDialog.openJavaTypeDialog(shell, javaProject, 2);
    }

    public static String openJavaTypeDialog(Shell shell, IJavaProject javaProject, int javaType) {
        IJavaSearchScope scope = null;
        String className = null;
        if (javaProject == null) {
            scope = JavaSearchScopeFactory.getInstance().createWorkspaceScope(true);
        } else {
            String[] requiredProjects = null;
            try {
                requiredProjects = javaProject.getRequiredProjectNames();
            }
            catch (Exception exception) {}
            if (requiredProjects == null) {
                requiredProjects = new String[]{javaProject.getElementName()};
            } else {
                String[] temp = new String[requiredProjects.length + 1];
                temp[0] = javaProject.getElementName();
                System.arraycopy(requiredProjects, 0, temp, 1, requiredProjects.length);
                requiredProjects = temp;
            }
            scope = JavaSearchScopeFactory.getInstance().createJavaProjectSearchScope(requiredProjects, true);
        }
        try {
            Object[] results;
            SelectionDialog dialog = JavaUI.createTypeDialog((Shell)shell, (IRunnableContext)SmooksConfigurationActivator.getDefault().getWorkbench().getActiveWorkbenchWindow(), (IJavaSearchScope)scope, (int)javaType, (boolean)false);
            dialog.setMessage(Messages.JavaTypeFieldDialog_SearchDialogTitle);
            dialog.setTitle(Messages.JavaTypeFieldDialog_SearchDialogTitle);
            if (dialog.open() == 0 && (results = dialog.getResult()).length > 0) {
                Object result = results[0];
                String packageFullName = JavaModelUtil.getTypeContainerName((IType)((IType)result));
                className = packageFullName == null || packageFullName.length() <= 0 ? ((IType)result).getElementName() : String.valueOf(packageFullName) + "." + ((IType)result).getElementName();
                return className;
            }
        }
        catch (Throwable t) {
            SmooksConfigurationActivator.getDefault();
            SmooksConfigurationActivator.log(t);
        }
        return className;
    }

    public IModelProcsser getModelProcesser() {
        return null;
    }

    public void setModelProcesser(IModelProcsser processer) {
    }
}

