/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.configuration.editors.uitls;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.jboss.tools.smooks.configuration.editors.IXMLStructuredObject;
import org.jboss.tools.smooks.configuration.editors.uitls.SmooksUIUtils;
import org.jboss.tools.smooks.configuration.editors.xml.TagList;
import org.jboss.tools.smooks.configuration.editors.xml.XMLObjectAnalyzer;
import org.jboss.tools.smooks.model.json12.Json12Package;
import org.jboss.tools.smooks.model.json12.Json12Reader;
import org.jboss.tools.smooks.model.json12.Key;
import org.jboss.tools.smooks.model.json12.KeyMap;
import org.jboss.tools.smooks.model.smooks.AbstractReader;
import org.jboss.tools.smooks.model.smooks.SmooksResourceListType;
import org.milyn.ReaderConfigurator;
import org.milyn.Smooks;
import org.milyn.cdr.Parameter;
import org.milyn.json.JSONReaderConfigurator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonInputDataParser {
    public static final String LINK_JSON_READER = "linkJSONReader";
    public static final String KEY = "_key_";
    public static final String NULL_REPLACE = "nullReplace";
    public static final String ENCODING2 = "encoding";
    public static final String SPACE_REPLACE = "spaceReplace";
    public static final String PREFIX_ON_NUMERIC = "prefixOnNumeric";
    public static final String ILLEGAL_REPLACE = "illegalReplace";
    public static final String INDENT = "indent";
    public static final String ARRAY_ELEMENT_NAME = "arrayElementName";
    public static final String ROOT_NAME = "rootName";

    public IXMLStructuredObject parseJsonFile(InputStream inputStream, Object readerObj) throws ParserConfigurationException {
        String rootName = null;
        String arrayElementName = null;
        String keyWhitspaceReplacement = null;
        String keyPrefixOnNumeric = null;
        String illegalElementNameCharReplacement = null;
        String nullValueReplacement = null;
        String encoding = null;
        String indent = null;
        HashMap<String, String> keyMap = new HashMap<String, String>();
        if (readerObj == null) {
            return null;
        }
        if (readerObj instanceof Json12Reader) {
            KeyMap km;
            Json12Reader reader = (Json12Reader)readerObj;
            rootName = reader.getRootName();
            arrayElementName = reader.getArrayElementName();
            keyPrefixOnNumeric = reader.getKeyPrefixOnNumeric();
            keyWhitspaceReplacement = reader.getKeyWhitspaceReplacement();
            illegalElementNameCharReplacement = reader.getIllegalElementNameCharReplacement();
            nullValueReplacement = reader.getNullValueReplacement();
            encoding = reader.getEncoding();
            boolean isSet = reader.eIsSet((EStructuralFeature)Json12Package.Literals.JSON12_READER__INDENT);
            if (isSet) {
                indent = String.valueOf(reader.isIndent());
            }
            if ((km = reader.getKeyMap()) != null) {
                EList keyList = km.getKey();
                for (Key key : keyList) {
                    keyMap.put(key.getFrom(), key.getTo());
                }
            }
        }
        return this.parseJsonFile(inputStream, rootName, arrayElementName, keyWhitspaceReplacement, keyPrefixOnNumeric, illegalElementNameCharReplacement, nullValueReplacement, keyMap, indent, encoding);
    }

    public IXMLStructuredObject parseJsonFile(InputStream stream, SmooksResourceListType resourceList) throws FileNotFoundException, ParserConfigurationException, InvocationTargetException {
        EList readers = resourceList.getAbstractReader();
        int count = 0;
        int index = -1;
        for (AbstractReader abstractReader : readers) {
            if (!(abstractReader instanceof Json12Reader)) continue;
            ++count;
            if (index != -1) continue;
            index = readers.indexOf(abstractReader);
        }
        if (index != -1) {
            return this.parseJsonFile(stream, readers.get(index));
        }
        return null;
    }

    public IXMLStructuredObject parseJsonFile(String filePath, SmooksResourceListType resourceList) throws FileNotFoundException, ParserConfigurationException, InvocationTargetException {
        FileInputStream stream = new FileInputStream(filePath);
        return this.parseJsonFile((InputStream)stream, resourceList);
    }

    public IXMLStructuredObject parseJsonFile(String filePath, String rootName, String arrayElementName, String keyWhitspaceReplacement, String keyPrefixOnNumeric, String illegalElementNameCharReplacement, String nullValueReplacement, Map<String, String> keyMap, String indent, String encoding) throws FileNotFoundException, ParserConfigurationException, InvocationTargetException {
        return this.parseJsonFile(new FileInputStream(SmooksUIUtils.parseFilePath(filePath)), rootName, arrayElementName, keyWhitspaceReplacement, keyPrefixOnNumeric, illegalElementNameCharReplacement, nullValueReplacement, keyMap, indent, encoding);
    }

    public IXMLStructuredObject parseJsonFile(InputStream inputStream, String rootName, String arrayElementName, String keyWhitspaceReplacement, String keyPrefixOnNumeric, String illegalElementNameCharReplacement, String nullValueReplacement, Map<String, String> keyMap, String indent, String encoding) throws ParserConfigurationException {
        Smooks smooks = new Smooks();
        JSONReaderConfigurator readerConfig = new JSONReaderConfigurator();
        if (arrayElementName != null) {
            readerConfig.setArrayElementName(arrayElementName);
        }
        if (rootName != null) {
            readerConfig.setRootName(rootName);
        }
        if (keyWhitspaceReplacement != null) {
            readerConfig.setKeyWhitspaceReplacement(keyWhitspaceReplacement);
        }
        if (keyPrefixOnNumeric != null) {
            readerConfig.setKeyPrefixOnNumeric(keyPrefixOnNumeric);
        }
        if (illegalElementNameCharReplacement != null) {
            readerConfig.setIllegalElementNameCharReplacement(illegalElementNameCharReplacement);
        }
        if (nullValueReplacement != null) {
            readerConfig.setNullValueReplacement(nullValueReplacement);
        }
        if (keyMap != null) {
            readerConfig.setKeyMap(keyMap);
        }
        readerConfig.setEncoding(Charset.forName(encoding));
        smooks.setReaderConfig((ReaderConfigurator)readerConfig);
        DOMResult result = new DOMResult();
        smooks.filterSource((Source)new StreamSource(inputStream), new Result[]{result});
        Document document = (Document)result.getNode();
        XMLObjectAnalyzer analyzer = new XMLObjectAnalyzer();
        TagList tagList = analyzer.analyze(document, null, null);
        try {
            if (smooks != null) {
                smooks.close();
                smooks = null;
            }
            if (inputStream != null) {
                inputStream.close();
                inputStream = null;
            }
            result = null;
        }
        catch (Throwable throwable) {}
        return tagList;
    }

    protected Parameter keyMapToParameter(Map<String, String> keyMap) throws ParserConfigurationException {
        Parameter keyMapParam = new Parameter("keyMap", "dummyVal");
        DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Element keyMapElement = docBuilder.newDocument().createElement("keyMap");
        Set<Map.Entry<String, String>> keyMapEntries = keyMap.entrySet();
        for (Map.Entry<String, String> keyMapEntry : keyMapEntries) {
            Element keyElement = keyMapElement.getOwnerDocument().createElementNS("*", "key");
            keyElement.setAttribute("from", keyMapEntry.getKey());
            keyElement.setAttribute("to", keyMapEntry.getValue());
            keyMapElement.appendChild(keyElement);
        }
        keyMapParam.setXML(keyMapElement);
        return keyMapParam;
    }
}

