/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.configuration.editors.wizard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardSelectionPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.jboss.tools.smooks.configuration.SmooksConfigurationActivator;
import org.jboss.tools.smooks.configuration.editors.wizard.IStructuredDataSelectionWizard;
import org.jboss.tools.smooks.configuration.editors.wizard.IViewerInitor;
import org.jboss.tools.smooks.configuration.editors.wizard.Messages;
import org.jboss.tools.smooks.configuration.editors.wizard.StructuredDataSelectionWizard;
import org.jboss.tools.smooks.configuration.editors.wizard.TransformSelectWizardNode;
import org.jboss.tools.smooks.configuration.editors.wizard.ViewerInitorStore;

public class TransformDataWizardSelectionPage
extends WizardSelectionPage {
    List<Object> registedWizard = new ArrayList<Object>();
    TreeViewer viewer = null;
    private Label desLabel;

    public void createControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        main.setLayout((Layout)gridLayout);
        Label label = new Label(main, 0);
        label.setText(Messages.TransformDataWizardSelectionPage_InputTypeLabel);
        this.viewer = new TreeViewer(main, 2048);
        this.viewer.setContentProvider((IContentProvider)new WizardNodeContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new WizardNodeLabelProvider());
        GridData gd = new GridData(1808);
        this.viewer.getTree().setLayoutData((Object)gd);
        this.createAllExtentionWizard();
        Composite separatorComposite = new Composite(main, 0);
        gd = new GridData();
        gd.heightHint = 12;
        separatorComposite.setLayoutData((Object)gd);
        this.desLabel = new Label(main, 0);
        gd = new GridData(768);
        this.desLabel.setLayoutData((Object)gd);
        this.viewer.setInput(this.registedWizard);
        if (!this.registedWizard.isEmpty()) {
            this.setSelectedNode((IWizardNode)this.registedWizard.get(0));
        }
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                IWizardNode node = (IWizardNode)selection.getFirstElement();
                TransformDataWizardSelectionPage.this.desLabel.setText("");
                if (node != null) {
                    TransformDataWizardSelectionPage.this.setSelectedNode(node);
                    if (node instanceof TransformSelectWizardNode) {
                        String des = ((TransformSelectWizardNode)node).getDescription();
                        TransformDataWizardSelectionPage.this.desLabel.setText(des);
                    }
                    IStructuredDataSelectionWizard wizard = (IStructuredDataSelectionWizard)node.getWizard();
                    StructuredDataSelectionWizard pw = (StructuredDataSelectionWizard)TransformDataWizardSelectionPage.this.getWizard();
                    wizard.init(pw.getSite(), pw.getInput());
                }
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TransformDataWizardSelectionPage.this.getContainer().showPage(TransformDataWizardSelectionPage.this.getNextPage());
            }
        });
        this.setControl((Control)main);
    }

    public IWizardPage getNextPage() {
        if (this.getSelectedNode() == null) {
            return null;
        }
        boolean isCreated = this.getSelectedNode().isContentCreated();
        IWizard wizard = this.getSelectedNode().getWizard();
        if (wizard == null) {
            this.setSelectedNode(null);
            return null;
        }
        if (!isCreated) {
            wizard.addPages();
        }
        return wizard.getStartingPage();
    }

    protected void createAllExtentionWizard() {
        Collection<IViewerInitor> viewers = ViewerInitorStore.getInstance().getViewerInitorCollection();
        if (this.viewer == null) {
            return;
        }
        for (IViewerInitor viewerInitor : viewers) {
            TransformSelectWizardNode wn = new TransformSelectWizardNode();
            IStructuredDataSelectionWizard wizard = viewerInitor.getStructuredDataLoadWizard();
            if (wizard == null) continue;
            wn.setWizard(wizard);
            wn.setName(viewerInitor.getName());
            wn.setIconPath(viewerInitor.getWizardIconPath());
            wn.setDescription(viewerInitor.getDescription());
            this.registedWizard.add(wn);
        }
    }

    public TransformDataWizardSelectionPage(String pageName) {
        super(pageName);
        this.setDescription("Choose \"Input Data Type\" to open wizard dialog to select the input data.");
        this.setTitle("Input Data Selection");
    }

    public void activeSelectionWizard() {
    }

    private class WizardNodeContentProvider
    implements ITreeContentProvider {
        private WizardNodeContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class WizardNodeLabelProvider
    extends LabelProvider {
        private HashMap<Object, Object> map = new HashMap();

        private WizardNodeLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof TransformSelectWizardNode) {
                Image icon;
                String path = ((TransformSelectWizardNode)element).getIconPath();
                if (path != null && (icon = SmooksConfigurationActivator.getDefault().getImageRegistry().get(path)) != null) {
                    return icon;
                }
                return SmooksConfigurationActivator.getDefault().getImageRegistry().get("icons/full/obj16/unknown_obj.gif");
            }
            return super.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof TransformSelectWizardNode) {
                return ((TransformSelectWizardNode)element).getName();
            }
            return super.getText(element);
        }

        public void dispose() {
            if (!this.map.values().isEmpty()) {
                for (Image image : this.map.values()) {
                    image.dispose();
                }
            }
            super.dispose();
        }
    }
}

