/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.configuration.editors.xml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.smooks.configuration.editors.IFilePathProcessor;
import org.jboss.tools.smooks.configuration.editors.uitls.SmooksUIUtils;
import org.jboss.tools.smooks.configuration.editors.xml.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFileSelectionWizardPage
extends WizardPage
implements SelectionListener {
    protected IStructuredSelection selection;
    protected Object returnObject = null;
    protected Text fileText;
    protected Composite fileTextComposite;
    protected CheckboxTableViewer tableViewer = null;
    protected Button fileSystemBrowseButton;
    protected boolean reasourceLoaded = false;
    protected Button workspaceBrowseButton;
    private String filePath = null;
    protected Object[] initSelections;
    protected List<ViewerFilter> filters = new ArrayList<ViewerFilter>();
    protected boolean multiSelect = false;
    private IFilePathProcessor filePathProcessor = null;
    protected String[] fileExtensionNames;

    public AbstractFileSelectionWizardPage(String pageName, boolean multiSelect, Object[] initSelections, List<ViewerFilter> filters, String[] fileExtensionNames) {
        this(pageName, false, initSelections, Collections.EMPTY_LIST);
        this.fileExtensionNames = fileExtensionNames;
        this.createFileExtensionNameFilter();
    }

    public String[] getFileExtensionNames() {
        return this.fileExtensionNames;
    }

    public void setFileExtensionNames(String[] fileExtensionNames) {
        this.fileExtensionNames = fileExtensionNames;
    }

    public void createFileExtensionNameFilter() {
        if (this.fileExtensionNames != null && this.fileExtensionNames.length != 0) {
            ViewerFilter extensionNameFilter = new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    if (element instanceof IFile && AbstractFileSelectionWizardPage.this.fileExtensionNames != null) {
                        String extName = ((IFile)element).getFileExtension();
                        int i = 0;
                        while (i < AbstractFileSelectionWizardPage.this.fileExtensionNames.length) {
                            String name = AbstractFileSelectionWizardPage.this.fileExtensionNames[i];
                            if (name.equalsIgnoreCase(extName)) {
                                return true;
                            }
                            ++i;
                        }
                        return false;
                    }
                    return true;
                }
            };
            this.filters.add(extensionNameFilter);
        }
    }

    public AbstractFileSelectionWizardPage(String pageName, boolean multiSelect, Object[] initSelections, List<ViewerFilter> filters) {
        super(pageName);
        this.initSelections = initSelections;
        if (filters != null) {
            this.filters.addAll(filters);
        }
        this.multiSelect = multiSelect;
    }

    public AbstractFileSelectionWizardPage(String pageName, String[] fileExtensionNames) {
        this(pageName, false, null, Collections.EMPTY_LIST);
        this.fileExtensionNames = fileExtensionNames;
        this.createFileExtensionNameFilter();
    }

    public Object getReturnValue() {
        String path;
        block3: {
            path = this.getFilePath();
            if (path != null) break block3;
            return null;
        }
        try {
            path = SmooksUIUtils.parseFilePath(path);
            this.returnObject = this.loadedTheObject(path);
        }
        catch (Exception e) {
            SmooksUIUtils.showErrorDialog(this.getShell(), SmooksUIUtils.createErrorStatus(e));
        }
        return this.returnObject;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public IFilePathProcessor getFilePathProcessor() {
        return this.filePathProcessor;
    }

    public void setFilePathProcessor(IFilePathProcessor filePathProcessor) {
        this.filePathProcessor = filePathProcessor;
    }

    public void createControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        mainComposite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        mainComposite.setLayoutData((Object)gd);
        this.createFileSelectionComposite(mainComposite);
        this.hookBrowseButtonSelectionAdapter();
        this.hookFileTextModifyListener();
        this.setControl((Control)mainComposite);
        this.changeWizardPageStatus();
        this.setErrorMessage(null);
        parent.getShell().setText(Messages.AbstractFileSelectionWizardPage_WizardTitle);
    }

    protected void hookFileTextModifyListener() {
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractFileSelectionWizardPage.this.filePath = AbstractFileSelectionWizardPage.this.fileText.getText();
                AbstractFileSelectionWizardPage.this.changeWizardPageStatus();
            }
        };
        this.fileText.addModifyListener(modifyListener);
    }

    protected void hookRadioButtonSelectionAdapter() {
    }

    protected void hookBrowseButtonSelectionAdapter() {
        SelectionAdapter browseButtonSelectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Text relationT = null;
                if (e.getSource() == AbstractFileSelectionWizardPage.this.fileSystemBrowseButton) {
                    relationT = AbstractFileSelectionWizardPage.this.fileText;
                }
                AbstractFileSelectionWizardPage.this.openFileSelection(relationT);
            }
        };
        SelectionAdapter wbrowseButtonSelectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Text relationT = null;
                if (e.getSource() == AbstractFileSelectionWizardPage.this.workspaceBrowseButton) {
                    relationT = AbstractFileSelectionWizardPage.this.fileText;
                }
                AbstractFileSelectionWizardPage.this.openWorkSpaceSelection(relationT);
            }
        };
        this.workspaceBrowseButton.addSelectionListener((SelectionListener)wbrowseButtonSelectionAdapter);
        this.fileSystemBrowseButton.addSelectionListener((SelectionListener)browseButtonSelectionAdapter);
    }

    protected void openWorkSpaceSelection(Text relationT) {
        IFile[] files = WorkspaceResourceDialog.openFileSelection((Shell)this.getShell(), (String)"Select Files", (String)"", (boolean)false, (Object[])this.initSelections, this.filters);
        if (files.length > 0) {
            IFile file = files[0];
            String s = this.processWorkSpaceFilePath(file);
            relationT.setText(s);
        }
    }

    protected String processFileSystemFilePath(String path) {
        String s;
        if (this.filePathProcessor != null && (s = this.filePathProcessor.processFileSystemPath(path)) != null) {
            return s;
        }
        path = "File:/" + path;
        return path;
    }

    protected String processWorkSpaceFilePath(IFile file) {
        String s;
        if (this.filePathProcessor != null && (s = this.filePathProcessor.processWorkBenchPath(file)) != null) {
            return s;
        }
        s = file.getFullPath().toPortableString();
        s = "Workspace:/" + s;
        return s;
    }

    protected Text createFilePathText(Composite parent) {
        this.fileTextComposite = new Composite(parent, 0);
        GridData gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.fileTextComposite.setLayoutData((Object)gd);
        GridLayout xsdtgl = new GridLayout();
        xsdtgl.marginWidth = 0;
        xsdtgl.marginHeight = 0;
        xsdtgl.numColumns = 1;
        this.fileTextComposite.setLayout((Layout)xsdtgl);
        Text fileText = new Text(this.fileTextComposite, 2048);
        gd = new GridData(768);
        fileText.setLayoutData((Object)gd);
        gd.grabExcessHorizontalSpace = true;
        return fileText;
    }

    protected Composite createFileSelectionComposite(Composite parent) {
        Composite xsdComposite = new Composite(parent, 0);
        GridData gd = new GridData(768);
        xsdComposite.setLayoutData((Object)gd);
        GridLayout xsdLayout = new GridLayout();
        xsdLayout.numColumns = 2;
        xsdLayout.marginWidth = 0;
        xsdComposite.setLayout((Layout)xsdLayout);
        this.createExtensionGUIFirst(xsdComposite);
        Label nfileLanel = new Label(xsdComposite, 0);
        nfileLanel.setText("File : ");
        this.fileText = this.createFilePathText(xsdComposite);
        Composite browseButtonComposite = new Composite(xsdComposite, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        browseButtonComposite.setLayoutData((Object)gd);
        GridLayout bg = new GridLayout();
        bg.numColumns = 2;
        bg.marginHeight = 0;
        bg.marginWidth = 0;
        bg.makeColumnsEqualWidth = false;
        browseButtonComposite.setLayout((Layout)bg);
        this.fileSystemBrowseButton = new Button(browseButtonComposite, 0);
        this.fileSystemBrowseButton.setText("Browse File System");
        this.workspaceBrowseButton = new Button(browseButtonComposite, 0);
        this.workspaceBrowseButton.setText("Browse WorkSpace");
        gd = new GridData();
        gd.horizontalAlignment = 3;
        this.workspaceBrowseButton.setLayoutData((Object)gd);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 3;
        this.fileSystemBrowseButton.setLayoutData((Object)gd);
        return xsdComposite;
    }

    protected void createExtensionGUIFirst(Composite parent) {
    }

    protected abstract Object loadedTheObject(String var1) throws Exception;

    protected void initTableViewer() {
    }

    protected void setCompositeChildrenEnabled(Composite composite, boolean enabled) {
        Control[] children = composite.getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            if (child instanceof Text) {
                child.setEnabled(enabled);
            }
            if (child instanceof Button) {
                child.setEnabled(enabled);
            }
            if (child instanceof Composite) {
                this.setCompositeChildrenEnabled((Composite)child, enabled);
            }
            ++i;
        }
    }

    protected void openFileSelection(Text relationText) {
        String path;
        FileDialog dialog = new FileDialog(this.getShell());
        if (this.fileExtensionNames != null) {
            String s = "";
            int i = 0;
            while (i < this.fileExtensionNames.length) {
                String exname = this.fileExtensionNames[i];
                s = String.valueOf(s) + "*." + exname + ";";
                ++i;
            }
            if (s.length() != 0) {
                s = s.substring(0, s.length() - 1);
                dialog.setFilterExtensions(new String[]{s, "*.*"});
            }
        }
        if ((path = dialog.open()) != null) {
            path = this.processFileSystemFilePath(path);
            relationText.setText(path);
        }
    }

    protected void changeWizardPageStatus() {
        String text = this.fileText.getText();
        String error = null;
        if (text == null || "".equals(text)) {
            error = "File name cannot be null";
        }
        this.setErrorMessage(error);
        this.setPageComplete(error == null);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        this.changeWizardPageStatus();
    }

    public CheckboxTableViewer getTableViewer() {
        return this.tableViewer;
    }

    public void setTableViewer(CheckboxTableViewer tableViewer) {
        this.tableViewer = tableViewer;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public void setSelection(IStructuredSelection selection) {
        this.selection = selection;
    }

    public Object[] getInitSelections() {
        return this.initSelections;
    }

    public void setInitSelections(Object[] initSelections) {
        this.initSelections = initSelections;
    }

    public List<ViewerFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<ViewerFilter> filters) {
        this.filters = filters;
    }

    public boolean isMultiSelect() {
        return this.multiSelect;
    }

    public void setMultiSelect(boolean multiSelect) {
        this.multiSelect = multiSelect;
    }
}

