/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.configuration.editors.xml;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.ExtensibilityElement;
import org.eclipse.wst.wsdl.Types;
import org.eclipse.wst.wsdl.WSDLFactory;
import org.eclipse.wst.wsdl.XSDSchemaExtensibilityElement;
import org.eclipse.wst.wsdl.util.WSDLParser;
import org.eclipse.wst.wsdl.util.WSDLResourceImpl;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDSchema;
import org.jboss.tools.smooks.configuration.editors.uitls.SmooksUIUtils;
import org.jboss.tools.smooks.configuration.editors.xml.TagObject;
import org.jboss.tools.smooks.configuration.editors.xml.XSDObjectAnalyzer;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLObjectAnalyzer {
    private XSDObjectAnalyzer xsdAnalyzer = new XSDObjectAnalyzer();

    public static List<XSDElementDeclaration> loadAllElement(String filePath) throws InvocationTargetException, IOException, ParserConfigurationException, SAXException {
        ArrayList<XSDElementDeclaration> nl = new ArrayList<XSDElementDeclaration>();
        String file = SmooksUIUtils.parseFilePath(filePath);
        WSDLParser parser = new WSDLParser();
        parser.parse((InputStream)new FileInputStream(file));
        final Document document = parser.getDocument();
        final Definition definition = WSDLFactory.eINSTANCE.createDefinition();
        definition.setDocumentBaseURI(URI.createFileURI((String)file).toString());
        definition.setDocument(document);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        WSDLResourceImpl resource = new WSDLResourceImpl(URI.createFileURI((String)file));
        resourceSet.getResources().add((Object)resource);
        resource.getContents().add((Object)definition);
        resource.setModified(false);
        IRunnableWithProgress setElementOperation = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask("", -1);
                definition.setElement(document.getDocumentElement());
            }
        };
        IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
        try {
            progressService.busyCursorWhile(setElementOperation);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Types types = definition.getETypes();
        if (types != null) {
            XSDSchemaExtensibilityElement el = null;
            for (ExtensibilityElement extensibilityElement : types.getEExtensibilityElements()) {
                XSDSchema schema;
                if (!(extensibilityElement instanceof XSDSchemaExtensibilityElement) || (schema = (el = (XSDSchemaExtensibilityElement)extensibilityElement).getSchema()) == null) continue;
                EList list = schema.getElementDeclarations();
                for (XSDElementDeclaration elementDeclaration : list) {
                    if (elementDeclaration.isAbstract()) continue;
                    nl.add(elementDeclaration);
                }
            }
        }
        return nl;
    }

    public TagObject loadElement(String path, String rootElementName) throws IOException {
        WSDLResourceImpl resource = new WSDLResourceImpl(URI.createFileURI((String)path));
        resource.load(Collections.emptyMap());
        if (resource.getContents().isEmpty()) {
            return null;
        }
        resource.getContents().get(0);
        return null;
    }
}

