/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.configuration.editors.xml;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.jboss.tools.smooks.configuration.editors.xml.AbstractXMLObject;
import org.jboss.tools.smooks.configuration.editors.xml.TagList;
import org.jboss.tools.smooks.configuration.editors.xml.TagObject;
import org.jboss.tools.smooks.configuration.editors.xml.TagPropertyObject;
import org.jboss.tools.smooks.configuration.editors.xml.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLObjectAnalyzer {
    public TagList analyze(String xmlFilePath, String[] ignoreNodeNames, Class<? extends AbstractXMLObject> tagObjectClass) throws ParserConfigurationException, SAXException, IOException {
        FileInputStream stream = new FileInputStream(xmlFilePath);
        TagList list = this.analyze(stream, ignoreNodeNames, tagObjectClass);
        try {
            stream.close();
        }
        catch (IOException iOException) {}
        return list;
    }

    public TagList analyze(Document doc, String[] ignoreNodeNames, Class<? extends AbstractXMLObject> tagObjectClass) {
        if (doc == null) {
            return null;
        }
        Element rootElement = doc.getDocumentElement();
        TagList dco = new TagList();
        dco.setName("Docuement");
        dco.addRootTag(this.parseElement(rootElement, null, ignoreNodeNames, tagObjectClass));
        return dco;
    }

    public TagList analyze(InputStream stream, String[] ignoreNodeNames, Class<? extends AbstractXMLObject> tagObjectClass) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder builder = this.createDocumentBuildingFactory();
        Document doc = builder.parse(stream);
        return this.analyze(doc, ignoreNodeNames, tagObjectClass);
    }

    public DocumentBuilder createDocumentBuildingFactory() throws ParserConfigurationException {
        return XMLUtils.getDOMBuilder();
    }

    public TagObject analyzeFregment(InputStream stream, String[] ignoreNodeNames, Class<? extends AbstractXMLObject> tagObjectClass) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder builder = this.createDocumentBuildingFactory();
        Document doc = builder.parse(stream);
        Element rootElement = doc.getDocumentElement();
        return this.parseElement(rootElement, null, ignoreNodeNames, tagObjectClass);
    }

    protected TagObject getChildTagByName(String name, TagObject tag, String[] ignoreNodeNames) {
        if (this.isIgnoreNode(name, ignoreNodeNames)) {
            return null;
        }
        if (tag == null) {
            return null;
        }
        List<AbstractXMLObject> list = tag.getXMLNodeChildren();
        for (TagObject tagObject : list) {
            if (!tagObject.getName().equals(name)) continue;
            return tagObject;
        }
        return null;
    }

    private boolean isIgnoreNode(Element element, String[] ignoreNodeNames) {
        return this.isIgnoreNode(element.getNodeName(), ignoreNodeNames);
    }

    private boolean isIgnoreNode(String name, String[] ignoreNodeNames) {
        if (ignoreNodeNames == null) {
            return false;
        }
        int i = 0;
        while (i < ignoreNodeNames.length) {
            String ignore = ignoreNodeNames[i];
            if (ignore.trim().equalsIgnoreCase(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected TagObject parseElement(Element element, TagObject parentTag, String[] ignoreNodeNames, Class<? extends AbstractXMLObject> tagObjectClass) {
        if (this.isIgnoreNode(element, ignoreNodeNames)) {
            return null;
        }
        boolean canAdd = false;
        TagObject tag = this.getChildTagByName(element.getNodeName(), parentTag, ignoreNodeNames);
        if (tag == null) {
            if (tagObjectClass != null) {
                try {
                    tag = (TagObject)tagObjectClass.newInstance();
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            } else {
                tag = new TagObject();
            }
            canAdd = true;
        }
        if (tag == null) {
            return null;
        }
        tag.setReferenceElement(element);
        String localName = element.getLocalName();
        String nodeName = element.getNodeName();
        if (localName == null) {
            localName = nodeName;
        }
        tag.setName(localName);
        this.fillProperties(element, tag, ignoreNodeNames);
        tag.setNamespaceURI(element.getNamespaceURI());
        NodeList nodeList = element.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Element childElement;
            TagObject t;
            Node node = nodeList.item(i);
            if (node instanceof Element && (t = this.parseElement(childElement = (Element)node, tag, ignoreNodeNames, tagObjectClass)) != null) {
                tag.addChildTag(t);
                t.setReferenceElement(childElement);
            }
            ++i;
        }
        if (canAdd) {
            return tag;
        }
        return null;
    }

    protected boolean hasSameNameProperty(String proName, TagObject tag) {
        List<TagPropertyObject> pros = tag.getProperties();
        for (TagPropertyObject tp : pros) {
            if (!tp.getName().equals(proName)) continue;
            return true;
        }
        return false;
    }

    protected void fillProperties(Element element, TagObject tag, String[] ignoreNodeNames) {
        NamedNodeMap attrMap = element.getAttributes();
        int i = 0;
        while (i < attrMap.getLength()) {
            Node node = attrMap.item(i);
            if (node instanceof Attr) {
                Attr attr = (Attr)node;
                String attrName = attr.getName();
                String value = attr.getValue();
                if (!this.isIgnoreNode(attrName, ignoreNodeNames) && !this.hasSameNameProperty(attrName, tag)) {
                    TagPropertyObject pro = new TagPropertyObject();
                    String localName = attr.getLocalName();
                    String name = attr.getNodeName();
                    if (localName == null) {
                        localName = name;
                    }
                    pro.setName(localName);
                    pro.setValue(value);
                    pro.setNamespaceURI(attr.getNamespaceURI());
                    tag.addProperty(pro);
                }
            }
            ++i;
        }
    }
}

