/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.configuration.editors.xml;

import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLUtils {
    public static DocumentBuilder getDOMBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setValidating(false);
        DocumentBuilder builder = dbf.newDocumentBuilder();
        return builder;
    }

    public static Transformer getTransformer() throws TransformerConfigurationException {
        TransformerFactory tf = TransformerFactory.newInstance();
        return tf.newTransformer();
    }

    public static Document createDocument() throws ParserConfigurationException {
        return XMLUtils.getDOMBuilder().newDocument();
    }

    public static Element firstChildElement(Node node) {
        Node tempNode = node.getFirstChild();
        while (tempNode != null) {
            if (tempNode.getNodeType() == 1) {
                return (Element)tempNode;
            }
            tempNode = tempNode.getNextSibling();
        }
        return null;
    }

    public static Element nextSiblingElement(Node node) {
        Node tempNode = node.getNextSibling();
        while (tempNode != null) {
            if (tempNode.getNodeType() == 1) {
                return (Element)tempNode;
            }
            tempNode = tempNode.getNextSibling();
        }
        return null;
    }

    public static Element lastChildElement(Node node) {
        Node tempNode = node.getLastChild();
        while (tempNode != null) {
            if (tempNode.getNodeType() == 1) {
                return (Element)tempNode;
            }
            tempNode = tempNode.getPreviousSibling();
        }
        return null;
    }

    public static Element previousSiblingElement(Node node) {
        Node tempNode = node.getPreviousSibling();
        while (tempNode != null) {
            if (tempNode.getNodeType() == 1) {
                return (Element)tempNode;
            }
            tempNode = tempNode.getPreviousSibling();
        }
        return null;
    }

    public static List<Element> getAllChildElements(Node node) {
        ArrayList<Element> v = new ArrayList<Element>();
        Element child = XMLUtils.firstChildElement(node);
        while (child != null) {
            v.add(child);
            child = XMLUtils.nextSiblingElement(child);
        }
        return v;
    }

    public static List<Element> getChildElementsByNS(Node node, String uri, String localName) {
        List<Element> childElements = XMLUtils.getAllChildElements(node);
        ArrayList<Element> v = new ArrayList<Element>();
        int i = 0;
        while (i < childElements.size()) {
            Element child = childElements.get(i);
            String ln = child.getLocalName();
            String u = child.getNamespaceURI();
            if (uri == null) {
                if (ln.equals(localName)) {
                    v.add(child);
                }
            } else if (ln.equals(localName) && u.equals(uri)) {
                v.add(child);
            }
            ++i;
        }
        return v;
    }

    public static String getLocalName(String nodeName) {
        int index = nodeName.lastIndexOf(58);
        if (index == -1) {
            return nodeName;
        }
        return nodeName.substring(index + 1, nodeName.length());
    }

    public static String getPrefix(String nodeName) {
        int index = nodeName.lastIndexOf(58);
        if (index == -1) {
            return null;
        }
        return nodeName.substring(0, index);
    }

    public static void outDOMNode(Node node, Writer writer) throws TransformerConfigurationException, TransformerException {
        Transformer transformer = XMLUtils.getTransformer();
        DOMSource source = new DOMSource(node);
        StreamResult result = new StreamResult(writer);
        transformer.transform(source, result);
    }

    public static void outDOMNode(Node node, OutputStream os) throws TransformerConfigurationException, TransformerException {
        Document document = null;
        document = node instanceof Document ? (Document)node : node.getOwnerDocument();
        Object ls = null;
        if (document != null) {
            ls = document.getImplementation().getFeature("LS", "3.0");
        }
        if (ls != null && ls instanceof DOMImplementationLS) {
            LSSerializer lss = ((DOMImplementationLS)ls).createLSSerializer();
            DOMConfiguration domConfiguration = lss.getDomConfig();
            if (domConfiguration.canSetParameter("format-pretty-print", Boolean.TRUE)) {
                lss.getDomConfig().setParameter("format-pretty-print", Boolean.TRUE);
            }
            LSOutput lsoutput = ((DOMImplementationLS)ls).createLSOutput();
            lsoutput.setByteStream(os);
            lss.write(node, lsoutput);
        } else {
            Transformer transformer = XMLUtils.getTransformer();
            DOMSource source = new DOMSource(node);
            StreamResult result = new StreamResult(os);
            transformer.transform(source, result);
        }
    }
}

