/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.configuration.editors.xml;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.util.XSDResourceFactoryImpl;
import org.jboss.tools.smooks.configuration.editors.uitls.SmooksUIUtils;
import org.jboss.tools.smooks.configuration.editors.xml.TagObject;
import org.jboss.tools.smooks.configuration.editors.xml.TagPropertyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSDObjectAnalyzer {
    private HashMap<Object, Object> tagObjectBuffer = new HashMap();

    public static List<XSDElementDeclaration> loadAllElement(String filePath) throws InvocationTargetException, IOException {
        ArrayList<XSDElementDeclaration> nl = new ArrayList<XSDElementDeclaration>();
        String file = null;
        try {
            file = SmooksUIUtils.parseFilePath(filePath);
        }
        catch (Exception exception) {
            return nl;
        }
        Resource resource = new XSDResourceFactoryImpl().createResource(URI.createFileURI((String)file));
        resource.load(Collections.EMPTY_MAP);
        XSDSchema schema = (XSDSchema)resource.getContents().get(0);
        EList list = schema.getElementDeclarations();
        for (XSDElementDeclaration elementDeclaration : list) {
            if (elementDeclaration.isAbstract()) continue;
            nl.add(elementDeclaration);
        }
        return nl;
    }

    private List<XSDElementDeclaration> findChildrenElement(XSDSchema schema, XSDTypeDefinition baseTypeDefinition) {
        ArrayList<XSDElementDeclaration> elementList = new ArrayList<XSDElementDeclaration>();
        EList elements = schema.getElementDeclarations();
        for (XSDElementDeclaration elementDec : elements) {
            XSDTypeDefinition tdd;
            XSDTypeDefinition td;
            XSDSimpleTypeDefinition st;
            if (elementDec.isAbstract() || (st = (td = elementDec.getType()).getSimpleType()) != null || !(td instanceof XSDComplexTypeDefinition) || (tdd = td.getBaseType()) != baseTypeDefinition) continue;
            elementList.add(elementDec);
        }
        if (elementList.isEmpty()) {
            return null;
        }
        return elementList;
    }

    public TagObject loadElement(XSDSchema schema, String rootElementName) throws IOException {
        EList elements = schema.getElementDeclarations();
        for (XSDElementDeclaration elementDec : elements) {
            if (!rootElementName.equals(elementDec.getAliasName())) continue;
            this.tagObjectBuffer.clear();
            return this.loadElement(schema, elementDec);
        }
        return null;
    }

    public TagObject loadElement(String filePath, String rootElementName) throws InvocationTargetException, IOException {
        this.tagObjectBuffer.clear();
        Resource resource = new XSDResourceFactoryImpl().createResource(URI.createFileURI((String)filePath));
        resource.load(Collections.EMPTY_MAP);
        if (resource.getContents().isEmpty()) {
            return null;
        }
        XSDSchema schema = (XSDSchema)resource.getContents().get(0);
        return this.loadElement(schema, rootElementName);
    }

    public TagObject loadElement(String filePath, XSDElementDeclaration rootElement) throws InvocationTargetException, IOException {
        this.tagObjectBuffer.clear();
        Resource resource = new XSDResourceFactoryImpl().createResource(URI.createFileURI((String)filePath));
        resource.load(Collections.EMPTY_MAP);
        if (resource.getContents().isEmpty()) {
            return null;
        }
        XSDSchema schema = (XSDSchema)resource.getContents().get(0);
        return this.loadElement(schema, rootElement);
    }

    private TagObject loadElement(XSDSchema schema, XSDElementDeclaration elementDec) {
        if (elementDec.isAbstract()) {
            return null;
        }
        TagObject tag = (TagObject)this.tagObjectBuffer.get(elementDec);
        if (tag != null) {
            return tag;
        }
        tag = new TagObject();
        tag.setName(elementDec.getAliasName());
        tag.setNamespaceURI(elementDec.getAliasURI());
        this.tagObjectBuffer.put(elementDec, tag);
        XSDTypeDefinition td = elementDec.getType();
        XSDSimpleTypeDefinition st = td.getSimpleType();
        if (td instanceof XSDComplexTypeDefinition) {
            XSDParticleContent term;
            XSDComplexTypeDefinition ctype = (XSDComplexTypeDefinition)td;
            XSDParticle xsdparticle = td.getComplexType();
            if (xsdparticle != null && (term = xsdparticle.getContent()) instanceof XSDModelGroup) {
                EList list = ((XSDModelGroup)term).getParticles();
                for (XSDParticle xp : list) {
                    XSDParticleContent content = xp.getContent();
                    if (!(content instanceof XSDElementDeclaration)) continue;
                    XSDElementDeclaration child = (XSDElementDeclaration)content;
                    List<XSDElementDeclaration> childElement = null;
                    if (child.isElementDeclarationReference()) {
                        child = child.getResolvedElementDeclaration();
                    }
                    XSDTypeDefinition childType = child.getTypeDefinition();
                    if (child.isAbstract()) {
                        childElement = this.findChildrenElement(schema, childType);
                        if (childElement == null) continue;
                        for (XSDElementDeclaration elementDeclaration : childElement) {
                            TagObject childTag = this.loadElement(schema, elementDeclaration);
                            if (childTag == null) continue;
                            tag.addChildTag(childTag);
                        }
                        continue;
                    }
                    TagObject childTag = this.loadElement(schema, child);
                    if (childTag == null) continue;
                    tag.addChildTag(childTag);
                }
            }
            EList attributeContents = ctype.getAttributeContents();
            for (XSDAttributeUse attributeUse : attributeContents) {
                XSDAttributeDeclaration attribute = attributeUse.getAttributeDeclaration();
                TagPropertyObject tp = new TagPropertyObject();
                tp.setName(attribute.getAliasName());
                tp.setNamespaceURI(attribute.getTypeDefinition().getURI());
                tag.addProperty(tp);
            }
        }
        return tag;
    }

    public static void main(String[] args) throws IOException {
        Resource resource = new XSDResourceFactoryImpl().createResource(URI.createFileURI((String)"F:/smooks-1.1.xsd"));
        resource.load(Collections.EMPTY_MAP);
        XSDSchema schema = (XSDSchema)resource.getContents().get(0);
        TagObject rootTag = new XSDObjectAnalyzer().loadElement(schema, "smooks-resource-list");
        System.out.println(rootTag);
    }
}

