/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.configuration.editors.xml;

import java.util.ArrayList;
import java.util.List;
import org.jboss.tools.smooks.configuration.editors.xml.TagObject;
import org.jboss.tools.smooks.configuration.editors.xml.TagPropertyObject;
import org.jboss.tools.smooks.configuration.editors.xml.XSLModelAnalyzer;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSLTagObject
extends TagObject {
    private List<TagObject> relatedIgnoreXSLTagObjects = new ArrayList<TagObject>();
    private String smooksPrix = null;

    public String getSmooksPrix() {
        return this.smooksPrix;
    }

    public void setSmooksPrix(String smooksPrix) {
        this.smooksPrix = smooksPrix;
    }

    public void addRelatedIgnoreXSLTagObject(TagObject tag) {
        if (tag == null) {
            return;
        }
        this.relatedIgnoreXSLTagObjects.add(tag);
    }

    public void removeRelatedIgnoreXSLTagObject(TagObject tag) {
        this.relatedIgnoreXSLTagObjects.remove(tag);
    }

    public List<TagObject> getRelatedIgnoreXSLTagObjects() {
        return this.relatedIgnoreXSLTagObjects;
    }

    public String getSelectValue() {
        List<TagPropertyObject> properties = this.getProperties();
        for (TagPropertyObject tagPropertyObject : properties) {
            if (!tagPropertyObject.getName().equalsIgnoreCase("select")) continue;
            return tagPropertyObject.getValue();
        }
        return null;
    }

    public void removeSelectProperty() {
        TagPropertyObject tagPropertyObject = null;
        List<TagPropertyObject> properties = this.getProperties();
        for (TagPropertyObject tagPropertyObject1 : properties) {
            if (!tagPropertyObject1.getName().equalsIgnoreCase("select")) continue;
            tagPropertyObject = tagPropertyObject1;
            break;
        }
        if (tagPropertyObject != null) {
            Element parentElement = this.getReferenceElement();
            Attr att = tagPropertyObject.getReferenceAttibute();
            parentElement.removeAttributeNode(att);
            this.removeProperty(tagPropertyObject);
        }
    }

    public void removeMatchProperty() {
        TagPropertyObject tagPropertyObject = null;
        List<TagPropertyObject> properties = this.getProperties();
        for (TagPropertyObject tagPropertyObject1 : properties) {
            if (!tagPropertyObject1.getName().equalsIgnoreCase("match")) continue;
            tagPropertyObject = tagPropertyObject1;
            break;
        }
        if (tagPropertyObject != null) {
            Element parentElement = this.getReferenceElement();
            Attr att = tagPropertyObject.getReferenceAttibute();
            parentElement.removeAttributeNode(att);
            this.removeProperty(tagPropertyObject);
        }
    }

    public void setSelectValue(String value) {
        if (value == null) {
            this.removeSelectProperty();
            return;
        }
        TagPropertyObject tagPropertyObject = null;
        List<TagPropertyObject> properties = this.getProperties();
        for (TagPropertyObject tagPropertyObject1 : properties) {
            if (!tagPropertyObject1.getName().equalsIgnoreCase("select")) continue;
            tagPropertyObject = tagPropertyObject1;
            break;
        }
        if (tagPropertyObject == null) {
            tagPropertyObject = new TagPropertyObject();
            Element parentElement = this.getReferenceElement();
            Attr attribute = parentElement.getOwnerDocument().createAttribute("select");
            attribute.setNodeValue(value);
            tagPropertyObject.setReferenceAttibute(attribute);
            parentElement.appendChild(attribute);
            this.addProperty(tagPropertyObject);
        }
        tagPropertyObject.setValue(value);
    }

    public void setMatchValue(String value) {
        TagPropertyObject tagPropertyObject = null;
        List<TagPropertyObject> properties = this.getProperties();
        for (TagPropertyObject tagPropertyObject1 : properties) {
            if (!tagPropertyObject1.getName().equalsIgnoreCase("match")) continue;
            tagPropertyObject = tagPropertyObject1;
            break;
        }
        if (tagPropertyObject == null) {
            tagPropertyObject = new TagPropertyObject();
            Element parentElement = this.getReferenceElement();
            Attr attribute = parentElement.getOwnerDocument().createAttribute("match");
            attribute.setNodeValue(value);
            parentElement.appendChild(attribute);
            tagPropertyObject.setReferenceAttibute(attribute);
            this.addProperty(tagPropertyObject);
        }
        tagPropertyObject.setValue(value);
    }

    public boolean isChoiceElement() {
        return "choose".equalsIgnoreCase(this.getName()) && this.isXSLTag();
    }

    public boolean isIfElement() {
        return "if".equalsIgnoreCase(this.getName()) && this.isXSLTag();
    }

    public boolean isSortElement() {
        return "sort".equalsIgnoreCase(this.getName()) && this.isXSLTag();
    }

    public boolean isForeachElement() {
        return "for-each".equalsIgnoreCase(this.getName()) && this.isXSLTag();
    }

    public boolean isValueOfElement() {
        return "value-of".equalsIgnoreCase(this.getName()) && this.isXSLTag();
    }

    public boolean isTemplateElement() {
        return "template".equalsIgnoreCase(this.getName()) && this.isXSLTag();
    }

    public boolean isApplyTemplatesElement() {
        return "apply-templates".equalsIgnoreCase(this.getName()) && this.isXSLTag();
    }

    public String getMatchValue() {
        List<TagPropertyObject> properties = this.getProperties();
        for (TagPropertyObject tagPropertyObject : properties) {
            if (!tagPropertyObject.getName().equalsIgnoreCase("match")) continue;
            return tagPropertyObject.getValue();
        }
        return null;
    }

    public boolean isXSLTag() {
        return XSLModelAnalyzer.isXSLTagObject(this);
    }

    public boolean isStyleSheetElement() {
        return "stylesheet".equalsIgnoreCase(this.getName()) && this.isXSLTag();
    }
}

