/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.configuration.validate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.jboss.tools.smooks.configuration.editors.uitls.SmooksUIUtils;
import org.jboss.tools.smooks.configuration.validate.AbstractValidator;
import org.jboss.tools.smooks.configuration.validate.Messages;
import org.jboss.tools.smooks.model.smooks.DocumentRoot;
import org.jboss.tools.smooks.model.smooks.SmooksResourceListType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanIdRefValidator
extends AbstractValidator {
    private List<String> idList = new ArrayList<String>();

    @Override
    protected void preStartValidation() {
    }

    @Override
    public List<Diagnostic> validate(Collection<?> selectedObjects, EditingDomain editingDomain) {
        return super.validate(selectedObjects, editingDomain);
    }

    @Override
    protected Diagnostic validateModel(Object model, EditingDomain editingDomain) {
        Object data;
        String idRef = null;
        EStructuralFeature beanIDRefFeature = null;
        if (model instanceof EObject && (beanIDRefFeature = SmooksUIUtils.getBeanIDRefFeature((EObject)model)) != null && (data = ((EObject)model).eGet(beanIDRefFeature)) != null) {
            idRef = data.toString();
        }
        if (idRef != null && !this.idList.contains(idRef) && beanIDRefFeature != null && beanIDRefFeature instanceof EAttribute) {
            return this.newWaringDiagnostic(String.valueOf(Messages.BeanIdRefValidator_Warning_Java_Bean) + idRef + Messages.BeanIdRefValidator_Warning_Does_Not_Exist, model, (EAttribute)beanIDRefFeature);
        }
        return super.validateModel(model, editingDomain);
    }

    @Override
    public void initValidator(Collection<?> selectedObjects, EditingDomain editingDomain) {
        SmooksResourceListType listType;
        List<String> ids;
        this.idList.clear();
        Resource resource = (Resource)editingDomain.getResourceSet().getResources().get(0);
        Object obj = resource.getContents().get(0);
        if (obj instanceof DocumentRoot && (ids = SmooksUIUtils.getBeanIdStringList(listType = ((DocumentRoot)obj).getSmooksResourceList())) != null) {
            this.idList.addAll(ids);
        }
        this.idList.isEmpty();
    }
}

