/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.configuration.validate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.Modifier;
import org.jboss.tools.smooks.configuration.editors.uitls.ProjectClassLoader;
import org.jboss.tools.smooks.configuration.editors.uitls.SmooksUIUtils;
import org.jboss.tools.smooks.configuration.validate.AbstractValidator;
import org.jboss.tools.smooks.configuration.validate.Messages;
import org.jboss.tools.smooks.model.csv12.Binding;
import org.jboss.tools.smooks.model.csv12.Csv12Package;
import org.jboss.tools.smooks.model.javabean12.BeanType;
import org.jboss.tools.smooks.model.javabean12.Javabean12Package;
import org.jboss.tools.smooks.model.rules10.RuleBase;
import org.jboss.tools.smooks.model.rules10.Rules10Package;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassFieldEditorValidator
extends AbstractValidator {
    private ProjectClassLoader classLoader;
    private List<Object> validationTargetList = null;

    public ProjectClassLoader getClassLoader(EObject obj) {
        if (this.classLoader != null) {
            return this.classLoader;
        }
        IResource resource = SmooksUIUtils.getResource(obj);
        if (resource == null) {
            return null;
        }
        try {
            this.classLoader = new ProjectClassLoader(JavaCore.create((IProject)resource.getProject()));
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return this.classLoader;
    }

    protected void initValidationTargetList() {
        ClassValidationTarget target1 = new ClassValidationTarget();
        target1.setFeature((EStructuralFeature)Javabean12Package.Literals.BEAN_TYPE__CLASS);
        target1.setSupportArrayClass(true);
        target1.setTarget(BeanType.class);
        this.validationTargetList.add(target1);
        ClassValidationTarget target2 = new ClassValidationTarget();
        target2.setFeature((EStructuralFeature)Csv12Package.Literals.BINDING__CLASS);
        target2.setTarget(Binding.class);
        this.validationTargetList.add(target2);
        ClassValidationTarget target3 = new ClassValidationTarget();
        target3.setFeature((EStructuralFeature)Rules10Package.Literals.RULE_BASE__PROVIDER);
        target3.setTarget(RuleBase.class);
        this.validationTargetList.add(target3);
    }

    public List<Object> getValidationTargetList() {
        if (this.validationTargetList == null) {
            this.validationTargetList = new ArrayList<Object>();
            this.initValidationTargetList();
        }
        return this.validationTargetList;
    }

    public List<Diagnostic> validate(Collection<?> selectionObjects) {
        ArrayList<Diagnostic> list = new ArrayList<Diagnostic>();
        for (Object object : selectionObjects) {
            List<Diagnostic> dd;
            if (object instanceof EObject) {
                List<Object> targetList = this.getValidationTargetList();
                for (ClassValidationTarget classValidationTarget : targetList) {
                    Class<?> targetClass = classValidationTarget.getTarget();
                    EStructuralFeature feature = classValidationTarget.getFeature();
                    if (!targetClass.isAssignableFrom(object.getClass()) || feature == null) continue;
                    Object value = ((EObject)object).eGet(feature);
                    if (value == null) break;
                    String classString = value.toString();
                    this.classLoader = this.getClassLoader((EObject)object);
                    if (classString == null) continue;
                    classString = classString.trim();
                    if (classValidationTarget.isSupportArrayClass() && classString.endsWith("[]")) {
                        classString = classString.substring(0, classString.length() - 2);
                    }
                    Class<?> clazz1 = null;
                    if (classString != null && this.classLoader != null) {
                        try {
                            clazz1 = this.classLoader.loadClass(classString);
                        }
                        catch (ClassNotFoundException classNotFoundException) {}
                    }
                    String message = null;
                    if (clazz1 == null) {
                        message = String.valueOf(Messages.ClassFieldEditorValidator_Warning_Cannot_Find_Class) + classString + "\"";
                    } else if (Modifier.isAbstract((int)clazz1.getModifiers())) {
                        message = Messages.ClassFieldEditorValidator_Warning_Abstract_Class;
                    } else {
                        try {
                            clazz1.getConstructor(null);
                        }
                        catch (SecurityException securityException) {
                            message = String.valueOf(Messages.ClassFieldEditorValidator_Warning_Class_Cannot_Be_Instanced) + classString + Messages.ClassFieldEditorValidator_Warning_Class_Cannot_Be_Instanced2;
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            message = String.valueOf(Messages.ClassFieldEditorValidator_Warning_Class_Cannot_Be_Instanced) + classString + Messages.ClassFieldEditorValidator_Warning_Class_Cannot_Be_Instanced2;
                        }
                    }
                    if (message == null) break;
                    list.add(this.newWaringDiagnostic(message, object, (EAttribute)feature));
                    break;
                }
            }
            if (!(object instanceof EObject) || (dd = this.validate((Collection<?>)((EObject)object).eContents())) == null) continue;
            list.addAll(dd);
        }
        return list;
    }

    @Override
    public List<Diagnostic> validate(Collection<?> selectedObjects, EditingDomain editingDomain) {
        return this.validate(selectedObjects);
    }

    @Override
    public void initValidator(Collection<?> selectedObjects, EditingDomain editingDomain) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ClassValidationTarget {
        private boolean supportArrayClass = false;
        private EStructuralFeature feature;
        private Class<?> target;

        private ClassValidationTarget() {
        }

        public EStructuralFeature getFeature() {
            return this.feature;
        }

        public void setFeature(EStructuralFeature feature) {
            this.feature = feature;
        }

        public Class<?> getTarget() {
            return this.target;
        }

        public void setTarget(Class<?> target) {
            this.target = target;
        }

        public boolean isSupportArrayClass() {
            return this.supportArrayClass;
        }

        public void setSupportArrayClass(boolean supportArrayClass) {
            this.supportArrayClass = supportArrayClass;
        }
    }
}

