/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.configuration.validate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.jboss.tools.smooks.configuration.validate.AbstractValidator;
import org.jboss.tools.smooks.configuration.validate.Messages;
import org.jboss.tools.smooks.model.freemarker.FreemarkerPackage;
import org.jboss.tools.smooks.model.javabean12.BeanType;
import org.jboss.tools.smooks.model.javabean12.Javabean12Package;
import org.jboss.tools.smooks.model.xsl.BindTo;
import org.jboss.tools.smooks.model.xsl.XslPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DuplicatedBeanIDValidator
extends AbstractValidator {
    private List<String> beanIdList = new ArrayList<String>();

    @Override
    public List<Diagnostic> validate(Collection<?> selectedObjects, EditingDomain editingDomain) {
        ArrayList<Diagnostic> list = new ArrayList<Diagnostic>();
        this.validateModel(selectedObjects, list);
        return list;
    }

    private boolean isDuplicateBeanId(String id) {
        if (id != null) {
            id = id.trim();
        }
        return this.beanIdList.contains(id);
    }

    protected void validateModel(Collection<?> selectedObjects, List<Diagnostic> list) {
        for (Object object : selectedObjects) {
            String beanId;
            if (object instanceof BeanType) {
                beanId = ((BeanType)object).getBeanId();
                if (!this.isDuplicateBeanId(beanId)) continue;
                list.add(this.newWaringDiagnostic(String.valueOf(Messages.DuplicatedBeanIDValidator_Warning_Duplicate_Bean_ID) + beanId, object, Javabean12Package.Literals.BEAN_TYPE__BEAN_ID));
                continue;
            }
            if (object instanceof org.jboss.tools.smooks.model.freemarker.BindTo) {
                beanId = ((org.jboss.tools.smooks.model.freemarker.BindTo)object).getId();
                if (!this.isDuplicateBeanId(beanId)) continue;
                list.add(this.newWaringDiagnostic(String.valueOf(Messages.DuplicatedBeanIDValidator_Warning_Duplicate_Bean_ID) + beanId, object, FreemarkerPackage.Literals.BIND_TO__ID));
                continue;
            }
            if (object instanceof BindTo) {
                beanId = ((BindTo)object).getId();
                if (!this.isDuplicateBeanId(beanId)) continue;
                list.add(this.newWaringDiagnostic(String.valueOf(Messages.DuplicatedBeanIDValidator_Warning_Duplicate_Bean_ID) + beanId, object, XslPackage.Literals.BIND_TO__ID));
                continue;
            }
            if (!(object instanceof EObject)) continue;
            this.validateModel((Collection<?>)((EObject)object).eContents(), list);
        }
    }

    protected void findDuplicatedBeanId(Collection<?> selectedObjects, List<String> idlist) {
        for (Object object : selectedObjects) {
            String beanId;
            if (object instanceof BeanType) {
                beanId = ((BeanType)object).getBeanId();
                if (beanId != null) {
                    beanId = beanId.trim();
                }
                if (idlist.contains(beanId)) {
                    if (this.beanIdList.contains(beanId)) continue;
                    this.beanIdList.add(beanId);
                    continue;
                }
                idlist.add(beanId);
                continue;
            }
            if (object instanceof org.jboss.tools.smooks.model.freemarker.BindTo) {
                beanId = ((org.jboss.tools.smooks.model.freemarker.BindTo)object).getId();
                if (beanId != null) {
                    beanId = beanId.trim();
                }
                if (idlist.contains(beanId)) {
                    if (this.beanIdList.contains(beanId)) continue;
                    this.beanIdList.add(beanId);
                    continue;
                }
                idlist.add(beanId);
                continue;
            }
            if (object instanceof BindTo) {
                beanId = ((BindTo)object).getId();
                if (beanId != null) {
                    beanId = beanId.trim();
                }
                if (idlist.contains(beanId)) {
                    if (this.beanIdList.contains(beanId)) continue;
                    this.beanIdList.add(beanId);
                    continue;
                }
                idlist.add(beanId);
                continue;
            }
            if (!(object instanceof EObject)) continue;
            this.findDuplicatedBeanId((Collection<?>)((EObject)object).eContents(), idlist);
        }
    }

    @Override
    public void initValidator(Collection<?> selectedObjects, EditingDomain editingDomain) {
        this.beanIdList.clear();
        this.findDuplicatedBeanId(selectedObjects, new ArrayList<String>());
        if (this.beanIdList.isEmpty()) {
            return;
        }
    }
}

