/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.configuration.validate;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.jboss.tools.smooks.configuration.editors.uitls.JavaPropertyUtils;
import org.jboss.tools.smooks.configuration.editors.uitls.ProjectClassLoader;
import org.jboss.tools.smooks.configuration.editors.uitls.SmooksUIUtils;
import org.jboss.tools.smooks.configuration.validate.AbstractValidator;
import org.jboss.tools.smooks.configuration.validate.Messages;
import org.jboss.tools.smooks.model.javabean12.ExpressionType;
import org.jboss.tools.smooks.model.javabean12.Javabean12Package;
import org.jboss.tools.smooks.model.javabean12.ValueType;
import org.jboss.tools.smooks.model.javabean12.WiringType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetterMethodValidator
extends AbstractValidator {
    private ProjectClassLoader classLoader;
    private List<Object> validationTargetList = null;

    @Override
    public void initValidator(Collection<?> selectedObjects, EditingDomain editingDomain) {
    }

    public ProjectClassLoader getClassLoader(EObject obj) {
        if (this.classLoader != null) {
            return this.classLoader;
        }
        IResource resource = SmooksUIUtils.getResource(obj);
        if (resource == null) {
            return null;
        }
        try {
            this.classLoader = new ProjectClassLoader(JavaCore.create((IProject)resource.getProject()));
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return this.classLoader;
    }

    public List<Object> getValidationTargetList() {
        if (this.validationTargetList == null) {
            this.validationTargetList = new ArrayList<Object>();
            this.initValidationTargetList();
        }
        return this.validationTargetList;
    }

    protected void initValidationTargetList() {
        PropertySetterValidateTarget target2 = new PropertySetterValidateTarget();
        target2.setPropertyFeature((EStructuralFeature)Javabean12Package.Literals.VALUE_TYPE__PROPERTY);
        target2.setSetterMethodFeature((EStructuralFeature)Javabean12Package.Literals.VALUE_TYPE__SETTER_METHOD);
        target2.setTargetClass(ValueType.class);
        this.validationTargetList.add(target2);
        PropertySetterValidateTarget target6 = new PropertySetterValidateTarget();
        target6.setPropertyFeature((EStructuralFeature)Javabean12Package.Literals.WIRING_TYPE__PROPERTY);
        target6.setSetterMethodFeature((EStructuralFeature)Javabean12Package.Literals.WIRING_TYPE__SETTER_METHOD);
        target6.setTargetClass(WiringType.class);
        this.validationTargetList.add(target6);
        PropertySetterValidateTarget target10 = new PropertySetterValidateTarget();
        target10.setPropertyFeature((EStructuralFeature)Javabean12Package.Literals.EXPRESSION_TYPE__PROPERTY);
        target10.setSetterMethodFeature((EStructuralFeature)Javabean12Package.Literals.EXPRESSION_TYPE__SETTER_METHOD);
        target10.setTargetClass(ExpressionType.class);
        this.validationTargetList.add(target10);
    }

    public List<Diagnostic> validate(Collection<?> selectionObjects) {
        ArrayList<Diagnostic> list = new ArrayList<Diagnostic>();
        for (Object object : selectionObjects) {
            List<Diagnostic> dd;
            if (object instanceof EObject) {
                List<Object> targetList = this.getValidationTargetList();
                for (PropertySetterValidateTarget propertySetterValidateTarget : targetList) {
                    Object classData;
                    Class<?> targetClass = propertySetterValidateTarget.getTargetClass();
                    EStructuralFeature sFeature = propertySetterValidateTarget.getSetterMethodFeature();
                    boolean isSetterMethod = false;
                    if (!targetClass.isInstance(object) || sFeature == null) continue;
                    Object sValue = ((EObject)object).eGet(sFeature);
                    String setterMethodString = null;
                    if (sValue != null) {
                        setterMethodString = sValue.toString();
                        isSetterMethod = true;
                    }
                    if (sValue == null) break;
                    this.classLoader = this.getClassLoader((EObject)object);
                    EStructuralFeature classFeature = SmooksUIUtils.getClassFeature(((EObject)object).eContainer());
                    if (classFeature == null || (classData = ((EObject)object).eContainer().eGet(classFeature)) == null) break;
                    String classString = classData.toString();
                    Class<?> clazz1 = null;
                    if (classString != null && this.classLoader != null) {
                        try {
                            clazz1 = this.classLoader.loadClass(classString);
                        }
                        catch (ClassNotFoundException classNotFoundException) {}
                    }
                    if (clazz1 == null) break;
                    if (setterMethodString != null) {
                        setterMethodString = setterMethodString.trim();
                    }
                    if (!isSetterMethod || setterMethodString.length() == 0 || setterMethodString == null) continue;
                    boolean correct = false;
                    Method[] ms = JavaPropertyUtils.getSetterMethods(clazz1);
                    int i = 0;
                    while (i < ms.length) {
                        Method method = ms[i];
                        if (method.getName().equals(setterMethodString)) {
                            correct = true;
                            break;
                        }
                        ++i;
                    }
                    if (correct) continue;
                    String message = String.valueOf(Messages.SetterMethodValidator_Warning_Setter_Method) + setterMethodString + Messages.SetterMethodValidator_Warning_Cannot_Be_Found;
                    list.add(this.newWaringDiagnostic(message, object, (EAttribute)sFeature));
                }
            }
            if (!(object instanceof EObject) || (dd = this.validate((Collection<?>)((EObject)object).eContents())) == null) continue;
            list.addAll(dd);
        }
        return list;
    }

    @Override
    public List<Diagnostic> validate(Collection<?> selectedObjects, EditingDomain editingDomain) {
        try {
            return this.validate(selectedObjects);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PropertySetterValidateTarget {
        private Class<?> targetClass;
        private EStructuralFeature feature;
        private EStructuralFeature setterMethodFeature;

        private PropertySetterValidateTarget() {
        }

        public EStructuralFeature getSetterMethodFeature() {
            return this.setterMethodFeature;
        }

        public void setSetterMethodFeature(EStructuralFeature setterMethodFeature) {
            this.setterMethodFeature = setterMethodFeature;
        }

        public Class<?> getTargetClass() {
            return this.targetClass;
        }

        public void setTargetClass(Class<?> targetClass) {
            this.targetClass = targetClass;
        }

        public EStructuralFeature getPropertyFeature() {
            return this.feature;
        }

        public void setPropertyFeature(EStructuralFeature feature) {
            this.feature = feature;
        }
    }
}

