/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.configuration.validate;

import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.ui.util.EditUIMarkerHelper;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.jboss.tools.smooks.configuration.SmooksConfigurationActivator;

public class SmooksMarkerHelper
extends EditUIMarkerHelper {
    public static final String MARKER_ID = "org.jboss.tools.smooks.ui.problem";

    public IRunnableWithProgress getWorkspaceModifyOperation(IRunnableWithProgress runnableWithProgress) {
        return new WorkspaceModifyDelegatingOperation(runnableWithProgress);
    }

    protected String getMarkerID() {
        return MARKER_ID;
    }

    public void createMarkers(Resource resource, Diagnostic diagnostic) {
        try {
            this.createMarkers((IResource)this.getFile(resource), diagnostic, null);
        }
        catch (CoreException e) {
            SmooksConfigurationActivator.getDefault();
            SmooksConfigurationActivator.log(e);
        }
    }

    protected String composeMessage(Diagnostic diagnostic, Diagnostic parentDiagnostic) {
        String parentMessage;
        String message = diagnostic.getMessage();
        if (parentDiagnostic != null && (parentMessage = parentDiagnostic.getMessage()) != null) {
            message = message != null ? String.valueOf(parentMessage) + ". " + message : parentMessage;
        }
        return message;
    }

    protected void adjustMarker(IMarker marker, Diagnostic diagnostic, Diagnostic parentDiagnostic) throws CoreException {
        List data = diagnostic.getData();
        StringBuilder relatedURIs = new StringBuilder();
        boolean first = true;
        for (Object object : data) {
            if (!(object instanceof EObject)) continue;
            EObject eObject = (EObject)object;
            if (first) {
                first = false;
                marker.setAttribute("uri", (Object)EcoreUtil.getURI((EObject)eObject).toString());
                continue;
            }
            if (relatedURIs.length() != 0) {
                relatedURIs.append(' ');
            }
            relatedURIs.append(URI.encodeFragment((String)EcoreUtil.getURI((EObject)eObject).toString(), (boolean)false));
        }
        if (relatedURIs.length() > 0) {
            marker.setAttribute("relatedURIs", (Object)relatedURIs.toString());
        }
        super.adjustMarker(marker, diagnostic, parentDiagnostic);
    }
}

