/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.configuration.validate;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.validation.AbstractValidator;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationState;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.jboss.tools.smooks.configuration.validate.BeanIdRefValidator;
import org.jboss.tools.smooks.configuration.validate.ClassFieldEditorValidator;
import org.jboss.tools.smooks.configuration.validate.DuplicatedBeanIDValidator;
import org.jboss.tools.smooks.configuration.validate.ISmooksModelValidateListener;
import org.jboss.tools.smooks.configuration.validate.ISmooksValidator;
import org.jboss.tools.smooks.configuration.validate.Messages;
import org.jboss.tools.smooks.configuration.validate.PropertyValidator;
import org.jboss.tools.smooks.configuration.validate.SelectorValidator;
import org.jboss.tools.smooks.configuration.validate.SetterMethodValidator;
import org.jboss.tools.smooks.configuration.validate.SmooksMarkerHelper;
import org.jboss.tools.smooks.model.calc.provider.CalcItemProviderAdapterFactory;
import org.jboss.tools.smooks.model.common.provider.CommonItemProviderAdapterFactory;
import org.jboss.tools.smooks.model.datasource.provider.DatasourceItemProviderAdapterFactory;
import org.jboss.tools.smooks.model.dbrouting.provider.DbroutingItemProviderAdapterFactory;
import org.jboss.tools.smooks.model.fileRouting.provider.FileRoutingItemProviderAdapterFactory;
import org.jboss.tools.smooks.model.freemarker.provider.FreemarkerItemProviderAdapterFactory;
import org.jboss.tools.smooks.model.groovy.provider.GroovyItemProviderAdapterFactory;
import org.jboss.tools.smooks.model.iorouting.provider.IoroutingItemProviderAdapterFactory;
import org.jboss.tools.smooks.model.jmsrouting.provider.JmsroutingItemProviderAdapterFactory;
import org.jboss.tools.smooks.model.medi.provider.MEdiItemProviderAdapterFactory;
import org.jboss.tools.smooks.model.smooks.provider.SmooksItemProviderAdapterFactory;
import org.jboss.tools.smooks.model.smooks.util.SmooksResourceFactoryImpl;
import org.jboss.tools.smooks.model.xsl.provider.XslItemProviderAdapterFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmooksModelValidator
extends AbstractValidator
implements IValidator,
ISmooksValidator {
    Collection<?> selectedObjects;
    EditingDomain domain;
    private boolean starting = false;
    private boolean waiting = false;
    private Object lock = new Object();
    private AdapterFactoryEditingDomain innerEditingDomain;
    private SmooksMarkerHelper markerHelper = new SmooksMarkerHelper();
    private long watingTime = 300L;
    private List<ISmooksModelValidateListener> listeners = new ArrayList<ISmooksModelValidateListener>();
    private List<ISmooksValidator> validatorList = new ArrayList<ISmooksValidator>();
    private ComposedAdapterFactory adapterFactory;

    public SmooksModelValidator(Collection<?> selectedObjects, EditingDomain domain) {
        this();
        this.selectedObjects = selectedObjects;
        this.domain = domain;
    }

    public SmooksModelValidator() {
        this.validatorList.add(new ClassFieldEditorValidator());
        this.validatorList.add(new DuplicatedBeanIDValidator());
        this.validatorList.add(new BeanIdRefValidator());
        this.validatorList.add(new SelectorValidator());
        this.validatorList.add(new PropertyValidator());
        this.validatorList.add(new SetterMethodValidator());
        this.innerEditingDomain = this.newEditingDomain();
    }

    public void addValidateListener(ISmooksModelValidateListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public void removeValidateListener(ISmooksModelValidateListener l) {
        this.listeners.remove(l);
    }

    @Override
    public List<Diagnostic> validate(Collection<?> selectedObjects, EditingDomain editingDomain) {
        this.selectedObjects = selectedObjects;
        this.domain = editingDomain;
        return this.validate((IProgressMonitor)new NullProgressMonitor());
    }

    public List<Diagnostic> validate(Collection<?> selectedObjects, EditingDomain editingDomain, IProgressMonitor monitor) {
        this.selectedObjects = selectedObjects;
        this.domain = editingDomain;
        return this.validate(monitor);
    }

    public List<Diagnostic> validate(final IProgressMonitor progressMonitor) {
        EObject eObject = (EObject)this.selectedObjects.iterator().next();
        int count = 0;
        TreeIterator i = eObject.eAllContents();
        while (i.hasNext()) {
            ++count;
            i.next();
        }
        progressMonitor.beginTask("", count);
        final AdapterFactory adapterFactory = this.domain instanceof AdapterFactoryEditingDomain ? ((AdapterFactoryEditingDomain)this.domain).getAdapterFactory() : null;
        Diagnostician diagnostician = new Diagnostician(){

            public String getObjectLabel(EObject eObject) {
                IItemLabelProvider itemLabelProvider;
                if (adapterFactory != null && !eObject.eIsProxy() && (itemLabelProvider = (IItemLabelProvider)adapterFactory.adapt((Notifier)eObject, IItemLabelProvider.class)) != null) {
                    return itemLabelProvider.getText((Object)eObject);
                }
                return super.getObjectLabel(eObject);
            }

            public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
                progressMonitor.worked(1);
                return super.validate(eClass, eObject, diagnostics, context);
            }
        };
        progressMonitor.setTaskName(Messages.SmooksModelValidator_Task_Validating);
        Diagnostic diagnostic = diagnostician.validate(eObject);
        ArrayList<Diagnostic> list = new ArrayList<Diagnostic>();
        list.add(diagnostic);
        try {
            for (ISmooksValidator validator : this.validatorList) {
                validator.initValidator(this.selectedObjects, this.domain);
                List<Diagnostic> d = validator.validate(this.selectedObjects, this.domain);
                if (d == null) continue;
                for (Diagnostic diagnostic2 : d) {
                    ((BasicDiagnostic)diagnostic).add(diagnostic2);
                }
            }
        }
        catch (Exception exception) {}
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startValidate(final Collection<?> selectedObjects, final EditingDomain editingDomain) {
        if (this.starting) {
            Object object = this.lock;
            synchronized (object) {
                this.waiting = true;
            }
            return;
        }
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public void run() {
                var1_1 = SmooksModelValidator.access$0(SmooksModelValidator.this);
                synchronized (var1_1) {
                    SmooksModelValidator.access$1(SmooksModelValidator.this, true);
                    SmooksModelValidator.access$2(SmooksModelValidator.this, true);
                    // MONITOREXIT @DISABLED, blocks:[0, 3] lbl6 : MonitorExitStatement: MONITOREXIT : var1_1
                    if (true) ** GOTO lbl18
                }
                do {
                    try {
                        SmooksModelValidator.access$2(SmooksModelValidator.this, false);
                        Thread.sleep(SmooksModelValidator.access$4(SmooksModelValidator.this));
                        Thread.yield();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
lbl18:
                    // 3 sources

                } while (SmooksModelValidator.access$3(SmooksModelValidator.this));
                try {
                    for (final ISmooksModelValidateListener l : SmooksModelValidator.access$5(SmooksModelValidator.this)) {
                        Display.getDefault().syncExec(new Runnable(){

                            public void run() {
                                l.validateStart();
                            }
                        });
                    }
                    d = SmooksModelValidator.this.validate(selectedObjects, editingDomain);
                    for (final ISmooksModelValidateListener l : SmooksModelValidator.access$5(SmooksModelValidator.this)) {
                        dis = Display.getDefault();
                        if (dis == null || dis.isDisposed()) continue;
                        dis.syncExec(new Runnable(){

                            public void run() {
                                l.validateEnd(d);
                            }
                        });
                    }
                }
                finally {
                    SmooksModelValidator.access$2(SmooksModelValidator.this, false);
                    SmooksModelValidator.access$1(SmooksModelValidator.this, false);
                }
            }
        };
        thread.setName(Messages.SmooksModelValidator_Task_Validating_Smooks_Model);
        thread.start();
    }

    private AdapterFactoryEditingDomain newEditingDomain() {
        BasicCommandStack commandStack = new BasicCommandStack();
        if (this.innerEditingDomain == null) {
            this.innerEditingDomain = new AdapterFactoryEditingDomain((AdapterFactory)this.getAdapterFactory(), (CommandStack)commandStack, new HashMap());
        }
        return this.innerEditingDomain;
    }

    public ComposedAdapterFactory getAdapterFactory() {
        if (this.adapterFactory == null) {
            this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
            this.adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
            this.adapterFactory.addAdapterFactory((AdapterFactory)new XslItemProviderAdapterFactory());
            this.adapterFactory.addAdapterFactory((AdapterFactory)new FreemarkerItemProviderAdapterFactory());
            this.adapterFactory.addAdapterFactory((AdapterFactory)new CommonItemProviderAdapterFactory());
            this.adapterFactory.addAdapterFactory((AdapterFactory)new SmooksItemProviderAdapterFactory());
            this.adapterFactory.addAdapterFactory((AdapterFactory)new MEdiItemProviderAdapterFactory());
            this.adapterFactory.addAdapterFactory((AdapterFactory)new IoroutingItemProviderAdapterFactory());
            this.adapterFactory.addAdapterFactory((AdapterFactory)new JmsroutingItemProviderAdapterFactory());
            this.adapterFactory.addAdapterFactory((AdapterFactory)new DbroutingItemProviderAdapterFactory());
            this.adapterFactory.addAdapterFactory((AdapterFactory)new DatasourceItemProviderAdapterFactory());
            this.adapterFactory.addAdapterFactory((AdapterFactory)new CalcItemProviderAdapterFactory());
            this.adapterFactory.addAdapterFactory((AdapterFactory)new GroovyItemProviderAdapterFactory());
            this.adapterFactory.addAdapterFactory((AdapterFactory)new FileRoutingItemProviderAdapterFactory());
            this.adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        }
        return this.adapterFactory;
    }

    public ValidationResult validate(IResource resource, int kind, ValidationState state, IProgressMonitor monitor) {
        AdapterFactoryEditingDomain editingDomain = this.newEditingDomain();
        if (editingDomain == null) {
            return null;
        }
        Object smooksModel = null;
        Resource smooksResource = new SmooksResourceFactoryImpl().createResource(URI.createPlatformResourceURI((String)resource.getFullPath().toPortableString(), (boolean)false));
        editingDomain.getResourceSet().getResources().add((Object)smooksResource);
        try {
            smooksResource.load(Collections.emptyMap());
            smooksModel = smooksResource.getContents().get(0);
        }
        catch (IOException iOException) {
            return null;
        }
        if (smooksModel == null) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(smooksModel);
        List<Diagnostic> d = this.validate(list, (EditingDomain)editingDomain, monitor);
        try {
            this.markerHelper.deleteMarkers(smooksResource);
            for (Diagnostic diagnostic : d) {
                if (resource == null || diagnostic.getSeverity() == 0) continue;
                for (Diagnostic childDiagnostic : diagnostic.getChildren()) {
                    this.markerHelper.createMarkers(smooksResource, childDiagnostic);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public void cleanup(IReporter reporter) {
    }

    public void validate(IValidationContext helper, IReporter reporter) throws ValidationException {
    }

    @Override
    public void initValidator(Collection<?> selectedObjects, EditingDomain editingDomain) {
    }

    static /* synthetic */ Object access$0(SmooksModelValidator smooksModelValidator) {
        return smooksModelValidator.lock;
    }

    static /* synthetic */ void access$1(SmooksModelValidator smooksModelValidator, boolean bl) {
        smooksModelValidator.starting = bl;
    }

    static /* synthetic */ void access$2(SmooksModelValidator smooksModelValidator, boolean bl) {
        smooksModelValidator.waiting = bl;
    }

    static /* synthetic */ boolean access$3(SmooksModelValidator smooksModelValidator) {
        return smooksModelValidator.waiting;
    }

    static /* synthetic */ long access$4(SmooksModelValidator smooksModelValidator) {
        return smooksModelValidator.watingTime;
    }

    static /* synthetic */ List access$5(SmooksModelValidator smooksModelValidator) {
        return smooksModelValidator.listeners;
    }
}

