/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.edimap.editor;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.jboss.tools.smooks.configuration.editors.uitls.SmooksUIUtils;
import org.jboss.tools.smooks.configuration.editors.xml.TagList;
import org.jboss.tools.smooks.configuration.editors.xml.TagObject;
import org.jboss.tools.smooks.edimap.models.EDIDataContainerModel;

public class EDIFileParser {
    public TagList parserEDIFile(String path, char segment, char field, char component, char subcomponent) throws InvocationTargetException, IOException {
        int n;
        TagList tl = new TagList();
        if (!new File(path = SmooksUIUtils.parseFilePath(path)).exists()) {
            return new TagList();
        }
        FileInputStream stream = new FileInputStream(path);
        InputStreamReader reader = new InputStreamReader(stream);
        BufferedReader br = new BufferedReader(reader);
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<String> segmentList = new ArrayList<String>();
        int n2 = -1;
        while ((n = br.read()) != -1) {
            if (n != segment) {
                stringBuffer.append((char)n);
                continue;
            }
            segmentList.add(stringBuffer.toString());
            stringBuffer = null;
            stringBuffer = new StringBuffer();
        }
        if (stringBuffer != null && stringBuffer.toString().length() > 0) {
            segmentList.add(stringBuffer.toString());
            stringBuffer = null;
        }
        br.close();
        reader.close();
        ((InputStream)stream).close();
        ArrayList<String> names = new ArrayList<String>();
        char[] separators = new char[]{field, component, subcomponent};
        for (String string : segmentList) {
            String[] fields = string.split("\\" + new String(new char[]{field}));
            EDIDataContainerModel tag = null;
            if (fields.length != 0) {
                if (names.indexOf(fields[0]) == -1) {
                    tag = new EDIDataContainerModel();
                    tag.setMultipe(false);
                    tag.setName(fields[0].trim());
                    names.add(tag.getName());
                    tl.addRootTag(tag);
                } else {
                    List<TagObject> tagList = tl.getRootTagList();
                    for (TagObject tagObject : tagList) {
                        if (!(tagObject instanceof EDIDataContainerModel) || !fields[0].equals(((EDIDataContainerModel)tagObject).getSegCode())) continue;
                        ((EDIDataContainerModel)tagObject).setMultipe(true);
                        break;
                    }
                }
            }
            if (tag == null) continue;
            String ss = string.substring(fields[0].length(), string.length());
            this.generateChildrenTag(tag, ss, separators, 0);
        }
        return tl;
    }

    private String getSeparator(String s) {
        if (s.equals("*") || s.equals("+") || s.equals("^")) {
            return "\\" + s;
        }
        return s;
    }

    private void generateChildrenTag(TagObject parent, String content, char[] separators, int currentSeparator) {
        char separator = separators[currentSeparator];
        String sss = new String(new char[]{separator});
        if (content.indexOf(sss) == -1) {
            return;
        }
        String[] contentArray = content.split(sss = this.getSeparator(sss));
        if (contentArray == null || contentArray.length == 0) {
            return;
        }
        int i = 0;
        while (i < contentArray.length) {
            String con = contentArray[i];
            if (con != null && con.length() != 0) {
                TagObject child = new TagObject();
                child.setName(con.trim());
                parent.addChildTag(child);
                int newIndex = currentSeparator + 1;
                if (newIndex <= separators.length - 1) {
                    this.generateChildrenTag(child, con, separators, newIndex);
                }
            }
            ++i;
        }
    }
}

