/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.edimap.editor;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.IFormPage;
import org.jboss.tools.smooks.configuration.SmooksConfigurationActivator;
import org.jboss.tools.smooks.edimap.editor.EDIMapFormPage;
import org.jboss.tools.smooks.edimap.editor.Messages;
import org.jboss.tools.smooks.editor.AbstractSmooksFormEditor;
import org.jboss.tools.smooks.model.medi.Delimiters;
import org.jboss.tools.smooks.model.medi.Description;
import org.jboss.tools.smooks.model.medi.DocumentRoot;
import org.jboss.tools.smooks.model.medi.EdiMap;
import org.jboss.tools.smooks.model.medi.MEdiFactory;

public class EDIMapFormEditor
extends AbstractSmooksFormEditor {
    private EDIMapFormPage ediPage = null;

    protected void addPages() {
        try {
            this.ediPage = new EDIMapFormPage(this, "EDIMap", "EDIMap");
            this.addValidateListener(this.ediPage);
            int index = this.addPage((IFormPage)this.ediPage);
            this.setPageText(index, Messages.EDIMapFormEditor_Page_Text);
        }
        catch (PartInitException e) {
            SmooksConfigurationActivator.getDefault();
            SmooksConfigurationActivator.log(e);
        }
        super.addPages();
    }

    protected void handleDocumentChange() {
        super.handleDocumentChange();
        if (this.ediPage != null) {
            this.ediPage.rebuildGUI();
        }
    }

    public void doSave(IProgressMonitor monitor) {
        super.doSave(monitor);
        this.ediPage.doSave(monitor);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        EObject smooksModel = this.getSmooksModel();
        if (smooksModel instanceof DocumentRoot) {
            Delimiters delimiters;
            Description description;
            EdiMap map = ((DocumentRoot)smooksModel).getEdimap();
            if (map == null) {
                map = MEdiFactory.eINSTANCE.createEdiMap();
                ((DocumentRoot)smooksModel).setEdimap(map);
            }
            if ((description = map.getDescription()) == null) {
                description = MEdiFactory.eINSTANCE.createDescription();
                map.setDescription(description);
            }
            if ((delimiters = map.getDelimiters()) == null) {
                delimiters = MEdiFactory.eINSTANCE.createDelimiters();
                map.setDelimiters(delimiters);
            }
        }
    }
}

