/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.edimap.wizard;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.smooks.edimap.wizard.Messages;

public class EDIMappingConfigFileConfigPage
extends WizardPage {
    private String name;
    private String version;
    private String segments;
    private String componentDelimiter;
    private String subComponentDelimiter;
    private String fieldDelimiter;
    private String segmentDelimiter;
    private String ediFilePath;
    private String[] fileExtensionNames;
    private ISelection selection;

    public EDIMappingConfigFileConfigPage(String pageName, String title, ImageDescriptor titleImage, ISelection selection) {
        super(pageName, title, titleImage);
        this.selection = selection;
        this.setTitle(Messages.EDIMappingConfigFileConfigPage_Page_Title);
        this.setDescription(Messages.EDIMappingConfigFileConfigPage_Page_Description);
    }

    public EDIMappingConfigFileConfigPage(String pageName, ISelection selection) {
        super(pageName);
        this.selection = selection;
        this.setTitle(Messages.EDIMappingConfigFileConfigPage_Page_Title);
        this.setDescription(Messages.EDIMappingConfigFileConfigPage_Page_Description);
    }

    public void createControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        GridData gd = new GridData(1808);
        mainComposite.setLayoutData((Object)gd);
        GridLayout mgl = new GridLayout();
        mainComposite.setLayout((Layout)mgl);
        mgl.numColumns = 2;
        mgl.verticalSpacing = 8;
        mgl.horizontalSpacing = 5;
        Label nameLabel = new Label(mainComposite, 0);
        nameLabel.setText(Messages.EDIMappingConfigFileConfigPage_Label_Name);
        final Text nameText = new Text(mainComposite, 2048);
        gd = new GridData(768);
        nameText.setLayoutData((Object)gd);
        nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EDIMappingConfigFileConfigPage.this.setName(nameText.getText());
            }
        });
        Label versionLabel = new Label(mainComposite, 0);
        versionLabel.setText(Messages.EDIMappingConfigFileConfigPage_Label_Version);
        final Text versionText = new Text(mainComposite, 2048);
        gd = new GridData(768);
        versionText.setLayoutData((Object)gd);
        versionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EDIMappingConfigFileConfigPage.this.setVersion(versionText.getText());
            }
        });
        Label segmentsNameLabel = new Label(mainComposite, 0);
        segmentsNameLabel.setText(Messages.EDIMappingConfigFileConfigPage_Label_Root_Tag_Name);
        final Text segmentsNameText = new Text(mainComposite, 2048);
        gd = new GridData(768);
        segmentsNameText.setLayoutData((Object)gd);
        segmentsNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EDIMappingConfigFileConfigPage.this.setSegments(segmentsNameText.getText());
                EDIMappingConfigFileConfigPage.this.updatePageStatus();
            }
        });
        Composite separator = new Composite(mainComposite, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.heightHint = 10;
        separator.setLayoutData((Object)gd);
        Group group = new Group(mainComposite, 0);
        group.setText(Messages.EDIMappingConfigFileConfigPage_Group_Delimiter);
        GridLayout dgl = new GridLayout();
        dgl.numColumns = 2;
        dgl.verticalSpacing = 5;
        dgl.horizontalSpacing = 5;
        group.setLayout((Layout)dgl);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        group.setLayoutData((Object)gd);
        Label segmentLabel = new Label((Composite)group, 0);
        segmentLabel.setText(Messages.EDIMappingConfigFileConfigPage_Label_Segment);
        final Text segmentText = new Text((Composite)group, 2048);
        gd = new GridData(768);
        segmentText.setLayoutData((Object)gd);
        segmentText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EDIMappingConfigFileConfigPage.this.setSegmentDelimiter(segmentText.getText());
            }
        });
        Label fieldLabel = new Label((Composite)group, 0);
        fieldLabel.setText(Messages.EDIMappingConfigFileConfigPage_Label_Field);
        final Text fieldText = new Text((Composite)group, 2048);
        gd = new GridData(768);
        fieldText.setLayoutData((Object)gd);
        fieldText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EDIMappingConfigFileConfigPage.this.setFieldDelimiter(fieldText.getText());
            }
        });
        Label componentLabel = new Label((Composite)group, 0);
        componentLabel.setText(Messages.EDIMappingConfigFileConfigPage_Label_Component);
        final Text compoenentText = new Text((Composite)group, 2048);
        gd = new GridData(768);
        compoenentText.setLayoutData((Object)gd);
        compoenentText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EDIMappingConfigFileConfigPage.this.setComponentDelimiter(compoenentText.getText());
            }
        });
        Label subcomponentLabel = new Label((Composite)group, 0);
        subcomponentLabel.setText(Messages.EDIMappingConfigFileConfigPage_Label_Subcomponent);
        final Text subcompoenentText = new Text((Composite)group, 2048);
        gd = new GridData(768);
        subcompoenentText.setLayoutData((Object)gd);
        subcompoenentText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EDIMappingConfigFileConfigPage.this.setSubComponentDelimiter(subcompoenentText.getText());
            }
        });
        Composite separator1 = new Composite(mainComposite, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.heightHint = 10;
        separator1.setLayoutData((Object)gd);
        Label nfileLanel = new Label(mainComposite, 0);
        nfileLanel.setText("EDI Input Data File : ");
        final Text fileText = new Text(mainComposite, 2048);
        gd = new GridData(768);
        fileText.setLayoutData((Object)gd);
        fileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EDIMappingConfigFileConfigPage.this.setEdiFilePath(fileText.getText());
            }
        });
        Composite browseButtonComposite = new Composite(mainComposite, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        browseButtonComposite.setLayoutData((Object)gd);
        GridLayout bg = new GridLayout();
        bg.numColumns = 2;
        bg.marginHeight = 0;
        bg.marginWidth = 0;
        bg.makeColumnsEqualWidth = false;
        browseButtonComposite.setLayout((Layout)bg);
        final Button fileSystemBrowseButton = new Button(browseButtonComposite, 0);
        fileSystemBrowseButton.setText("Browse File System");
        final Button workspaceBrowseButton = new Button(browseButtonComposite, 0);
        workspaceBrowseButton.setText("Browse WorkSpace");
        gd = new GridData();
        gd.horizontalAlignment = 3;
        workspaceBrowseButton.setLayoutData((Object)gd);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 3;
        fileSystemBrowseButton.setLayoutData((Object)gd);
        SelectionAdapter browseButtonSelectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Text relationT = null;
                if (e.getSource() == fileSystemBrowseButton) {
                    relationT = fileText;
                }
                EDIMappingConfigFileConfigPage.this.openFileSelection(relationT);
            }
        };
        SelectionAdapter wbrowseButtonSelectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Text relationT = null;
                if (e.getSource() == workspaceBrowseButton) {
                    relationT = fileText;
                }
                EDIMappingConfigFileConfigPage.this.openWorkSpaceSelection(relationT);
            }
        };
        fileSystemBrowseButton.addSelectionListener((SelectionListener)browseButtonSelectionAdapter);
        workspaceBrowseButton.addSelectionListener((SelectionListener)wbrowseButtonSelectionAdapter);
        this.setControl((Control)mainComposite);
        this.updatePageStatus();
    }

    protected void openFileSelection(Text relationText) {
        String path;
        FileDialog dialog = new FileDialog(this.getShell());
        if (this.fileExtensionNames != null) {
            String s = "";
            int i = 0;
            while (i < this.fileExtensionNames.length) {
                String exname = this.fileExtensionNames[i];
                s = String.valueOf(s) + "*." + exname + ";";
                ++i;
            }
            if (s.length() != 0) {
                s = s.substring(0, s.length() - 1);
                dialog.setFilterExtensions(new String[]{s, "*.*"});
            }
        }
        if ((path = dialog.open()) != null) {
            path = this.processFileSystemFilePath(path);
            relationText.setText(path);
        }
    }

    protected String processWorkSpaceFilePath(IFile file) {
        String s = file.getFullPath().toPortableString();
        s = "Workspace:/" + s;
        return s;
    }

    protected void openWorkSpaceSelection(Text relationT) {
        IFile[] files;
        Object[] obj = new Object[]{};
        if (this.selection != null && this.selection instanceof IStructuredSelection) {
            obj = ((IStructuredSelection)this.selection).toArray();
        }
        if ((files = WorkspaceResourceDialog.openFileSelection((Shell)this.getShell(), (String)"Select Files", (String)"", (boolean)false, (Object[])obj, null)).length > 0) {
            IFile file = files[0];
            String s = this.processWorkSpaceFilePath(file);
            relationT.setText(s);
        }
    }

    protected String processFileSystemFilePath(String path) {
        path = "File:/" + path;
        return path;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getSegments() {
        return this.segments;
    }

    public void setSegments(String segments) {
        this.segments = segments;
    }

    public String getComponentDelimiter() {
        return this.componentDelimiter;
    }

    public void setComponentDelimiter(String componentDelimiter) {
        this.componentDelimiter = componentDelimiter;
    }

    public String getSubComponentDelimiter() {
        return this.subComponentDelimiter;
    }

    public void setSubComponentDelimiter(String subComponentDelimiter) {
        this.subComponentDelimiter = subComponentDelimiter;
    }

    public String getFieldDelimiter() {
        return this.fieldDelimiter;
    }

    public void setFieldDelimiter(String fieldDelimiter) {
        this.fieldDelimiter = fieldDelimiter;
    }

    public String getSegmentDelimiter() {
        return this.segmentDelimiter;
    }

    public void setSegmentDelimiter(String segmentDelimiter) {
        this.segmentDelimiter = segmentDelimiter;
    }

    public String getEdiFilePath() {
        return this.ediFilePath;
    }

    public void setEdiFilePath(String ediFilePath) {
        this.ediFilePath = ediFilePath;
    }

    private void updatePageStatus() {
        String error = null;
        if (this.segments == null || this.segments.length() == 0) {
            error = Messages.EDIMappingConfigFileConfigPage_Error_Root_Name_Cannot_Be_Null;
        }
        this.setErrorMessage(error);
        this.setPageComplete(error == null);
    }
}

