/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.edimap.wizard;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.jboss.tools.smooks.configuration.SmooksConfigurationActivator;
import org.jboss.tools.smooks.edimap.wizard.EDIMappingConfigFileConfigPage;
import org.jboss.tools.smooks.edimap.wizard.EDIMappingConfigFileContainerSelectionPage;
import org.jboss.tools.smooks.edimap.wizard.Messages;
import org.jboss.tools.smooks.model.medi.Delimiters;
import org.jboss.tools.smooks.model.medi.Description;
import org.jboss.tools.smooks.model.medi.DocumentRoot;
import org.jboss.tools.smooks.model.medi.EdiMap;
import org.jboss.tools.smooks.model.medi.MEdiFactory;
import org.jboss.tools.smooks.model.medi.Segments;
import org.jboss.tools.smooks.model.medi.util.MEdiResourceFactoryImpl;

public class EDIMappingConfigFileWizard
extends Wizard
implements INewWizard {
    private EDIMappingConfigFileContainerSelectionPage pathPage;
    private EDIMappingConfigFileConfigPage configPage;
    private IStructuredSelection selection;

    public boolean performFinish() {
        final IPath containerPath = this.pathPage.getContainerFullPath();
        final String fileName = this.pathPage.getFileName();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        EDIMappingConfigFileWizard.this.doFinish(containerPath, fileName, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.EDIMappingConfigFileWizard_Error_Title, (String)realException.getMessage());
            return false;
        }
        return true;
    }

    public void addPages() {
        if (this.pathPage == null) {
            this.pathPage = new EDIMappingConfigFileContainerSelectionPage(Messages.EDIMappingConfigFileWizard_File_Selection_Page_Title, this.selection);
        }
        this.addPage((IWizardPage)this.pathPage);
        if (this.configPage == null) {
            this.configPage = new EDIMappingConfigFileConfigPage(Messages.EDIMappingConfigFileWizard_Config_Title, (ISelection)this.selection);
        }
        this.addPage((IWizardPage)this.configPage);
        super.addPages();
    }

    private void doFinish(IPath containerPath, String fileName, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(String.valueOf(Messages.EDIMappingConfigFileWizard_Creating_Task) + fileName, 2);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember(containerPath);
        IContainer container = null;
        if (resource.exists() && resource instanceof IContainer) {
            container = (IContainer)resource;
        }
        if (container == null) {
            this.throwCoreException(String.valueOf(Messages.EDIMappingConfigFileWizard_Exception_Container_Does_Not_Exist) + containerPath.toPortableString() + Messages.EDIMappingConfigFileWizard_Exception_Container_Does_Not_Exist2);
        }
        final IFile configFile = container.getFile((IPath)new Path(fileName));
        String extFileName = String.valueOf(fileName) + ".ext";
        IFile extFile = container.getFile((IPath)new Path(extFileName));
        try {
            InputStream stream = this.openContentStream();
            if (configFile.exists()) {
                configFile.setContents(stream, true, true, monitor);
            } else {
                configFile.create(stream, true, monitor);
            }
            stream.close();
            EDIMappingConfigFileWizard.createExtentionFile(extFile, monitor, this.configPage.getEdiFilePath());
        }
        catch (IOException e) {
            SmooksConfigurationActivator.getDefault();
            SmooksConfigurationActivator.log(e);
        }
        monitor.worked(1);
        monitor.setTaskName(Messages.EDIMappingConfigFileWizard_Task_Opening_Smooks_Editor);
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)configFile);
                }
                catch (PartInitException e) {
                    SmooksConfigurationActivator.getDefault();
                    SmooksConfigurationActivator.log(e);
                }
            }
        });
        monitor.worked(1);
    }

    private InputStream openContentStream() throws IOException {
        Resource resource = new MEdiResourceFactoryImpl().createResource(null);
        DocumentRoot docRoot = MEdiFactory.eINSTANCE.createDocumentRoot();
        resource.getContents().add((Object)docRoot);
        EdiMap map = MEdiFactory.eINSTANCE.createEdiMap();
        docRoot.setEdimap(map);
        Description description = MEdiFactory.eINSTANCE.createDescription();
        map.setDescription(description);
        this.initDescription(description);
        Delimiters delimiters = MEdiFactory.eINSTANCE.createDelimiters();
        map.setDelimiters(delimiters);
        this.initDelimiters(delimiters);
        Segments segments = MEdiFactory.eINSTANCE.createSegments();
        map.setSegments(segments);
        String se = this.configPage.getSegments();
        if (se != null) {
            segments.setXmltag(se);
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        resource.save((OutputStream)output, Collections.emptyMap());
        return new ByteArrayInputStream(output.toByteArray());
    }

    private void initDelimiters(Delimiters delimiters) {
        if (this.configPage != null) {
            String subComponent;
            String component;
            String field;
            String segment = this.configPage.getSegmentDelimiter();
            if (segment != null) {
                delimiters.setSegment(segment);
            }
            if ((field = this.configPage.getFieldDelimiter()) != null) {
                delimiters.setField(field);
            }
            if ((component = this.configPage.getComponentDelimiter()) != null) {
                delimiters.setComponent(component);
            }
            if ((subComponent = this.configPage.getSubComponentDelimiter()) != null) {
                delimiters.setSubComponent(subComponent);
            }
        }
    }

    private void initDescription(Description description) {
        if (this.configPage != null) {
            String version;
            String name = this.configPage.getName();
            if (name != null) {
                description.setName(name);
            }
            if ((version = this.configPage.getVersion()) != null) {
                description.setVersion(version);
            }
        }
    }

    public static void createExtentionFile(IFile file, IProgressMonitor monitor, String ediPath) throws CoreException, IOException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        InputStream stream1 = EDIMappingConfigFileWizard.createExtContentStream(ediPath);
        if (file.exists()) {
            file.setContents(stream1, true, true, monitor);
        } else {
            file.create(stream1, true, monitor);
        }
        stream1.close();
    }

    public static InputStream createExtContentStream(String filePath) {
        String path = filePath;
        if (path == null) {
            path = "";
        }
        String contents = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n    <smooks-graphics-ext xmlns=\"http://www.jboss.org/jbosstools/smooks/smooks-graphics-ext.xsd\">\n        <input type=\"EDI\">\n            <param name=\"path\">" + path + "</param>\n" + "        </input>\n" + "        <graph/>\n" + "    </smooks-graphics-ext>";
        return new ByteArrayInputStream(contents.getBytes());
    }

    private void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "org.jboss.tools.smooks.ui", 0, message, null);
        throw new CoreException((IStatus)status);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }
}

