/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.editor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.DeleteCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.jboss.tools.smooks.configuration.RuntimeDependency;
import org.jboss.tools.smooks.configuration.RuntimeMetadata;
import org.jboss.tools.smooks.configuration.SmooksConfigurationActivator;
import org.jboss.tools.smooks.configuration.editors.SmooksXMLEditor;
import org.jboss.tools.smooks.configuration.editors.uitls.SmooksUIUtils;
import org.jboss.tools.smooks.configuration.editors.xml.XMLUtils;
import org.jboss.tools.smooks.configuration.validate.ISmooksModelValidateListener;
import org.jboss.tools.smooks.configuration.validate.SmooksMarkerHelper;
import org.jboss.tools.smooks.configuration.validate.SmooksModelValidator;
import org.jboss.tools.smooks.editor.ISmooksModelProvider;
import org.jboss.tools.smooks.editor.ISourceSynchronizeListener;
import org.jboss.tools.smooks.editor.Messages;
import org.jboss.tools.smooks.graphical.editors.ISmooksEditorInitListener;
import org.jboss.tools.smooks.model.calc.provider.CalcItemProviderAdapterFactory;
import org.jboss.tools.smooks.model.common.AbstractAnyType;
import org.jboss.tools.smooks.model.common.provider.CommonItemProviderAdapterFactory;
import org.jboss.tools.smooks.model.csv12.provider.Csv12ItemProviderAdapterFactory;
import org.jboss.tools.smooks.model.datasource.provider.DatasourceItemProviderAdapterFactory;
import org.jboss.tools.smooks.model.dbrouting.provider.DbroutingItemProviderAdapterFactory;
import org.jboss.tools.smooks.model.edi12.provider.Edi12ItemProviderAdapterFactory;
import org.jboss.tools.smooks.model.esbrouting.provider.EsbroutingItemProviderAdapterFactory;
import org.jboss.tools.smooks.model.fileRouting.provider.FileRoutingItemProviderAdapterFactory;
import org.jboss.tools.smooks.model.freemarker.provider.FreemarkerItemProviderAdapterFactory;
import org.jboss.tools.smooks.model.groovy.provider.GroovyItemProviderAdapterFactory;
import org.jboss.tools.smooks.model.iorouting.provider.IoroutingItemProviderAdapterFactory;
import org.jboss.tools.smooks.model.javabean12.provider.Javabean12ItemProviderAdapterFactory;
import org.jboss.tools.smooks.model.jmsrouting.provider.JmsroutingItemProviderAdapterFactory;
import org.jboss.tools.smooks.model.jmsrouting12.provider.Jmsrouting12ItemProviderAdapterFactory;
import org.jboss.tools.smooks.model.json12.provider.Json12ItemProviderAdapterFactory;
import org.jboss.tools.smooks.model.medi.provider.MEdiItemProviderAdapterFactory;
import org.jboss.tools.smooks.model.persistence12.provider.Persistence12ItemProviderAdapterFactory;
import org.jboss.tools.smooks.model.rules10.provider.Rules10ItemProviderAdapterFactory;
import org.jboss.tools.smooks.model.smooks.DocumentRoot;
import org.jboss.tools.smooks.model.smooks.ParamType;
import org.jboss.tools.smooks.model.smooks.SmooksResourceListType;
import org.jboss.tools.smooks.model.smooks.provider.SmooksItemProviderAdapterFactory;
import org.jboss.tools.smooks.model.smooks.util.SmooksResourceFactoryImpl;
import org.jboss.tools.smooks.model.validation10.provider.Validation10ItemProviderAdapterFactory;
import org.jboss.tools.smooks.model.xsl.provider.XslItemProviderAdapterFactory;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractSmooksFormEditor
extends FormEditor
implements IEditingDomainProvider,
ISmooksModelValidateListener,
ISmooksModelProvider {
    private IResourceChangeListener resourceChangeListener = null;
    private IDocumentListener xmlDocumentTraker = null;
    private Exception initSmooksModelException = null;
    protected String platformVersion = "1.2";
    protected List<ISmooksEditorInitListener> smooksInitListener = new ArrayList<ISmooksEditorInitListener>();
    protected String inputType = null;
    protected List<ISourceSynchronizeListener> sourceSynchronizeListener = new ArrayList<ISourceSynchronizeListener>();
    public static final String EDITOR_ID = "org.jboss.tools.smooks.edimap.editors.MultiPageEditor";
    protected StructuredTextEditor textEditor = null;
    protected ComposedAdapterFactory adapterFactory;
    protected EditingDomain editingDomain = null;
    protected SmooksModelValidator validator = null;
    protected EObject smooksModel;
    private boolean handleEMFModelChange;
    protected SmooksMarkerHelper markerHelper = new SmooksMarkerHelper();
    protected List<Diagnostic> diagnosticList;
    protected boolean graphChanged = false;

    public AbstractSmooksFormEditor() {
        this.resourceChangeListener = new SmooksResourceTraker();
        this.xmlDocumentTraker = new SmooksXMLEditorDocumentListener();
        this.initEditingDomain();
    }

    @Override
    public String getInputType() {
        ParamType inputParam = SmooksUIUtils.getInputTypeParam(SmooksUIUtils.getSmooks11ResourceListType(this.smooksModel));
        if (inputParam != null) {
            return inputParam.getStringValue();
        }
        return null;
    }

    public void setInputType(String inputType) {
        this.inputType = inputType;
    }

    @Override
    public String getPlatformVersion() {
        return this.platformVersion;
    }

    public void setPlatformVersion(String platformVersion) {
        this.platformVersion = platformVersion;
    }

    public void addSmooksEditorInitListener(ISmooksEditorInitListener listener) {
        this.smooksInitListener.add(listener);
    }

    public void removeSmooksEditorInitListener(ISmooksEditorInitListener listener) {
        this.smooksInitListener.remove(listener);
    }

    public Object getAdapter(Class adapter) {
        if (adapter == ISmooksModelProvider.class) {
            return this;
        }
        if (adapter == IEditingDomainProvider.class) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    public void addSourceSynchronizeListener(ISourceSynchronizeListener listener) {
        this.sourceSynchronizeListener.add(listener);
    }

    public void removeSourceSynchronizeListener(ISourceSynchronizeListener listener) {
        this.sourceSynchronizeListener.remove(listener);
    }

    private void handleCommandStack(BasicCommandStack commandStack) {
        commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(EventObject event) {
                AbstractSmooksFormEditor.this.firePropertyChange(257);
                AbstractSmooksFormEditor.this.handleEMFModelChange();
                final Command mostRecentCommand = ((CommandStack)event.getSource()).getMostRecentCommand();
                AbstractSmooksFormEditor.this.getContainer().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (mostRecentCommand != null) {
                            Command rawCommand = mostRecentCommand;
                            while (rawCommand instanceof CommandWrapper) {
                                rawCommand = ((CommandWrapper)rawCommand).getCommand();
                            }
                            if (rawCommand instanceof SetCommand || rawCommand instanceof AddCommand || rawCommand instanceof DeleteCommand) {
                                AbstractSmooksFormEditor.this.activeRecentAffectedModel(mostRecentCommand.getAffectedObjects());
                            }
                        }
                    }
                });
            }
        });
    }

    public StructuredTextEditor getTextEditor() {
        return this.textEditor;
    }

    protected ByteArrayOutputStream getFormattedXMLContentsStream(InputStream outstream) throws IOException {
        try {
            Document doc = XMLUtils.getDOMBuilder().parse(outstream);
            EObject rootModel = this.getSmooksModel();
            this.fillComments(doc, rootModel);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            XMLUtils.outDOMNode((Node)doc, stream);
            return stream;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    protected void fillComments(Document document, EObject rootModel) {
        try {
            if (rootModel instanceof DocumentRoot) {
                SmooksResourceListType rootElementModel = ((DocumentRoot)rootModel).getSmooksResourceList();
                Element rootElement = document.getDocumentElement();
                try {
                    this.fillComments((EObject)rootElementModel, rootElement);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Throwable throwable) {}
    }

    protected void fillComments(EObject rootElementModel, Element rootElement) {
        if (rootElementModel instanceof AbstractAnyType) {
            List comments = ((AbstractAnyType)rootElementModel).getCommentList();
            for (String string : comments) {
                Integer commentIndex = ((AbstractAnyType)rootElementModel).getCommentIndex(string);
                List<Element> content = XMLUtils.getAllChildElements(rootElement);
                ArrayList<Node> deletedElementList = new ArrayList<Node>();
                if (commentIndex < content.size()) {
                    ArrayList<Element> tempelements = new ArrayList<Element>(content);
                    int i = commentIndex;
                    while (i < content.size()) {
                        Element deleteObj = (Element)tempelements.get(i);
                        Node remodedObj = rootElement.removeChild(deleteObj);
                        if (remodedObj != null) {
                            deletedElementList.add(remodedObj);
                        }
                        ++i;
                    }
                }
                Comment comment = rootElement.getOwnerDocument().createComment(string);
                rootElement.appendChild(comment);
                int j = 0;
                while (j < deletedElementList.size()) {
                    Element deleteElement = (Element)deletedElementList.get(j);
                    rootElement.appendChild(deleteElement);
                    ++j;
                }
            }
            EList childrenModel = ((AbstractAnyType)rootElementModel).eContents();
            List<Element> elements = XMLUtils.getAllChildElements(rootElement);
            int length = Math.min(childrenModel.size(), elements.size());
            int index = 0;
            while (index < length) {
                EObject child = (EObject)childrenModel.get(index);
                Element childElement = elements.get(index);
                this.fillComments(child, childElement);
                ++index;
            }
        }
    }

    protected String getFormattedXMLContents(String contents) throws IOException {
        ByteArrayInputStream istream = null;
        ByteArrayOutputStream stream = null;
        try {
            istream = new ByteArrayInputStream(contents.getBytes());
            stream = this.getFormattedXMLContentsStream(istream);
            String string = new String(stream.toByteArray());
            return string;
        }
        catch (Throwable throwable) {
        }
        finally {
            if (istream != null) {
                ((InputStream)istream).close();
            }
            if (stream != null) {
                stream.close();
            }
        }
        return null;
    }

    protected void handleEMFModelChange() {
        IDocument document = this.textEditor.getDocumentProvider().getDocument((Object)this.textEditor.getEditorInput());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.smooksModel.eResource().save((OutputStream)out, null);
            String newContent = out.toString();
            newContent = this.getFormattedXMLContents(newContent);
            String oldContent = document.get();
            int startIndex = 0;
            while (startIndex < newContent.length() && startIndex < oldContent.length() && newContent.charAt(startIndex) == oldContent.charAt(startIndex)) {
                ++startIndex;
            }
            int newEndIndex = newContent.length() - 1;
            int oldEndIndex = oldContent.length() - 1;
            while (newEndIndex >= startIndex && oldEndIndex >= startIndex && newContent.charAt(newEndIndex) == oldContent.charAt(oldEndIndex)) {
                --newEndIndex;
                --oldEndIndex;
            }
            String replacement = newContent.substring(startIndex, newEndIndex + 1);
            int length = oldEndIndex - startIndex + 1;
            this.handleEMFModelChange = true;
            document.replace(startIndex, length, replacement);
            this.validator.startValidate((Collection<?>)this.smooksModel.eResource().getContents(), this.editingDomain);
        }
        catch (Exception exception) {
            SmooksConfigurationActivator.getDefault();
            SmooksConfigurationActivator.log(exception);
        }
    }

    public boolean isDirty() {
        return this.graphChanged || ((BasicCommandStack)this.editingDomain.getCommandStack()).isSaveNeeded() || super.isDirty();
    }

    @Override
    public EObject getSmooksModel() {
        return this.smooksModel;
    }

    @Override
    public void setSmooksModel(EObject smooksModel) {
        if (this.smooksModel != smooksModel) {
            this.smooksModel = smooksModel;
            this.handleEMFModelChange();
        }
    }

    protected void initEditingDomain() {
        this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new XslItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new FreemarkerItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new CommonItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new SmooksItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new MEdiItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new IoroutingItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new JmsroutingItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new DbroutingItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new DatasourceItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new CalcItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new GroovyItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new FileRoutingItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new EsbroutingItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new Json12ItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new Edi12ItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new Javabean12ItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new Csv12ItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new Rules10ItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new Validation10ItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new Jmsrouting12ItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new Persistence12ItemProviderAdapterFactory());
        BasicCommandStack commandStack = new BasicCommandStack();
        this.handleCommandStack(commandStack);
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)this.adapterFactory, (CommandStack)commandStack, new HashMap());
    }

    public void activeRecentAffectedModel(Collection<?> collection) {
    }

    public void addValidateListener(ISmooksModelValidateListener listener) {
        this.validator.addValidateListener(listener);
    }

    public void removeValidateListener(ISmooksModelValidateListener listener) {
        this.validator.removeValidateListener(listener);
    }

    protected void addPages() {
        this.textEditor = this.createTextEditor();
        try {
            int index = this.addPage((IEditorPart)this.textEditor, this.getEditorInput());
            this.setPageText(index, Messages.AbstractSmooksFormEditor_Source_Page_Title);
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        int messageType = 3;
        Exception exception = this.initSmooksModelException;
        if (exception == null) {
            exception = this.checkSmooksConfigContents(null);
            messageType = 2;
        }
        if (exception != null) {
            for (ISmooksEditorInitListener initListener : this.smooksInitListener) {
                initListener.initFailed(messageType, exception.getMessage());
            }
        }
    }

    protected StructuredTextEditor createTextEditor() {
        SmooksXMLEditor xmlEditor = new SmooksXMLEditor(){

            public void doSetInput(IEditorInput input) throws CoreException {
                IDocument document;
                StructuredTextViewer viewer = this.getTextViewer();
                if (viewer != null && (document = viewer.getDocument()) != null) {
                    document.removeDocumentListener(AbstractSmooksFormEditor.this.xmlDocumentTraker);
                }
                super.doSetInput(input);
                viewer = this.getTextViewer();
                if (viewer != null && (document = viewer.getDocument()) != null) {
                    document.addDocumentListener(AbstractSmooksFormEditor.this.xmlDocumentTraker);
                }
            }

            public void createPartControl(Composite parent) {
                super.createPartControl(parent);
                this.getTextViewer().getDocument().addDocumentListener(AbstractSmooksFormEditor.this.xmlDocumentTraker);
            }
        };
        return xmlEditor;
    }

    protected void createNewModelViaTextPage() {
        int messageType;
        Exception exception;
        block23: {
            IDocumentProvider dp = this.textEditor.getDocumentProvider();
            if (dp == null) {
                return;
            }
            exception = null;
            messageType = 0;
            IDocument document = dp.getDocument((Object)this.textEditor.getEditorInput());
            String conents = document.get();
            Resource resource = (Resource)this.editingDomain.getResourceSet().getResources().get(0);
            resource.unload();
            ByteArrayInputStream stream = null;
            stream = new ByteArrayInputStream(conents.getBytes());
            exception = this.checkSmooksConfigContents(stream);
            if (exception != null) {
                messageType = 2;
            }
            if (exception == null) {
                try {
                    try {
                        stream = new ByteArrayInputStream(conents.getBytes());
                        resource.load((InputStream)stream, Collections.emptyMap());
                        this.smooksModel = (EObject)resource.getContents().get(0);
                    }
                    catch (Exception e) {
                        this.smooksModel = null;
                        exception = e;
                        messageType = 3;
                        if (stream != null) {
                            try {
                                ((InputStream)stream).close();
                            }
                            catch (IOException e2) {
                                e2.printStackTrace();
                            }
                        }
                        break block23;
                    }
                }
                catch (Throwable throwable) {
                    if (stream != null) {
                        try {
                            ((InputStream)stream).close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    throw throwable;
                }
                if (stream != null) {
                    try {
                        ((InputStream)stream).close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        this.setPlatformVersion(SmooksUIUtils.judgeSmooksPlatformVersion(this.smooksModel));
        this.judgeInputReader();
        for (ISourceSynchronizeListener l : this.sourceSynchronizeListener) {
            try {
                l.sourceChange(this.smooksModel);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        String message = null;
        if (exception != null) {
            message = exception.getMessage();
        }
        if (message == null) {
            message = Messages.AbstractSmooksFormEditor_Error_Unknown;
        }
        for (ISmooksEditorInitListener initListener : this.smooksInitListener) {
            initListener.initFailed(messageType, message);
        }
    }

    protected void handleDocumentChange() {
        this.createNewModelViaTextPage();
        try {
            this.validator.startValidate((Collection<?>)this.smooksModel.eResource().getContents(), this.editingDomain);
        }
        catch (Throwable throwable) {}
    }

    protected void initSaveOptions(Map<?, ?> options) {
    }

    public void doSave(IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            try {
                IEditorPart activeEditor = this.getActiveEditor();
                if (this.smooksModel == null || activeEditor != null && activeEditor == this.textEditor) {
                    this.textEditor.doSave(monitor);
                    ((BasicCommandStack)this.editingDomain.getCommandStack()).saveIsDone();
                } else {
                    Map options = Collections.emptyMap();
                    this.initSaveOptions(options);
                    if (this.editingDomain != null) {
                        ResourceSet resourceSet = this.editingDomain.getResourceSet();
                        EList resourceList = resourceSet.getResources();
                        monitor.beginTask(Messages.AbstractSmooksFormEditor_Task_Saving_File, resourceList.size());
                        Iterator iterator = resourceList.iterator();
                        while (iterator.hasNext()) {
                            block26: {
                                this.handleEMFModelChange = true;
                                Resource resource = (Resource)iterator.next();
                                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                                resource.save((OutputStream)outputStream, options);
                                IResource file = SmooksUIUtils.getResource(resource);
                                if (file.exists() && file instanceof IFile) {
                                    ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
                                    ByteArrayOutputStream newOutputStream = this.getFormattedXMLContentsStream(inputStream);
                                    try {
                                        try {
                                            ((IFile)file).setContents((InputStream)new ByteArrayInputStream(newOutputStream.toByteArray()), 1, monitor);
                                        }
                                        catch (CoreException e) {
                                            e.printStackTrace();
                                            if (outputStream != null) {
                                                outputStream.close();
                                            }
                                            if (newOutputStream != null) {
                                                newOutputStream.close();
                                            }
                                            if (inputStream != null) {
                                                inputStream.close();
                                            }
                                            break block26;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        if (outputStream != null) {
                                            outputStream.close();
                                        }
                                        if (newOutputStream != null) {
                                            newOutputStream.close();
                                        }
                                        if (inputStream != null) {
                                            inputStream.close();
                                        }
                                        throw throwable;
                                    }
                                    if (outputStream != null) {
                                        outputStream.close();
                                    }
                                    if (newOutputStream != null) {
                                        newOutputStream.close();
                                    }
                                    if (inputStream != null) {
                                        inputStream.close();
                                    }
                                }
                            }
                            monitor.worked(1);
                        }
                        ((BasicCommandStack)this.editingDomain.getCommandStack()).saveIsDone();
                        this.textEditor.doRevertToSaved();
                    }
                }
                this.graphChanged = false;
                this.firePropertyChange(257);
                if (this.smooksModel != null && this.validator != null) {
                    this.validator.startValidate((Collection<?>)this.smooksModel.eResource().getContents(), this.editingDomain);
                }
            }
            catch (IOException e) {
                SmooksConfigurationActivator.log(e);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    public void setInput(IEditorInput input) {
        IFile file;
        if (this.getEditorInput() != null) {
            file = ((IFileEditorInput)this.getEditorInput()).getFile();
            file.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        }
        super.setInput(input);
        if (this.getEditorInput() != null) {
            file = ((IFileEditorInput)this.getEditorInput()).getFile();
            file.getWorkspace().addResourceChangeListener(this.resourceChangeListener);
            this.setPartName(file.getName());
        }
        String filePath = null;
        IFile file2 = null;
        if (input instanceof IFileEditorInput) {
            file2 = ((IFileEditorInput)input).getFile();
            filePath = file2.getFullPath().toPortableString();
        }
        this.editingDomain.getResourceSet().getResources().clear();
        Resource smooksResource = null;
        smooksResource = file2 != null ? new SmooksResourceFactoryImpl().createResource(URI.createPlatformResourceURI((String)filePath, (boolean)false)) : new SmooksResourceFactoryImpl().createResource(URI.createFileURI((String)filePath));
        this.editingDomain.getResourceSet().getResources().add((Object)smooksResource);
        Exception ex = this.checkSmooksConfigContents(null);
        if (ex == null) {
            if (this.smooksModel == null) {
                try {
                    smooksResource.load(Collections.emptyMap());
                    this.smooksModel = (EObject)smooksResource.getContents().get(0);
                }
                catch (IOException e) {
                    this.initSmooksModelException = e;
                }
            } else {
                smooksResource.getContents().add((Object)this.smooksModel);
            }
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (this.validator == null) {
            this.validator = new SmooksModelValidator();
            this.addValidateListener(this);
        }
        RuntimeMetadata runtimeMetadata = new RuntimeMetadata();
        String filePath = null;
        IFile file = null;
        if (input instanceof FileStoreEditorInput) {
            try {
                filePath = ((FileStoreEditorInput)input).getURI().toURL().getFile();
                runtimeMetadata.setSmooksConfig(new File(filePath));
            }
            catch (MalformedURLException e) {
                throw new PartInitException(Messages.AbstractSmooksFormEditor_Exception_Transform_URL, (Throwable)e);
            }
        }
        if (input instanceof IFileEditorInput) {
            file = ((IFileEditorInput)input).getFile();
            runtimeMetadata.setSmooksConfig((IResource)file);
            filePath = file.getFullPath().toPortableString();
        }
        if (filePath == null) {
            throw new PartInitException(Messages.AbstractSmooksFormEditor_Exception_Cannot_Get_Input_File);
        }
        super.init(site, input);
        if (this.smooksModel != null) {
            this.setDiagnosticList(this.validator.validate((Collection<?>)this.smooksModel.eResource().getContents(), this.editingDomain));
            String version = SmooksUIUtils.judgeSmooksPlatformVersion(this.smooksModel);
            this.setPlatformVersion(version);
            this.judgeInputReader();
        }
    }

    private void assertConfigSupported(RuntimeMetadata runtimeMetadata) throws PartInitException {
        List<RuntimeDependency> dependencies = runtimeMetadata.getDependencies();
        for (RuntimeDependency dependency : dependencies) {
            if (dependency.isSupportedByEditor()) continue;
            java.net.URI changeToNS = dependency.getChangeToNS();
            String errorMsg = String.valueOf(Messages.AbstractSmooksFormEditor_Error_Unsupported) + dependency.getNamespaceURI() + Messages.AbstractSmooksFormEditor_Error_Unsupported2;
            if (changeToNS != null) {
                errorMsg = String.valueOf(errorMsg) + Messages.AbstractSmooksFormEditor_Error_Update_Namespace + changeToNS + Messages.AbstractSmooksFormEditor_Error_Update_Namespace2;
            }
            throw new PartInitException(errorMsg);
        }
    }

    protected Exception checkSmooksConfigContents(InputStream stream) {
        Throwable exception = null;
        IFile file = null;
        String filePath = null;
        RuntimeMetadata runtimeMetadata = new RuntimeMetadata();
        IEditorInput input = this.getEditorInput();
        if (input instanceof FileStoreEditorInput) {
            try {
                filePath = ((FileStoreEditorInput)input).getURI().toURL().getFile();
                runtimeMetadata.setSmooksConfig(new File(filePath), stream);
            }
            catch (MalformedURLException e) {
                exception = e;
            }
        }
        if (exception == null) {
            if (input instanceof IFileEditorInput) {
                file = ((IFileEditorInput)input).getFile();
                File f = new File(file.getRawLocation().toOSString().trim());
                runtimeMetadata.setSmooksConfig(f, stream);
            }
            try {
                this.assertConfigSupported(runtimeMetadata);
            }
            catch (PartInitException e) {
                exception = e;
            }
        }
        return exception;
    }

    protected void judgeInputReader() {
        SmooksResourceListType resourceList = SmooksUIUtils.getSmooks11ResourceListType(this.smooksModel);
        if (resourceList == null) {
            return;
        }
        ParamType param = SmooksUIUtils.getInputTypeParam(resourceList);
        String inputType = null;
        if (param != null) {
            inputType = param.getStringValue();
            String realInputType = SmooksUIUtils.judgeInputType(this.smooksModel);
            if (realInputType == null) {
                if (inputType != null && !inputType.equals("input.xml") && !inputType.equals("input.java")) {
                    inputType.equals("input.xsd");
                }
            } else if (!realInputType.equals(inputType)) {
                param.setStringValue(realInputType);
                inputType = realInputType;
            }
        } else {
            inputType = SmooksUIUtils.judgeInputType(this.smooksModel);
            if (inputType != null) {
                SmooksUIUtils.addInputTypeParam(inputType, resourceList);
            }
        }
        this.setInputType(inputType);
    }

    public EObject getSmooksResourceList() {
        SmooksResourceListType m = null;
        EObject smooksModel = this.getSmooksModel();
        if (smooksModel instanceof DocumentRoot) {
            m = ((DocumentRoot)smooksModel).getSmooksResourceList();
        }
        return m;
    }

    public IPath getNewPath(IFile file) {
        IPath fullPath = file.getFullPath();
        fullPath.removeLastSegments(1);
        fullPath.append("New name");
        return fullPath;
    }

    public void doSaveAs() {
    }

    public ComposedAdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    public void setAdapterFactory(ComposedAdapterFactory adapterFactory) {
        this.adapterFactory = adapterFactory;
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public void setEditingDomain(EditingDomain editingDomain) {
        this.editingDomain = editingDomain;
    }

    @Override
    public List<Diagnostic> getDiagnosticList() {
        return this.diagnosticList;
    }

    @Override
    public void setDiagnosticList(List<Diagnostic> d) {
        this.diagnosticList = d;
        if (this.markerHelper != null) {
            Resource resource = (Resource)this.editingDomain.getResourceSet().getResources().get(0);
            if (resource != null) {
                this.markerHelper.deleteMarkers(resource);
            }
            for (Diagnostic diagnostic : d) {
                if (resource == null || diagnostic.getSeverity() == 0) continue;
                for (Diagnostic childDiagnostic : diagnostic.getChildren()) {
                    this.markerHelper.createMarkers(resource, childDiagnostic);
                }
            }
        }
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    @Override
    public void validateEnd(List<Diagnostic> diagnosticResult) {
        this.setDiagnosticList(diagnosticResult);
    }

    @Override
    public void validateStart() {
    }

    public void graphPropertyChange(EStructuralFeature featre, Object value) {
    }

    private void closeEditor(boolean forceSave) {
        this.close(forceSave);
    }

    public class SmooksResourceTraker
    implements IResourceChangeListener,
    IResourceDeltaVisitor {
        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                if (delta != null) {
                    delta.accept((IResourceDeltaVisitor)this);
                }
            }
            catch (CoreException coreException) {}
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            if (delta == null || !delta.getResource().equals((Object)((IFileEditorInput)AbstractSmooksFormEditor.this.getEditorInput()).getFile())) {
                return true;
            }
            if (delta.getKind() == 2) {
                Display display = AbstractSmooksFormEditor.this.getSite().getShell().getDisplay();
                if ((0x2000 & delta.getFlags()) == 0) {
                    display.asyncExec(new Runnable(){

                        public void run() {
                            AbstractSmooksFormEditor.this.closeEditor(false);
                        }
                    });
                } else {
                    final IFile newFile = ResourcesPlugin.getWorkspace().getRoot().getFile(delta.getMovedToPath());
                    display.asyncExec(new Runnable(){

                        public void run() {
                            AbstractSmooksFormEditor.this.setInput((IEditorInput)new FileEditorInput(newFile));
                        }
                    });
                }
            }
            return false;
        }
    }

    public class SmooksXMLEditorDocumentListener
    implements IDocumentListener {
        protected Timer timer = new Timer();
        protected TimerTask timerTask;

        public void documentAboutToBeChanged(DocumentEvent documentEvent) {
        }

        public void documentChanged(DocumentEvent documentEvent) {
            try {
                if (this.timerTask != null) {
                    this.timerTask.cancel();
                }
                if (AbstractSmooksFormEditor.this.handleEMFModelChange) {
                    AbstractSmooksFormEditor.this.handleEMFModelChange = false;
                } else {
                    this.timerTask = new TimerTask(){

                        public void run() {
                            AbstractSmooksFormEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                                public void run() {
                                    AbstractSmooksFormEditor.this.handleDocumentChange();
                                }
                            });
                        }
                    };
                    this.timer.schedule(this.timerTask, 1000L);
                }
            }
            catch (Exception exception) {
                SmooksConfigurationActivator.log(exception);
            }
        }
    }
}

