/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.gef.tree.editparts;

import org.eclipse.gef.commands.Command;
import org.jboss.tools.smooks.gef.model.AbstractSmooksGraphicalModel;
import org.jboss.tools.smooks.gef.tree.model.BeanReferenceConnection;
import org.jboss.tools.smooks.gef.tree.model.TreeNodeConnection;
import org.jboss.tools.smooks.gef.tree.model.TriggerConnection;
import org.jboss.tools.smooks.gef.tree.model.ValueBindingConnection;
import org.jboss.tools.smooks.graphical.editors.model.InputDataTreeNodeModel;
import org.jboss.tools.smooks.graphical.editors.model.freemarker.FreemarkerTemplateConnection;
import org.jboss.tools.smooks.graphical.editors.model.freemarker.FreemarkerXMLNodeGraphicalModel;
import org.jboss.tools.smooks.graphical.editors.model.javamapping.JavaBeanChildGraphModel;
import org.jboss.tools.smooks.graphical.editors.model.javamapping.JavaBeanGraphModel;

public class CreateConnectionCommand
extends Command {
    private AbstractSmooksGraphicalModel source;
    private AbstractSmooksGraphicalModel target;
    private TreeNodeConnection tempConnectionHandle = null;

    public void execute() {
        if (this.source != null && this.target != null) {
            TreeNodeConnection connection = null;
            if (this.target instanceof JavaBeanChildGraphModel && this.source instanceof InputDataTreeNodeModel) {
                connection = new ValueBindingConnection(this.source, this.target);
            }
            if (this.source instanceof JavaBeanChildGraphModel && this.target instanceof JavaBeanGraphModel) {
                connection = new BeanReferenceConnection(this.source, this.target);
            }
            if (this.source instanceof InputDataTreeNodeModel && connection == null) {
                connection = new TriggerConnection(this.source, this.target);
            }
            if (this.target instanceof FreemarkerXMLNodeGraphicalModel) {
                connection = new FreemarkerTemplateConnection();
                connection.setSourceNode(this.source);
                connection.setTargetNode(this.target);
            }
            if (connection == null) {
                connection = new TreeNodeConnection(this.source, this.target);
            }
            connection.connect();
            this.tempConnectionHandle = connection;
        }
    }

    public void redo() {
        if (this.tempConnectionHandle != null) {
            this.tempConnectionHandle.connect();
        } else {
            this.execute();
        }
    }

    public void undo() {
        if (this.tempConnectionHandle != null) {
            this.tempConnectionHandle.disconnect();
        }
    }

    public AbstractSmooksGraphicalModel getSource() {
        return this.source;
    }

    public void setSource(AbstractSmooksGraphicalModel source) {
        this.source = source;
    }

    public AbstractSmooksGraphicalModel getTarget() {
        return this.target;
    }

    public void setTarget(AbstractSmooksGraphicalModel target) {
        this.target = target;
    }
}

