/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.gef.tree.editparts;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.DirectEditPolicy;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.tools.ConnectionDragCreationTool;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.graphics.Image;
import org.jboss.tools.smooks.configuration.SmooksConfigurationActivator;
import org.jboss.tools.smooks.gef.tree.editparts.AbstractTreeEditPart;
import org.jboss.tools.smooks.gef.tree.editparts.CreateConnectionCommand;
import org.jboss.tools.smooks.gef.tree.editparts.TreeContainerEditPart;
import org.jboss.tools.smooks.gef.tree.editparts.TreeNodeConnectionEditPart;
import org.jboss.tools.smooks.gef.tree.editpolicy.FigureHighlightEditPolicy;
import org.jboss.tools.smooks.gef.tree.editpolicy.TreeNodeGraphicalNodeEditPolicy;
import org.jboss.tools.smooks.gef.tree.editpolicy.TreeNodeSelectEditPolicy;
import org.jboss.tools.smooks.gef.tree.figures.ITreeFigureListener;
import org.jboss.tools.smooks.gef.tree.figures.LeftOrRightAnchor;
import org.jboss.tools.smooks.gef.tree.figures.TreeContainerFigure;
import org.jboss.tools.smooks.gef.tree.figures.TreeFigureExpansionEvent;
import org.jboss.tools.smooks.gef.tree.figures.TreeNodeFigure;
import org.jboss.tools.smooks.gef.tree.figures.TreeNodeTextDirectManager;
import org.jboss.tools.smooks.gef.tree.figures.TreeNodeTextDirectManagerLocator;
import org.jboss.tools.smooks.gef.tree.model.IConnectableNode;
import org.jboss.tools.smooks.gef.tree.model.TreeNodeModel;
import org.jboss.tools.smooks.graphical.editors.model.IValidatableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeNodeEditPart
extends AbstractTreeEditPart
implements ITreeFigureListener,
NodeEditPart {
    protected boolean childrenLoaded = false;
    private IFigure anchorFigure = null;
    protected DirectEditManager editManager = null;
    protected Label errorLabel = new Label();
    protected Label warningLabel = new Label();

    protected IFigure createFigure() {
        TreeNodeModel model = (TreeNodeModel)this.getModel();
        TreeNodeFigure figure = new TreeNodeFigure(model);
        figure.addTreeListener(this);
        return figure;
    }

    protected void performDirectEdit() {
        if (this.canDirectEdit()) {
            if (this.editManager == null) {
                this.editManager = this.createDirectEditManager();
            }
            this.editManager.show();
        }
    }

    protected DirectEditManager createDirectEditManager() {
        Label l = ((TreeNodeFigure)this.getFigure()).getLabel();
        return new TreeNodeTextDirectManager((GraphicalEditPart)this, TextCellEditor.class, new TreeNodeTextDirectManagerLocator(l), l);
    }

    protected boolean canDirectEdit() {
        return false;
    }

    protected boolean isDragLink() {
        return false;
    }

    public DragTracker getDragTracker(Request request) {
        if (this.isDragLink()) {
            this.getViewer().select((EditPart)this);
            return new ConnectionDragCreationTool();
        }
        return super.getDragTracker(request);
    }

    public TreeContainerEditPart getTreeContainerEditPart() {
        EditPart parent = this.getParent();
        while (parent != null && parent.getClass() != TreeContainerEditPart.class) {
            parent = parent.getParent();
        }
        if (parent != null && parent.getClass() == TreeContainerEditPart.class) {
            return (TreeContainerEditPart)parent;
        }
        return null;
    }

    public void expandNode() {
        IFigure figure1 = this.getFigure();
        if (figure1 instanceof TreeNodeFigure) {
            ((TreeNodeFigure)figure1).expandNode();
        }
    }

    public void collapsedNode() {
        IFigure figure1 = this.getFigure();
        if (figure1 instanceof TreeNodeFigure) {
            ((TreeNodeFigure)figure1).collapsedNode();
        }
    }

    public boolean isSourceLinkNodeEditPart() {
        TreeContainerEditPart container = this.getTreeContainerEditPart();
        if (container != null) {
            return container.isSourceLinkNodeEditPart();
        }
        return true;
    }

    protected Command createDirectEditCommand(DirectEditRequest request) {
        return null;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new DirectEditPolicy(){

            protected Command getDirectEditCommand(DirectEditRequest request) {
                return TreeNodeEditPart.this.createDirectEditCommand(request);
            }

            protected void showCurrentEditValue(DirectEditRequest request) {
            }
        });
        this.installEditPolicy("NodeEditPolicy", (EditPolicy)new TreeNodeGraphicalNodeEditPolicy());
        this.installEditPolicy("SELECTED", (EditPolicy)new TreeNodeSelectEditPolicy());
        this.installEditPolicy("Selection Feedback", (EditPolicy)new FigureHighlightEditPolicy());
    }

    public IFigure getContentPane() {
        TreeNodeFigure figure = (TreeNodeFigure)this.getFigure();
        return figure.getContentFigure();
    }

    protected void refreshVisuals() {
        try {
            TreeNodeModel node = (TreeNodeModel)this.getModel();
            String text = node.getText();
            if (text != null) {
                ((TreeNodeFigure)this.getFigure()).setLabelText(text);
            }
            Label tooltip = null;
            int serverity = node.getSeverity();
            String message = this.getSeverityMessage(node);
            Image image = node.getImage();
            if (serverity == -1) {
                image = node.getImage();
            }
            if (serverity == 4) {
                image = SmooksConfigurationActivator.getDefault().getImageRegistry().get("icons/full/obj16/error_obj.gif");
                tooltip = this.errorLabel;
                tooltip.setText(message);
            }
            if (serverity == 2) {
                image = SmooksConfigurationActivator.getDefault().getImageRegistry().get("icons/full/obj16/warning_obj.gif");
                tooltip = this.warningLabel;
                tooltip.setText(message);
            }
            if (image != null) {
                ((TreeNodeFigure)this.getFigure()).setLabelImage(image);
            }
            ((TreeNodeFigure)this.getFigure()).setToolTip((IFigure)tooltip);
            IFigure parent = this.getFigure();
            while (parent != null && !(parent instanceof FreeformLayer)) {
                parent = parent.getParent();
            }
            if (parent != null) {
                parent.repaint();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    protected String getSeverityMessage(IValidatableModel model) {
        List<String> messages = model.getMessage();
        String message = null;
        for (String string : messages) {
            message = message == null ? " - " + string : String.valueOf(message) + "\n" + " - " + string;
        }
        return message;
    }

    public List<?> getModelChildren() {
        if (this.childrenLoaded) {
            TreeNodeModel node = (TreeNodeModel)this.getModel();
            return node.getChildren();
        }
        return Collections.emptyList();
    }

    public void childrenModelChanged() {
        this.refreshChildren();
    }

    @Override
    public void treeCollapsed(TreeFigureExpansionEvent event) {
        this.caculateAnchorFigure();
    }

    @Override
    public void treeExpanded(TreeFigureExpansionEvent event) {
        if (!this.childrenLoaded) {
            this.childrenLoaded = true;
            this.refreshChildren();
            this.refreshVisuals();
        }
        this.caculateAnchorFigure();
    }

    public void performRequest(Request request) {
        if (request.getType() == "direct edit") {
            this.performDirectEdit();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String proName = evt.getPropertyName();
        if ("_pro_severity_changed".equals(proName)) {
            this.refreshVisuals();
        }
        if ("_pro_force_text_changed".equals(proName) || "_pro_text_changed".equals(proName)) {
            this.refreshVisuals();
        }
        if ("_pro_add_child".equals(proName) || "_pro_move_child".equals(proName) || "_pro_remove_child".equals(proName) || "_pro_force_children_changed".equals(proName)) {
            this.refreshChildren();
            this.expandNode();
            this.refreshVisuals();
        }
        if ("_pro_add_source_connected".equals(proName) || "_pro_remove_source_connected".equals(proName)) {
            this.refreshSourceConnections();
        }
        if ("_pro_add_target_connected".equals(proName) || "_pro_remove_target_connected".equals(proName)) {
            this.refreshTargetConnections();
        }
        if ("_pro_force_connection_changed".equals(proName)) {
            this.refreshSourceConnections();
            this.refreshTargetConnections();
        }
    }

    protected String generateFigureID() {
        return null;
    }

    protected IFigure getAnchorFigure() {
        IFigure figure;
        if (this.anchorFigure != null) {
            return this.anchorFigure;
        }
        this.anchorFigure = figure = this.getFigure();
        if (figure instanceof TreeContainerFigure) {
            this.anchorFigure = ((TreeContainerFigure)figure).getLabel();
        }
        if (figure instanceof TreeNodeFigure) {
            this.anchorFigure = ((TreeNodeFigure)figure).getLabel();
        }
        return this.anchorFigure;
    }

    public void caculateAnchorFigure() {
        this.anchorFigure = null;
        EditPart parent = this.getParent();
        ArrayList<TreeNodeEditPart> parentList = new ArrayList<TreeNodeEditPart>();
        while (parent != null && parent instanceof TreeNodeEditPart) {
            parentList.add((TreeNodeEditPart)parent);
            if (parent.getParent() == null || !(parent.getParent() instanceof TreeNodeEditPart)) break;
            parent = parent.getParent();
        }
        int i = parentList.size() - 1;
        while (i >= 0) {
            TreeNodeEditPart p = (TreeNodeEditPart)parentList.get(i);
            if (!p.isExpanded()) {
                this.anchorFigure = p.getAnchorFigure();
                break;
            }
            --i;
        }
        int alpha = 255;
        if (this.anchorFigure != null) {
            alpha = 20;
        }
        List sourceConnectionEditParts = this.getSourceConnections();
        for (Object con : sourceConnectionEditParts) {
            if (!(con instanceof TreeNodeConnectionEditPart)) continue;
            ((TreeNodeConnectionEditPart)con).changeLineAlpha(alpha);
            ((TreeNodeConnectionEditPart)con).refresh();
        }
        List targetConnectionEditParts = this.getTargetConnections();
        for (Object con : targetConnectionEditParts) {
            if (!(con instanceof TreeNodeConnectionEditPart)) continue;
            ((TreeNodeConnectionEditPart)con).changeLineAlpha(alpha);
            ((TreeNodeConnectionEditPart)con).refresh();
        }
        List childrenEditParts = this.getChildren();
        for (EditPart child : childrenEditParts) {
            if (!(child instanceof TreeNodeEditPart)) continue;
            ((TreeNodeEditPart)child).caculateAnchorFigure();
        }
    }

    public boolean isExpanded() {
        IFigure f = this.getFigure();
        if (f instanceof TreeNodeFigure) {
            return ((TreeNodeFigure)f).isExpand();
        }
        return true;
    }

    protected List<?> getModelSourceConnections() {
        Object model = this.getModel();
        if (model instanceof IConnectableNode) {
            return ((IConnectableNode)model).getSourceConnections();
        }
        return Collections.emptyList();
    }

    protected List<?> getModelTargetConnections() {
        Object model = this.getModel();
        if (model instanceof IConnectableNode) {
            return ((IConnectableNode)model).getTargetConnections();
        }
        return Collections.emptyList();
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        try {
            return new LeftOrRightAnchor(this.getAnchorFigure());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        try {
            return new LeftOrRightAnchor(this.getAnchorFigure());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return new LeftOrRightAnchor(this.getAnchorFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return new LeftOrRightAnchor(this.getAnchorFigure());
    }

    public CreateConnectionCommand createCreateConnectionCommand() {
        return null;
    }
}

