/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.gef.tree.figures;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.jboss.tools.smooks.configuration.SmooksConfigurationActivator;
import org.jboss.tools.smooks.configuration.editors.GraphicsConstants;
import org.jboss.tools.smooks.gef.tree.editpolicy.IShowHighlighFigure;
import org.jboss.tools.smooks.gef.tree.figures.DragLinkFigure;
import org.jboss.tools.smooks.gef.tree.figures.ISelectableFigure;
import org.jboss.tools.smooks.gef.tree.model.TreeContainerModel;

public class TreeContainerFigure
extends Figure
implements ISelectableFigure,
IShowHighlighFigure {
    private IFigure headerFigure;
    private IFigure contentFigure;
    private Label label;
    private TreeContainerModel model;
    private Color targetHeaderColor = GraphicsConstants.TB_BG_CORLOR;
    private Color sourceHeaderColor = ColorConstants.orange;
    protected Color targetHeaderSelectedColor = FigureUtilities.lighter((Color)this.targetHeaderColor);
    protected Color sourceHeaderSelectedColor = FigureUtilities.lighter((Color)this.sourceHeaderColor);
    private boolean focus;
    private boolean selected;
    private Color highlightColor = null;
    private boolean showHightlight = false;
    private IFigure dragLinkFigure = null;
    private boolean showDragLink = false;
    private boolean isSource = true;

    public TreeContainerFigure(TreeContainerModel model) {
        this.model = model;
        this.addChildrenFigures();
        this.hookFigure();
    }

    public boolean isSource() {
        return this.isSource;
    }

    public void setSource(boolean isSource) {
        this.isSource = isSource;
    }

    protected void hookFigure() {
        this.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent me) {
            }

            public void mouseEntered(MouseEvent me) {
                TreeContainerFigure.this.showDragLink = true;
                TreeContainerFigure.this.dragLinkFigure.repaint();
            }

            public void mouseExited(MouseEvent me) {
                TreeContainerFigure.this.showDragLink = false;
                TreeContainerFigure.this.dragLinkFigure.repaint();
            }

            public void mouseHover(MouseEvent me) {
            }

            public void mouseMoved(MouseEvent me) {
            }
        });
    }

    protected void addChildrenFigures() {
        Figure headerContainerFigure = new Figure();
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        headerContainerFigure.setLayoutManager((LayoutManager)gl);
        this.headerFigure = new Figure(){

            protected void paintFigure(Graphics graphics) {
                super.paintFigure(graphics);
                TreeContainerFigure.this.drawHeaderFigure(graphics);
            }

            public Dimension getPreferredSize(int hint, int hint2) {
                Dimension size = super.getPreferredSize(hint, hint2);
                int width = Math.max(size.width, 100);
                return new Dimension(width, 25);
            }
        };
        this.headerFigure.add((IFigure)headerContainerFigure);
        this.label = new Label();
        headerContainerFigure.add((IFigure)this.label);
        ToolbarLayout layout = new ToolbarLayout();
        layout.setMinorAlignment(0);
        GridData gd = new GridData(1808);
        gl.setConstraint((IFigure)this.label, (Object)gd);
        this.dragLinkFigure = new DragLinkFigure(){

            protected void paintFigure(Graphics graphics) {
                super.paintFigure(graphics);
                if (TreeContainerFigure.this.showDragLink) {
                    if (TreeContainerFigure.this.model instanceof TreeContainerModel && !TreeContainerFigure.this.model.canDragLink()) {
                        return;
                    }
                    Image img = SmooksConfigurationActivator.getDefault().getImageRegistry().get("icons/full/obj16/drag_link.gif");
                    if (img != null) {
                        graphics.drawImage(img, this.getLocation());
                    }
                }
            }
        };
        this.dragLinkFigure.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent me) {
            }

            public void mouseEntered(MouseEvent me) {
                TreeContainerFigure.this.showDragLink = true;
                TreeContainerFigure.this.dragLinkFigure.repaint();
            }

            public void mouseExited(MouseEvent me) {
                TreeContainerFigure.this.showDragLink = false;
                TreeContainerFigure.this.dragLinkFigure.repaint();
            }

            public void mouseHover(MouseEvent me) {
            }

            public void mouseMoved(MouseEvent me) {
            }
        });
        this.dragLinkFigure.setSize(16, 16);
        gd = new GridData();
        gd.horizontalAlignment = 3;
        gl.setConstraint(this.dragLinkFigure, (Object)gd);
        headerContainerFigure.add(this.dragLinkFigure);
        this.headerFigure.setLayoutManager((LayoutManager)layout);
        this.headerFigure.setOpaque(true);
        this.contentFigure = new Figure();
        this.contentFigure.setLayoutManager((LayoutManager)new ToolbarLayout());
        this.add(this.headerFigure);
        this.add(this.contentFigure);
        ToolbarLayout tl = new ToolbarLayout();
        tl.setMinorAlignment(0);
        this.setLayoutManager((LayoutManager)tl);
    }

    protected void drawHeaderFigure(Graphics graphics) {
        try {
            graphics.pushState();
            Color currentColor = this.sourceHeaderColor;
            if (!this.isSource) {
                currentColor = this.targetHeaderColor;
            }
            if (this.isSelected() || this.isFocus()) {
                currentColor = this.sourceHeaderSelectedColor;
                if (!this.isSource) {
                    currentColor = this.targetHeaderSelectedColor;
                }
            }
            if (this.showHightlight && this.highlightColor != null) {
                currentColor = this.highlightColor;
            }
            graphics.setForegroundColor(currentColor);
            graphics.setBackgroundColor(ColorConstants.white);
            graphics.fillGradient(this.headerFigure.getBounds().expand(30, 0), true);
            graphics.setForegroundColor(currentColor);
            graphics.drawLine(this.getBounds().getBottomLeft().translate(0, -1), this.getBounds().getBottomRight().translate(0, -1));
            graphics.popState();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Label getLabel() {
        return this.label;
    }

    public void setLabel(Label label) {
        this.label = label;
    }

    public IFigure getContentFigure() {
        return this.contentFigure;
    }

    public Color getHeaderColor() {
        return this.targetHeaderColor;
    }

    public void setHeaderColor(Color headerColor) {
        this.targetHeaderColor = headerColor;
    }

    public Rectangle getBounds() {
        Rectangle rect = super.getBounds();
        if (this.getLayoutManager() != null) {
            Dimension d = this.getLayoutManager().getPreferredSize((IFigure)this, -1, -1);
            rect.setSize(d);
        }
        return rect;
    }

    protected void paintBorder(Graphics graphics) {
        try {
            graphics.setForegroundColor(ColorConstants.buttonDarkest);
            if (this.isSelected() || this.isFocus()) {
                graphics.setForegroundColor(GraphicsConstants.BORDER_CORLOR);
            }
            if (this.showHightlight && this.highlightColor != null) {
                graphics.setForegroundColor(FigureUtilities.darker((Color)this.highlightColor));
            }
            Rectangle drawnRectangle = new Rectangle(this.getBounds().x, this.getBounds().y, this.getBounds().width - 1, this.getBounds().height - 1);
            graphics.drawRoundRectangle(drawnRectangle, 5, 5);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setText(String text) {
        if (this.label != null) {
            this.label.setText(text);
        }
    }

    public TreeContainerModel getModel() {
        return this.model;
    }

    public void setModel(TreeContainerModel model) {
        this.model = model;
    }

    protected void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        graphics.pushState();
        graphics.setAlpha(190);
        graphics.setBackgroundColor(ColorConstants.white);
        graphics.fillRectangle(this.getBounds());
        graphics.popState();
    }

    public void setIcon(Image i) {
        if (this.label != null) {
            this.label.setIcon(i);
        }
    }

    public IFigure getHeaderFigure() {
        return this.headerFigure;
    }

    public void setHeaderFigure(IFigure headerFigure) {
        this.headerFigure = headerFigure;
    }

    public boolean isFocus() {
        return this.focus;
    }

    public void setFocus(boolean focus) {
        this.focus = focus;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        this.repaint();
    }

    public void setContentFigure(IFigure contentFigure) {
        this.contentFigure = contentFigure;
        this.repaint();
    }

    public void showbackOldbackgroundColor(Color color) {
        this.showHightlight = false;
        this.highlightColor = null;
        this.repaint();
    }

    public void showHighlightBackgroudColor(Color color) {
        this.showHightlight = true;
        this.highlightColor = color;
        this.repaint();
    }
}

