/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.gef.tree.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.graphics.Image;
import org.jboss.tools.smooks.gef.model.AbstractSmooksGraphicalModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeNodeModel
extends AbstractSmooksGraphicalModel {
    protected ITreeContentProvider contentProvider;
    protected ILabelProvider labelProvider;

    public TreeNodeModel(Object data, ITreeContentProvider contentProvider, ILabelProvider labelProvider) {
        super(data);
        this.setContentProvider(contentProvider);
        this.setLabelProvider(labelProvider);
        this.setData(data);
    }

    @Override
    public boolean hasChildren() {
        if (this.contentProvider != null && this.data != null) {
            return this.contentProvider.hasChildren(this.data);
        }
        return true;
    }

    public ITreeContentProvider getContentProvider() {
        return this.contentProvider;
    }

    public void setContentProvider(ITreeContentProvider contentProvider) {
        this.contentProvider = contentProvider;
    }

    public ILabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public void setLabelProvider(ILabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    protected TreeNodeModel createChildModel(Object model, ITreeContentProvider contentProvider, ILabelProvider labelProvider) {
        return new TreeNodeModel(model, contentProvider, labelProvider);
    }

    @Override
    public List<AbstractSmooksGraphicalModel> getChildren() {
        Object[] models;
        if (this.children == null) {
            Object[] models2;
            if (this.contentProvider != null && this.data != null && (models2 = this.contentProvider.getChildren(this.data)) != null) {
                this.children = new ArrayList();
                int i = 0;
                while (i < models2.length) {
                    Object model = models2[i];
                    TreeNodeModel n = this.createChildModel(model, this.contentProvider, this.labelProvider);
                    if (n != null) {
                        this.children.add(n);
                        n.setParent(this);
                    }
                    ++i;
                }
                return this.children;
            }
            return Collections.emptyList();
        }
        if (this.contentProvider != null && this.data != null && (models = this.contentProvider.getChildren(this.data)) != null) {
            int i = 0;
            while (i < models.length) {
                TreeNodeModel n;
                Object model = models[i];
                if (!this.childExsit(model) && (n = this.createChildModel(model, this.contentProvider, this.labelProvider)) != null) {
                    this.children.add(n);
                    n.setParent(this);
                }
                ++i;
            }
            ArrayList temp = new ArrayList(this.children);
            for (AbstractSmooksGraphicalModel node : temp) {
                Object data = node.getData();
                if (this.graphicalChildExist(data, models)) continue;
                TreeNodeModel.disconnectAllConnections(node);
                this.children.remove(node);
                node.setParent(null);
            }
            temp.clear();
            Object var2_5 = null;
        }
        return this.children;
    }

    @Override
    public String getText() {
        if (this.data != null && this.labelProvider != null) {
            return this.labelProvider.getText(this.data);
        }
        return "";
    }

    @Override
    public Image getImage() {
        if (this.data != null && this.labelProvider != null) {
            return this.labelProvider.getImage(this.data);
        }
        return null;
    }

    @Override
    public boolean canLinkWithSource(Object model) {
        return true;
    }

    @Override
    public boolean canLinkWithTarget(Object model) {
        return true;
    }

    @Override
    public void setText(String text) {
    }
}

