/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.graphical.actions;

import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbenchPart;
import org.jboss.tools.smooks.graphical.editors.SmooksGraphicalEditorPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AddSmooksModelAction
extends SelectionAction {
    public AddSmooksModelAction(IWorkbenchPart part, int style) {
        super(part, style);
    }

    public AddSmooksModelAction(IWorkbenchPart part) {
        super(part);
    }

    protected boolean calculateEnabled() {
        Command cmd = this.createAddChildNodeCommand(this.getSelectedObjects());
        if (cmd == null) {
            return false;
        }
        return cmd.canExecute();
    }

    protected Command createAddChildNodeCommand(List<?> objects) {
        if (objects.isEmpty()) {
            return null;
        }
        if (!(objects.get(0) instanceof EditPart)) {
            return null;
        }
        CreateRequest addReq = new CreateRequest();
        Point location = new Point(0, 0);
        if (this.getWorkbenchPart() != null) {
            IWorkbenchPart part = this.getWorkbenchPart();
            org.eclipse.swt.graphics.Point mouseLocation = part.getSite().getShell().getDisplay().getCursorLocation();
            if (part instanceof SmooksGraphicalEditorPart) {
                GraphicalViewer viewer = ((SmooksGraphicalEditorPart)part).getGraphicalViewer();
                mouseLocation = viewer.getControl().toControl(mouseLocation);
            }
            location = new Point(mouseLocation.x, mouseLocation.y);
        }
        addReq.setLocation(location);
        addReq.setFactory(this.getCreationFactory());
        CompoundCommand compoundCmd = new CompoundCommand("Add " + this.getActionText());
        int i = 0;
        while (i < objects.size()) {
            EditPart object = (EditPart)objects.get(i);
            Command cmd = object.getCommand((Request)addReq);
            if (cmd != null) {
                compoundCmd.add(cmd);
            }
            ++i;
        }
        return compoundCmd;
    }

    public abstract String getActionText();

    public void run() {
        try {
            this.execute(this.createAddChildNodeCommand(this.getSelectedObjects()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void init() {
        super.init();
        this.setText(this.getActionText());
        this.setImageDescriptor(this.getActionImageDescriptor());
    }

    protected abstract CreationFactory getCreationFactory();

    public abstract ImageDescriptor getActionImageDescriptor();

    public String getId() {
        return "add_chlid_" + this.getText();
    }
}

