/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.graphical.actions;

import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbenchPart;
import org.jboss.tools.smooks.editor.ISmooksModelProvider;
import org.jboss.tools.smooks.graphical.actions.AddSmooksModelAction;

public abstract class AddSmooksObjectAction
extends AddSmooksModelAction {
    private ISmooksModelProvider provider;

    public AddSmooksObjectAction(IWorkbenchPart part, int style, ISmooksModelProvider provider) {
        super(part, style);
        this.provider = provider;
        this.setText(this.getActionText());
        this.setImageDescriptor(this.getActionImageDescriptor());
    }

    public AddSmooksObjectAction(IWorkbenchPart part, ISmooksModelProvider provider) {
        super(part);
        this.provider = provider;
        this.setText(this.getActionText());
        this.setImageDescriptor(this.getActionImageDescriptor());
    }

    protected void init() {
    }

    protected ISmooksModelProvider getProvider() {
        return this.provider;
    }

    public ImageDescriptor getActionImageDescriptor() {
        Object object = this.getNewObject();
        if (object == null) {
            return null;
        }
        object = AdapterFactoryEditingDomain.unwrap((Object)object);
        AdapterFactoryEditingDomain editDomain = (AdapterFactoryEditingDomain)this.provider.getEditingDomain();
        IItemLabelProvider itemLabelProvider = (IItemLabelProvider)editDomain.getAdapterFactory().adapt(object, IItemLabelProvider.class);
        ImageDescriptor smallImage = null;
        if (itemLabelProvider != null) {
            Object imageObj = itemLabelProvider.getImage(object);
            smallImage = ExtendedImageRegistry.getInstance().getImageDescriptor(imageObj);
        }
        return smallImage;
    }

    public String getActionText() {
        Object object = this.getNewObject();
        if (object == null) {
            return "";
        }
        object = AdapterFactoryEditingDomain.unwrap((Object)object);
        AdapterFactoryEditingDomain editDomain = (AdapterFactoryEditingDomain)this.provider.getEditingDomain();
        IItemLabelProvider itemLabelProvider = (IItemLabelProvider)editDomain.getAdapterFactory().adapt(object, IItemLabelProvider.class);
        if (itemLabelProvider != null) {
            return itemLabelProvider.getText(object);
        }
        return null;
    }

    protected CreationFactory getCreationFactory() {
        return new SmooksObjectCreationFactory(this.getNewObject(), this.getNewType());
    }

    protected abstract Object getSmooks12Object();

    protected abstract Object getSmooks12Type();

    protected Object getNewObject() {
        String version = this.getProvider().getPlatformVersion();
        if ("1.2".equals(version)) {
            return this.getSmooks12Object();
        }
        return null;
    }

    protected Object getNewType() {
        String version = this.getProvider().getPlatformVersion();
        if ("1.2".equals(version)) {
            return this.getSmooks12Type();
        }
        return null;
    }

    private class SmooksObjectCreationFactory
    implements CreationFactory {
        private Object newObject;
        private Object objectType;

        public SmooksObjectCreationFactory(Object newObject, Object objectType) {
            this.newObject = newObject;
            this.objectType = objectType;
        }

        public Object getNewObject() {
            return this.newObject;
        }

        public Object getObjectType() {
            return this.objectType;
        }
    }
}

