/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.graphical.actions;

import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.ui.IWorkbenchPart;
import org.jboss.tools.smooks.configuration.editors.uitls.SmooksUIUtils;
import org.jboss.tools.smooks.graphical.actions.Messages;
import org.jboss.tools.smooks.graphical.editors.SmooksGraphicalEditorPart;
import org.jboss.tools.smooks.graphical.editors.autolayout.IAutoLayout;

public class AutoLayoutAction
extends SelectionAction {
    public static final String ID = "_smooks_auto_layout";

    public AutoLayoutAction(IWorkbenchPart part, int style) {
        super(part, style);
    }

    public AutoLayoutAction(IWorkbenchPart part) {
        super(part);
    }

    protected void init() {
        super.init();
        this.setText(Messages.AutoLayoutAction_Action_Text);
    }

    protected boolean calculateEnabled() {
        IWorkbenchPart part = this.getWorkbenchPart();
        if (part instanceof SmooksGraphicalEditorPart) {
            IAutoLayout layout = ((SmooksGraphicalEditorPart)part).getAutoLayout();
            return layout != null;
        }
        return false;
    }

    public void run() {
        IWorkbenchPart part = this.getWorkbenchPart();
        if (part instanceof SmooksGraphicalEditorPart) {
            ((SmooksGraphicalEditorPart)part).autoLayout(true);
        }
    }

    private void copySmooksFile(File file, IContainer parent) {
        if (file.exists()) {
            IFolder container;
            IFile ifile;
            if (file.isFile() && (ifile = parent.getFile((IPath)new Path(file.getName()))).exists() && SmooksUIUtils.isSmooksFile(ifile)) {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("validation-test");
                IFolder folder = project.getFolder("src");
                IFile newFile = folder.getFile(String.valueOf(parent.getName()) + "_" + ifile.getName());
                try {
                    if (newFile.exists()) {
                        newFile.setContents(ifile.getContents(), true, false, null);
                    } else {
                        newFile.create(ifile.getContents(), true, null);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (file.isDirectory() && (container = parent.getFolder((IPath)new Path(file.getName()))).exists()) {
                File[] files = file.listFiles();
                int i = 0;
                while (i < files.length) {
                    File file2 = files[i];
                    this.copySmooksFile(file2, (IContainer)container);
                    ++i;
                }
            }
        }
    }
}

