/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.graphical.editors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.jboss.tools.smooks.configuration.editors.IXMLStructuredObject;
import org.jboss.tools.smooks.configuration.editors.uitls.SmooksUIUtils;
import org.jboss.tools.smooks.configuration.editors.xml.TagObject;
import org.jboss.tools.smooks.configuration.editors.xml.TagPropertyObject;
import org.jboss.tools.smooks.configuration.editors.xml.XSLTagObject;
import org.jboss.tools.smooks.gef.common.RootModel;
import org.jboss.tools.smooks.gef.model.AbstractSmooksGraphicalModel;
import org.jboss.tools.smooks.gef.tree.model.BeanReferenceConnection;
import org.jboss.tools.smooks.gef.tree.model.TreeNodeConnection;
import org.jboss.tools.smooks.gef.tree.model.TriggerConnection;
import org.jboss.tools.smooks.gef.tree.model.ValueBindingConnection;
import org.jboss.tools.smooks.graphical.editors.ConnectionModelFactory;
import org.jboss.tools.smooks.graphical.editors.editparts.SmooksGraphUtil;
import org.jboss.tools.smooks.graphical.editors.model.javamapping.JavaBeanChildGraphModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionModelFactoryImpl
implements ConnectionModelFactory {
    public Collection<TreeNodeConnection> createBeanIDReferenceConnection(EObject rootModel, RootModel root, AbstractSmooksGraphicalModel model) {
        BeanReferenceConnection connection;
        boolean createNewConnection;
        Object data;
        Object mm = model.getData();
        if ((mm = AdapterFactoryEditingDomain.unwrap((Object)mm)) == null || !(mm instanceof EObject)) {
            return null;
        }
        EObject cmodel = (EObject)mm;
        EStructuralFeature beanIDRefFeature = SmooksUIUtils.getBeanIDRefFeature(cmodel);
        EStructuralFeature beanIDFeature = SmooksUIUtils.getBeanIDFeature(cmodel);
        ArrayList<TreeNodeConnection> connections = new ArrayList<TreeNodeConnection>();
        if (beanIDRefFeature != null && (data = cmodel.eGet(beanIDRefFeature)) != null) {
            String refID = data.toString();
            Collection<EObject> modelList = SmooksUIUtils.getBeanIdModelList(rootModel);
            for (EObject eObject : modelList) {
                AbstractSmooksGraphicalModel targetGraphModel;
                Object iddata;
                EStructuralFeature idfeature = SmooksUIUtils.getBeanIDFeature(eObject);
                if (idfeature == null || (iddata = eObject.eGet(idfeature)) == null || !refID.equals(iddata) || (targetGraphModel = SmooksGraphUtil.findSmooksGraphModel(root, eObject)) == null) continue;
                List<TreeNodeConnection> tcs = targetGraphModel.getTargetConnections();
                createNewConnection = true;
                for (TreeNodeConnection treeNodeConnection : tcs) {
                    if (treeNodeConnection.getSourceNode() != model) continue;
                    createNewConnection = false;
                    break;
                }
                if (!createNewConnection) continue;
                AbstractSmooksGraphicalModel target = SmooksGraphUtil.findSmooksGraphModel(root, eObject);
                connection = new BeanReferenceConnection(model, target);
                model.getSourceConnections().add(connection);
                model.fireConnectionChanged();
                target.getTargetConnections().add(connection);
                target.fireConnectionChanged();
                connections.add(connection);
            }
        }
        if (beanIDFeature != null && (data = cmodel.eGet(beanIDFeature)) != null) {
            String beanid = data.toString();
            Collection<EObject> beanIdRefModelList = SmooksUIUtils.getBeanIdRefModelList(rootModel);
            for (EObject eObject : beanIdRefModelList) {
                Object idRefData;
                EStructuralFeature idRefFeature = SmooksUIUtils.getBeanIDRefFeature(eObject);
                if (idRefFeature == null || (idRefData = eObject.eGet(idRefFeature)) == null || !beanid.equals(idRefData)) continue;
                AbstractSmooksGraphicalModel sourceGraphModel = SmooksGraphUtil.findSmooksGraphModel(root, eObject);
                List<TreeNodeConnection> scs = sourceGraphModel.getSourceConnections();
                createNewConnection = true;
                for (TreeNodeConnection treeNodeConnection : scs) {
                    if (treeNodeConnection.getTargetNode() != model) continue;
                    createNewConnection = false;
                    break;
                }
                if (!createNewConnection) continue;
                AbstractSmooksGraphicalModel source = SmooksGraphUtil.findSmooksGraphModel(root, eObject);
                connection = new BeanReferenceConnection(source, model);
                source.getSourceConnections().add(connection);
                model.getTargetConnections().add(connection);
                source.fireConnectionChanged();
                model.fireConnectionChanged();
                connections.add(connection);
            }
        }
        if (connections.isEmpty()) {
            return null;
        }
        return connections;
    }

    public boolean hasBeanIDConnection(AbstractSmooksGraphicalModel model) {
        Object data = model.getData();
        return (data = AdapterFactoryEditingDomain.unwrap((Object)data)) instanceof EObject && (SmooksUIUtils.getBeanIDRefFeature((EObject)data) == null || SmooksUIUtils.getBeanIDFeature((EObject)data) == null);
    }

    public boolean hasSelectorConnection(AbstractSmooksGraphicalModel model) {
        Object data = model.getData();
        if ((data = AdapterFactoryEditingDomain.unwrap((Object)data)) instanceof EObject) {
            return SmooksUIUtils.getSelectorFeature((EObject)data) != null;
        }
        return false;
    }

    public Collection<TreeNodeConnection> createSelectorConnection(List<Object> inputDataList, RootModel root, AbstractSmooksGraphicalModel model) {
        EStructuralFeature feature;
        Object sd;
        Object data = model.getData();
        data = AdapterFactoryEditingDomain.unwrap((Object)data);
        ArrayList<TreeNodeConnection> connections = new ArrayList<TreeNodeConnection>();
        if (data != null && data instanceof EObject && (sd = ((EObject)data).eGet(feature = SmooksUIUtils.getSelectorFeature((EObject)data))) != null) {
            String selector = sd.toString();
            if (inputDataList != null) {
                for (Object obj : inputDataList) {
                    AbstractSmooksGraphicalModel sourceGraphModel;
                    if (!(obj instanceof IXMLStructuredObject) || (sourceGraphModel = SmooksGraphUtil.findInputGraphModel(selector, (IXMLStructuredObject)obj, root)) == null) continue;
                    boolean canCreate = true;
                    List<TreeNodeConnection> tcs = model.getTargetConnections();
                    for (TreeNodeConnection treeNodeConnection : tcs) {
                        if (treeNodeConnection.getSourceNode() != sourceGraphModel) continue;
                        canCreate = false;
                    }
                    if (!canCreate) break;
                    TreeNodeConnection connection = null;
                    connection = model instanceof JavaBeanChildGraphModel ? new ValueBindingConnection(sourceGraphModel, model) : new TriggerConnection(sourceGraphModel, model);
                    sourceGraphModel.getSourceConnections().add(connection);
                    sourceGraphModel.fireConnectionChanged();
                    model.getTargetConnections().add(connection);
                    model.fireConnectionChanged();
                    connections.add(connection);
                }
            }
        }
        return connections;
    }

    private void fillSelectorConnection(List<Object> inputDataList, RootModel root, AbstractSmooksGraphicalModel model, String selector, List<TreeNodeConnection> connections) {
        if (inputDataList != null && selector != null) {
            for (Object obj : inputDataList) {
                AbstractSmooksGraphicalModel sourceGraphModel;
                if (!(obj instanceof IXMLStructuredObject) || (sourceGraphModel = SmooksGraphUtil.findInputGraphModel(selector, (IXMLStructuredObject)obj, root)) == null) continue;
                boolean canCreate = true;
                List<TreeNodeConnection> tcs = model.getTargetConnections();
                for (TreeNodeConnection treeNodeConnection : tcs) {
                    if (treeNodeConnection.getSourceNode() != sourceGraphModel) continue;
                    canCreate = false;
                }
                if (!canCreate) break;
                TreeNodeConnection connection = null;
                connection = new TreeNodeConnection(sourceGraphModel, model);
                sourceGraphModel.getSourceConnections().add(connection);
                sourceGraphModel.fireConnectionChanged();
                model.getTargetConnections().add(connection);
                model.fireConnectionChanged();
                connections.add(connection);
            }
        }
    }

    private String processSelectString(String select, String skm) {
        if (select != null) {
            if (select.startsWith(".")) {
                select = select.substring(1, select.length());
            }
            if (skm != null && select.indexOf(String.valueOf(skm) + ":") != -1) {
                select = select.replaceAll(String.valueOf(skm) + ":", "");
            }
        }
        return select;
    }

    public Collection<TreeNodeConnection> createXSLConnection(List<Object> inputDataList, RootModel root, AbstractSmooksGraphicalModel model) {
        TagPropertyObject tagPropertyObject;
        String value;
        ArrayList<TreeNodeConnection> connections = new ArrayList<TreeNodeConnection>();
        Object data = model.getData();
        if (data instanceof XSLTagObject) {
            String select;
            List<TagObject> list = ((XSLTagObject)data).getRelatedIgnoreXSLTagObjects();
            for (XSLTagObject xSLTagObject : list) {
                String select2 = null;
                if (xSLTagObject.isValueOfElement()) {
                    select2 = xSLTagObject.getSelectValue();
                }
                if (select2 == null) continue;
                select2 = select2.trim();
                select2 = this.processSelectString(select2, xSLTagObject.getSmooksPrix());
                this.fillSelectorConnection(inputDataList, root, model, select2, connections);
            }
            if (((XSLTagObject)data).isTemplateElement() && (select = ((XSLTagObject)data).getMatchValue()) != null) {
                select = select.trim();
                select = this.processSelectString(select, ((XSLTagObject)data).getSmooksPrix());
                this.fillSelectorConnection(inputDataList, root, model, select, connections);
            }
            if ((((XSLTagObject)data).isSortElement() || ((XSLTagObject)data).isForeachElement()) && (select = ((XSLTagObject)data).getSelectValue()) != null) {
                select = select.trim();
                select = this.processSelectString(select, ((XSLTagObject)data).getSmooksPrix());
                this.fillSelectorConnection(inputDataList, root, model, select, connections);
            }
        }
        if (data instanceof TagPropertyObject && (value = (tagPropertyObject = (TagPropertyObject)data).getValue()) != null && (value = value.trim()).startsWith("{") && value.endsWith("}")) {
            value = value.substring(1, value.length() - 1);
            this.fillSelectorConnection(inputDataList, root, model, value, connections);
        }
        return connections;
    }

    public boolean hasXSLConnection(AbstractSmooksGraphicalModel model) {
        Object data = model.getData();
        if (data instanceof XSLTagObject) {
            return true;
        }
        return data instanceof TagPropertyObject && ((TagPropertyObject)data).getParent() instanceof XSLTagObject;
    }

    @Override
    public Collection<TreeNodeConnection> createConnection(List<Object> inputDataList, EObject rootModel, RootModel root, AbstractSmooksGraphicalModel model) {
        ArrayList<TreeNodeConnection> allconnections = new ArrayList<TreeNodeConnection>();
        Collection<TreeNodeConnection> connections = this.createBeanIDReferenceConnection(rootModel, root, model);
        if (connections != null && !connections.isEmpty()) {
            allconnections.addAll(connections);
        }
        if ((connections = this.createSelectorConnection(inputDataList, root, model)) != null && !connections.isEmpty()) {
            allconnections.addAll(connections);
        }
        if ((connections = this.createXSLConnection(inputDataList, root, model)) != null && !connections.isEmpty()) {
            allconnections.addAll(connections);
        }
        return allconnections;
    }

    @Override
    public boolean hasConnection(AbstractSmooksGraphicalModel model) {
        return this.hasBeanIDConnection(model) || this.hasSelectorConnection(model) || this.hasXSLConnection(model);
    }
}

