/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.graphical.editors;

import java.util.List;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.ui.IEditorPart;
import org.jboss.tools.smooks.configuration.editors.actions.ISmooksActionGrouper;
import org.jboss.tools.smooks.configuration.editors.actions.JavaBean11ActionGrouper;
import org.jboss.tools.smooks.configuration.editors.uitls.SmooksUIUtils;
import org.jboss.tools.smooks.editor.ISmooksModelProvider;
import org.jboss.tools.smooks.gef.common.RootModel;
import org.jboss.tools.smooks.gef.model.AbstractSmooksGraphicalModel;
import org.jboss.tools.smooks.gef.tree.model.TreeNodeConnection;
import org.jboss.tools.smooks.graphical.editors.ConnectionModelFactory;
import org.jboss.tools.smooks.graphical.editors.ConnectionModelFactoryImpl;
import org.jboss.tools.smooks.graphical.editors.GraphicalModelFactory;
import org.jboss.tools.smooks.graphical.editors.GraphicalModelFactoryImpl;
import org.jboss.tools.smooks.graphical.editors.Messages;
import org.jboss.tools.smooks.graphical.editors.SmooksGraphicalEditorPaletteRootCreator;
import org.jboss.tools.smooks.graphical.editors.SmooksGraphicalEditorPart;
import org.jboss.tools.smooks.graphical.editors.autolayout.IAutoLayout;
import org.jboss.tools.smooks.graphical.editors.autolayout.JavaMappingAutoLayout;
import org.jboss.tools.smooks.graphical.editors.model.javamapping.JavaBeanGraphModel;
import org.jboss.tools.smooks.graphical.editors.model.javamapping.JavaMappingActionCreator;
import org.jboss.tools.smooks.model.javabean12.BeanType;
import org.jboss.tools.smooks.model.javabean12.ExpressionType;
import org.jboss.tools.smooks.model.javabean12.ValueType;
import org.jboss.tools.smooks.model.javabean12.WiringType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmooksJavaMappingGraphicalEditor
extends SmooksGraphicalEditorPart {
    private IAutoLayout javaMappingAutoLayout;

    public SmooksJavaMappingGraphicalEditor(ISmooksModelProvider provider) {
        super(provider);
    }

    @Override
    protected boolean needToLayoutWhenAddModel(Object model) {
        if ((model = AdapterFactoryEditingDomain.unwrap((Object)model)) instanceof BeanType) {
            return true;
        }
        return super.needToLayoutWhenAddModel(model);
    }

    @Override
    public void validateEnd(List<Diagnostic> diagnosticResult) {
        EditPart rootEditPart;
        Object rootModel;
        super.validateEnd(diagnosticResult);
        GraphicalViewer viewer = this.getGraphicalViewer();
        if (viewer != null && (rootModel = (rootEditPart = viewer.getContents()).getModel()) instanceof AbstractSmooksGraphicalModel) {
            this.validateConnection((AbstractSmooksGraphicalModel)rootModel);
        }
    }

    protected void validateConnection(AbstractSmooksGraphicalModel model) {
        List<TreeNodeConnection> targetConnections = model.getTargetConnections();
        if (targetConnections != null) {
            for (TreeNodeConnection connection : targetConnections) {
                Object target = connection.getTargetNode().getData();
                if (!((target = AdapterFactoryEditingDomain.unwrap((Object)target)) instanceof ValueType)) continue;
                ValueType value = (ValueType)target;
                String decoder = value.getDecoder();
                connection.getMessage().clear();
                boolean changed = false;
                String defaultDecoder = SmooksUIUtils.getDefualtDecoder(value);
                if (defaultDecoder == null) {
                    connection.setSeverity(0);
                    continue;
                }
                if (decoder != null && !decoder.equals(defaultDecoder)) {
                    connection.addMessage(String.valueOf(Messages.SmooksJavaMappingGraphicalEditor_WarningMessage1) + defaultDecoder + "'.");
                    connection.setSeverity(2);
                    changed = true;
                }
                if (changed) continue;
                connection.setSeverity(0);
            }
        }
        List<AbstractSmooksGraphicalModel> children = model.getChildrenWithoutDynamic();
        if (model instanceof RootModel) {
            children = model.getChildren();
        }
        for (AbstractSmooksGraphicalModel abstractSmooksGraphicalModel : children) {
            this.validateConnection(abstractSmooksGraphicalModel);
        }
    }

    @Override
    protected boolean needToLayoutWhenRemoveModel(Object model) {
        if ((model = AdapterFactoryEditingDomain.unwrap((Object)model)) instanceof BeanType) {
            return true;
        }
        return super.needToLayoutWhenRemoveModel(model);
    }

    @Override
    protected String getDiagnosticMessage(Diagnostic diagnostic) {
        return super.getDiagnosticMessage(diagnostic);
    }

    protected PaletteRoot getPaletteRoot() {
        SmooksGraphicalEditorPaletteRootCreator creator = new SmooksGraphicalEditorPaletteRootCreator(this.smooksModelProvider, (AdapterFactoryEditingDomain)this.smooksModelProvider.getEditingDomain(), this.getSmooksResourceListType()){

            @Override
            protected void fillActionGrouper(List<ISmooksActionGrouper> grouperList) {
                grouperList.add(new JavaBean11ActionGrouper());
            }
        };
        return creator.createPaletteRoot();
    }

    @Override
    public IAutoLayout getAutoLayout() {
        if (this.javaMappingAutoLayout == null) {
            this.javaMappingAutoLayout = new JavaMappingAutoLayout();
        }
        return this.javaMappingAutoLayout;
    }

    @Override
    protected ConnectionModelFactory createConnectionModelFactory() {
        return new JavaMappingConnectionModelFactory();
    }

    @Override
    protected GraphicalModelFactory createGraphicalModelFactory() {
        return new JavaMappingGraphicalModelFactory();
    }

    @Override
    protected void createActions() {
        super.createActions();
        JavaMappingActionCreator creator = new JavaMappingActionCreator();
        creator.registXSLActions(this.getActionRegistry(), this.getSelectionActions(), (IEditorPart)this, this.getSmooksModelProvider());
    }

    private class JavaMappingConnectionModelFactory
    extends ConnectionModelFactoryImpl {
        private JavaMappingConnectionModelFactory() {
        }

        public boolean hasXSLConnection(AbstractSmooksGraphicalModel model) {
            return false;
        }
    }

    private class JavaMappingGraphicalModelFactory
    extends GraphicalModelFactoryImpl {
        private JavaMappingGraphicalModelFactory() {
        }

        protected String getGraphLabelText(Object element) {
            Object obj = AdapterFactoryEditingDomain.unwrap((Object)element);
            if (obj instanceof BeanType) {
                String p = ((BeanType)obj).getBeanId();
                if (p == null) {
                    p = Messages.SmooksJavaMappingGraphicalEditor_NullLabel;
                }
                return p;
            }
            if (obj instanceof ValueType) {
                String p = ((ValueType)obj).getProperty();
                if (p == null) {
                    p = Messages.SmooksJavaMappingGraphicalEditor_NullLabel;
                }
                return p;
            }
            if (obj instanceof WiringType) {
                String p = ((WiringType)obj).getProperty();
                if (p == null) {
                    p = Messages.SmooksJavaMappingGraphicalEditor_NullLabel;
                }
                return p;
            }
            if (obj instanceof ExpressionType) {
                String p = ((ExpressionType)obj).getProperty();
                if (p == null) {
                    p = Messages.SmooksJavaMappingGraphicalEditor_NullLabel;
                }
                return p;
            }
            return null;
        }

        public Object createGraphicalModel(Object model, ISmooksModelProvider provider) {
            if (this.canCreateGraphicalModel(model, provider)) {
                JavaBeanGraphModel graphModel = null;
                AdapterFactoryEditingDomain editingDomain = (AdapterFactoryEditingDomain)provider.getEditingDomain();
                AdapterFactoryContentProvider contentProvider = new AdapterFactoryContentProvider(editingDomain.getAdapterFactory());
                ILabelProvider labelProvider = this.createLabelProvider(editingDomain.getAdapterFactory());
                if (model instanceof BeanType) {
                    graphModel = new JavaBeanGraphModel(model, (ITreeContentProvider)contentProvider, labelProvider, provider, SmooksJavaMappingGraphicalEditor.this);
                    graphModel.setHeaderVisable(true);
                }
                if (graphModel != null) {
                    return graphModel;
                }
                return super.createGraphicalModel(graphModel, provider);
            }
            return null;
        }
    }
}

