/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.graphical.editors;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.DeleteCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IMessage;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.ScrolledPageBook;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.zest.core.viewers.GraphViewer;
import org.eclipse.zest.core.widgets.CGraphNode;
import org.eclipse.zest.core.widgets.Graph;
import org.eclipse.zest.core.widgets.GraphItem;
import org.eclipse.zest.layouts.LayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.HorizontalTreeLayoutAlgorithm;
import org.jboss.tools.smooks.configuration.editors.GraphicsConstants;
import org.jboss.tools.smooks.configuration.editors.SelectorCreationDialog;
import org.jboss.tools.smooks.configuration.editors.SmooksReaderFormPage;
import org.jboss.tools.smooks.configuration.editors.input.InputType;
import org.jboss.tools.smooks.configuration.editors.uitls.SmooksUIUtils;
import org.jboss.tools.smooks.configuration.validate.ISmooksModelValidateListener;
import org.jboss.tools.smooks.editor.AbstractSmooksFormEditor;
import org.jboss.tools.smooks.editor.ISmooksModelProvider;
import org.jboss.tools.smooks.editor.ISourceSynchronizeListener;
import org.jboss.tools.smooks.gef.common.SmooksGraphicalMenuContextProvider;
import org.jboss.tools.smooks.graphical.actions.AbstractProcessGraphAction;
import org.jboss.tools.smooks.graphical.actions.AddNextTaskNodeAction;
import org.jboss.tools.smooks.graphical.actions.DeleteTaskNodeAction;
import org.jboss.tools.smooks.graphical.actions.ISmooksActionProvider;
import org.jboss.tools.smooks.graphical.editors.ISmooksEditorInitListener;
import org.jboss.tools.smooks.graphical.editors.ITaskNodeProvider;
import org.jboss.tools.smooks.graphical.editors.Messages;
import org.jboss.tools.smooks.graphical.editors.ProcessGraphContentProvider;
import org.jboss.tools.smooks.graphical.editors.SmooksGraphicalEditorPart;
import org.jboss.tools.smooks.graphical.editors.SmooksJavaMappingGraphicalEditor;
import org.jboss.tools.smooks.graphical.editors.SmooksMessage;
import org.jboss.tools.smooks.graphical.editors.SmooksTaskDetailsEditorSite;
import org.jboss.tools.smooks.graphical.editors.TaskTypeManager;
import org.jboss.tools.smooks.graphical.editors.process.IProcessProvider;
import org.jboss.tools.smooks.graphical.editors.process.ProcessFactory;
import org.jboss.tools.smooks.graphical.editors.process.ProcessGraphicalViewerLabelProvider;
import org.jboss.tools.smooks.graphical.editors.process.ProcessTaskAnalyzer;
import org.jboss.tools.smooks.graphical.editors.process.ProcessType;
import org.jboss.tools.smooks.graphical.editors.process.TaskNodeFigure;
import org.jboss.tools.smooks.graphical.editors.process.TaskType;
import org.jboss.tools.smooks.graphical.editors.process.TemplateAppyTaskNode;
import org.jboss.tools.smooks.graphical.editors.template.SmooksFreemarkerCSVTemplateGraphicalEditor;
import org.jboss.tools.smooks.graphical.editors.template.SmooksFreemarkerTemplateGraphicalEditor;
import org.jboss.tools.smooks.model.freemarker.Freemarker;
import org.jboss.tools.smooks.model.javabean12.BeanType;
import org.jboss.tools.smooks.model.smooks.AbstractResourceConfig;
import org.jboss.tools.smooks.model.smooks.DocumentRoot;
import org.jboss.tools.smooks.model.smooks.SmooksResourceListType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmooksProcessGraphicalEditor
extends FormPage
implements ISelectionChangedListener,
ISourceSynchronizeListener,
IPropertyListener,
ISmooksModelValidateListener,
IProcessProvider,
PropertyChangeListener,
ISmooksEditorInitListener,
ISmooksActionProvider {
    private boolean processMapActived = false;
    private int currentMessageType = 0;
    private String currentMessage = null;
    private boolean processChanged = false;
    private boolean lockProcessChangeEvent = false;
    private List<IAction> processPanelActions = new ArrayList<IAction>();
    public static final int EXECUTE_COMMAND = 0;
    public static final int REDO_COMMAND = 1;
    public static final int UNDO_COMMAND = 2;
    private Object emptyKey = new Object();
    private ISmooksModelProvider smooksModelProvider = null;
    private GraphViewer processGraphViewer;
    private ScrolledPageBook pageBook;
    private Map<String, Object> registedTaskPages = new HashMap<String, Object>();
    private MenuManager manager;
    protected boolean needupdatewhenshow = true;
    private ProcessType process;
    private Map<Object, String> smooksModelIdMap = new HashMap<Object, String>();

    public SmooksProcessGraphicalEditor(FormEditor editor, String id, String title, ISmooksModelProvider provider) {
        super(editor, id, title);
        this.smooksModelProvider = provider;
    }

    public SmooksProcessGraphicalEditor(String id, String title, ISmooksModelProvider provider) {
        super(id, title);
        this.smooksModelProvider = provider;
        this.getManagedForm();
    }

    @Override
    public ProcessType getProcess() {
        return this.process;
    }

    protected void createProcessGraphicalPanel(Composite parent) {
        this.processGraphViewer = new GraphViewer(parent, 0);
        this.processGraphViewer.getControl().dispose();
        this.processGraphViewer.setControl(new Graph(parent, 0){

            public void dispose() {
                try {
                    super.dispose();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        });
        this.processGraphViewer.setContentProvider((IContentProvider)new ProcessGraphContentProvider());
        this.processGraphViewer.setLabelProvider((IBaseLabelProvider)new ProcessGraphicalViewerLabelProvider(this));
        this.processGraphViewer.setConnectionStyle(2);
        HorizontalTreeLayoutAlgorithm layoutAlgorithm = new HorizontalTreeLayoutAlgorithm(1);
        this.processGraphViewer.setLayoutAlgorithm((LayoutAlgorithm)layoutAlgorithm, true);
        if (parent instanceof Section) {
            ((Section)parent).setClient(this.processGraphViewer.getControl());
        }
    }

    protected void initProcessGraphicalViewer() {
        boolean disableProcessViewer = false;
        if (this.process == null) {
            this.process = ProcessFactory.eINSTANCE.createProcessType();
            this.process.addPropertyChangeListener(this);
        }
        ProcessTaskAnalyzer analyzer = new ProcessTaskAnalyzer();
        this.lockProcessChangeEvent = true;
        analyzer.analyzeTaskNode(this.process, this.getSmooksResourceListType());
        this.lockProcessChangeEvent = false;
        if (this.getProcessGraphViewer() != null) {
            this.getProcessGraphViewer().setInput((Object)this.process);
        }
        if (disableProcessViewer) {
            this.getProcessGraphViewer().getControl().setBackground(this.getManagedForm().getToolkit().getColors().getBorderColor());
            this.getProcessGraphViewer().setInput(null);
            this.getProcessGraphViewer().getControl().setEnabled(false);
        }
    }

    protected void hookProcessGraphicalViewer() {
        this.getProcessGraphViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Object firstElement = selection.getFirstElement();
                if (firstElement == null) {
                    SmooksProcessGraphicalEditor.this.unhighlightGraphNodes();
                }
                Graph graph = SmooksProcessGraphicalEditor.this.getProcessGraphViewer().getGraphControl();
                List nodes = graph.getNodes();
                GraphItem item = null;
                for (GraphItem graphItem : nodes) {
                    if (graphItem.getData() != firstElement) continue;
                    item = graphItem;
                    break;
                }
                if (item != null) {
                    SmooksProcessGraphicalEditor.this.unhighlightGraphNodes();
                    SmooksProcessGraphicalEditor.this.highlightGraphNode(item);
                }
                SmooksProcessGraphicalEditor.this.showTaskControl(firstElement);
                SmooksProcessGraphicalEditor.this.selectionChanged(event);
                SmooksProcessGraphicalEditor.this.updateGlobalActions();
            }
        });
        this.getProcessGraphViewer().getControl().addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                SmooksProcessGraphicalEditor.this.processMapActived = false;
                SmooksProcessGraphicalEditor.this.updateGlobalActions();
            }

            public void focusGained(FocusEvent e) {
                SmooksProcessGraphicalEditor.this.processMapActived = true;
                SmooksProcessGraphicalEditor.this.updateGlobalActions();
            }
        });
    }

    private void updateGlobalActions() {
        IEditorActionBarContributor contributor = this.getEditorSite().getActionBarContributor();
        if (contributor != null && contributor instanceof MultiPageEditorActionBarContributor) {
            ((MultiPageEditorActionBarContributor)contributor).setActivePage(null);
            ((MultiPageEditorActionBarContributor)contributor).setActivePage((IEditorPart)this);
        }
    }

    protected void unhighlightGraphNodes() {
        Graph graph = this.getProcessGraphViewer().getGraphControl();
        List elements = graph.getNodes();
        for (GraphItem graphItem : elements) {
            this.unhighlightGraphNode(graphItem);
        }
    }

    protected void unhighlightGraphNode(GraphItem item) {
        IFigure figure;
        if (item instanceof CGraphNode && (figure = ((CGraphNode)item).getFigure()) instanceof TaskNodeFigure) {
            ((TaskNodeFigure)figure).unhighlightLabel();
        }
    }

    protected void highlightGraphNode(GraphItem item) {
        IFigure figure;
        if (item instanceof CGraphNode && (figure = ((CGraphNode)item).getFigure()) instanceof TaskNodeFigure) {
            ((TaskNodeFigure)figure).highlightLabel(ColorConstants.darkBlue);
        }
    }

    protected void configProcessGraphicalViewer() {
        this.manager = new MenuManager();
        this.initProcessGraphicalPanelActions((IMenuManager)this.manager);
        Menu menu = this.manager.createContextMenu(this.getProcessGraphViewer().getControl());
        this.getProcessGraphViewer().getControl().setMenu(menu);
        this.manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                try {
                    manager.removeAll();
                    if (SmooksProcessGraphicalEditor.this.needupdatewhenshow) {
                        SmooksProcessGraphicalEditor.this.updateProcessActions(SmooksProcessGraphicalEditor.this.processGraphViewer.getSelection());
                        SmooksProcessGraphicalEditor.this.fillProcessMenu(manager);
                    } else {
                        for (IAction action : SmooksProcessGraphicalEditor.this.processPanelActions) {
                            if (!action.isEnabled() || action instanceof DeleteTaskNodeAction) continue;
                            manager.add(action);
                        }
                    }
                    SmooksProcessGraphicalEditor.this.needupdatewhenshow = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                SmooksProcessGraphicalEditor.this.needupdatewhenshow = true;
            }
        });
    }

    public void fillProcessMenu(IMenuManager manager) {
        MenuManager addNextTaskMenuManager = new MenuManager(Messages.SmooksProcessGraphicalEditor_AddTaskActionText);
        manager.add((IContributionItem)addNextTaskMenuManager);
        for (IAction action : this.processPanelActions) {
            if (action instanceof DeleteTaskNodeAction) {
                manager.add(action);
                continue;
            }
            addNextTaskMenuManager.add(action);
        }
    }

    public boolean isNeedupdatewhenshow() {
        return this.needupdatewhenshow;
    }

    public void setNeedupdatewhenshow(boolean needupdatewhenshow) {
        this.needupdatewhenshow = needupdatewhenshow;
    }

    public void updateProcessActions(ISelection selection) {
        for (IAction a : this.processPanelActions) {
            if (!(a instanceof AbstractProcessGraphAction)) continue;
            ((AbstractProcessGraphAction)a).selectionChanged(new SelectionChangedEvent((ISelectionProvider)this.processGraphViewer, selection));
        }
        this.manager.update();
    }

    protected void initProcessGraphicalPanelActions(IMenuManager manager) {
        MenuManager addNextTaskMenuManager = new MenuManager(Messages.SmooksProcessGraphicalEditor_AddTaskActionText);
        manager.add((IContributionItem)addNextTaskMenuManager);
        this.generateNextTaskActions(addNextTaskMenuManager);
        DeleteTaskNodeAction deleteAction = new DeleteTaskNodeAction(this, this.smooksModelProvider, (IEditorPart)this);
        manager.add((IAction)deleteAction);
        this.processPanelActions.add((IAction)deleteAction);
    }

    private void generateNextTaskActions(MenuManager addNextTaskMenuManager) {
        List<TaskTypeManager.TaskTypeDescriptor> list = TaskTypeManager.getAllTaskList();
        for (TaskTypeManager.TaskTypeDescriptor taskTypeDescriptor : list) {
            AddNextTaskNodeAction addNextInputAction = new AddNextTaskNodeAction(taskTypeDescriptor.getId(), taskTypeDescriptor.getLabel(), this.smooksModelProvider, (IEditorPart)this);
            this.processPanelActions.add((IAction)addNextInputAction);
            addNextTaskMenuManager.add((IAction)addNextInputAction);
        }
    }

    public void registeTaskDetailsPage(IEditorPart editor, String taskID) {
        editor.addPropertyListener((IPropertyListener)this);
        this.registedTaskPages.put(taskID, editor);
    }

    public void removeTaskDetailsPage(IEditorPart editor, String taskID) {
        editor.removePropertyListener((IPropertyListener)this);
        this.registedTaskPages.remove(taskID);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.updateHeaderFormMessage();
    }

    public GraphViewer getProcessGraphViewer() {
        return this.processGraphViewer;
    }

    protected void createProcessGraphicalSection(FormToolkit toolkit, Composite parent) {
        Section processGraphSection = toolkit.createSection(parent, 256);
        processGraphSection.setText(Messages.SmooksProcessGraphicalEditor_TasksMapSectionTitle);
        Composite processGraphComposite = toolkit.createComposite((Composite)processGraphSection);
        GridLayout processGraphGridLayoutLayout = new GridLayout();
        processGraphComposite.setLayout((Layout)processGraphGridLayoutLayout);
        processGraphSection.setClient((Control)processGraphComposite);
        GridData gd = new GridData(768);
        Composite graphMainComposite = toolkit.createComposite(processGraphComposite);
        FillLayout l1 = new FillLayout();
        l1.marginHeight = 1;
        l1.marginWidth = 1;
        graphMainComposite.setLayout((Layout)l1);
        gd = new GridData(1808);
        graphMainComposite.setLayoutData((Object)gd);
        graphMainComposite.setBackground(toolkit.getColors().getBorderColor());
        this.createProcessGraphicalPanel(graphMainComposite);
        this.hookProcessGraphicalViewer();
        this.configProcessGraphicalViewer();
        this.initProcessGraphicalViewer();
    }

    protected void createTaskDetailsSection(FormToolkit toolkit, Composite parent) {
        Composite taskDetailsComposite = toolkit.createComposite(parent);
        FillLayout taskDetailsFillLayout = new FillLayout();
        taskDetailsFillLayout.marginWidth = 0;
        taskDetailsFillLayout.marginHeight = 5;
        taskDetailsComposite.setLayout((Layout)taskDetailsFillLayout);
        Section section = toolkit.createSection(taskDetailsComposite, 256);
        section.setText(Messages.SmooksProcessGraphicalEditor_TaskConfigurationSectionTitle);
        this.pageBook = new ScrolledPageBook((Composite)section);
        this.pageBook.setBackground(toolkit.getColors().getBackground());
        section.setClient((Control)this.pageBook);
        Composite emptyComposite = this.pageBook.createPage(this.emptyKey);
        emptyComposite.setLayout((Layout)new FillLayout());
        this.createEmptyTaskPanel(emptyComposite, toolkit);
        this.pageBook.showPage(this.emptyKey);
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        toolkit.decorateFormHeading(form.getForm());
        form.getBody().setLayout((Layout)new FillLayout());
        form.setText(Messages.SmooksProcessGraphicalEditor_FormText);
        Composite mainComposite = toolkit.createComposite(form.getBody());
        GridLayout mgl = new GridLayout();
        mgl.marginHeight = 13;
        mgl.horizontalSpacing = 20;
        mainComposite.setLayout((Layout)mgl);
        SashForm sashForm = new SashForm(mainComposite, 512);
        sashForm.SASH_WIDTH = 1;
        GridData gd = new GridData(1808);
        sashForm.setLayoutData((Object)gd);
        this.createProcessGraphicalSection(toolkit, (Composite)sashForm);
        this.createTaskDetailsSection(toolkit, (Composite)sashForm);
        sashForm.setWeights(new int[]{3, 7});
        this.validateEnd(null);
    }

    private void handleCommandStack(CommandStack commandStack) {
        commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(EventObject event) {
                final Command mostRecentCommand = ((CommandStack)event.getSource()).getMostRecentCommand();
                SmooksProcessGraphicalEditor.this.getEditorSite().getShell().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        block10: {
                            Collection activeModel;
                            Command rawCommand;
                            block11: {
                                if (mostRecentCommand == null) break block10;
                                rawCommand = mostRecentCommand;
                                while (rawCommand instanceof CommandWrapper) {
                                    rawCommand = ((CommandWrapper)rawCommand).getCommand();
                                }
                                activeModel = rawCommand.getAffectedObjects();
                                for (Object object : activeModel) {
                                    if (!(object instanceof TaskType) && !(object instanceof ProcessType)) continue;
                                    SmooksProcessGraphicalEditor.this.validateEnd(null);
                                    if (SmooksProcessGraphicalEditor.this.getProcessGraphViewer() == null) continue;
                                    SmooksProcessGraphicalEditor.this.getProcessGraphViewer().refresh();
                                    SmooksProcessGraphicalEditor.this.getProcessGraphViewer().applyLayout();
                                    break;
                                }
                                if (!(rawCommand instanceof CompoundCommand)) break block11;
                                List command = ((CompoundCommand)rawCommand).getCommandList();
                                block2: for (Command command2 : command) {
                                    Collection objs;
                                    while (command2 instanceof CommandWrapper) {
                                        command2 = ((CommandWrapper)command2).getCommand();
                                    }
                                    if (command2 instanceof DeleteCommand || command2 instanceof RemoveCommand) {
                                        objs = command2.getAffectedObjects();
                                        for (Object object : objs) {
                                            if (!((object = AdapterFactoryEditingDomain.unwrap(object)) instanceof TaskType) && !(object instanceof ProcessType)) continue;
                                            SmooksProcessGraphicalEditor.this.validateEnd(null);
                                            SmooksProcessGraphicalEditor.this.showTaskControl(null);
                                            break;
                                        }
                                    }
                                    if (!(command2 instanceof AddCommand) && !(command2 instanceof SetCommand)) continue;
                                    objs = command2.getAffectedObjects();
                                    for (Object object : objs) {
                                        if (!((object = AdapterFactoryEditingDomain.unwrap(object)) instanceof TaskType)) continue;
                                        SmooksProcessGraphicalEditor.this.validateEnd(null);
                                        SmooksProcessGraphicalEditor.this.showTaskControl((TaskType)object);
                                        continue block2;
                                    }
                                }
                                break block10;
                            }
                            if (rawCommand instanceof DeleteCommand || rawCommand instanceof RemoveCommand) {
                                activeModel = rawCommand.getAffectedObjects();
                                for (Object object : activeModel) {
                                    if (!((object = AdapterFactoryEditingDomain.unwrap(object)) instanceof TaskType) && !(object instanceof ProcessType) || SmooksProcessGraphicalEditor.this.getProcessGraphViewer() == null) continue;
                                    SmooksProcessGraphicalEditor.this.validateEnd(null);
                                    SmooksProcessGraphicalEditor.this.showTaskControl(null);
                                    break;
                                }
                            }
                            if (!(rawCommand instanceof AddCommand) && !(rawCommand instanceof SetCommand)) break block10;
                            Collection objs = rawCommand.getAffectedObjects();
                            for (Object object : objs) {
                                if (!((object = AdapterFactoryEditingDomain.unwrap(object)) instanceof TaskType)) continue;
                                SmooksProcessGraphicalEditor.this.validateEnd(null);
                                SmooksProcessGraphicalEditor.this.showTaskControl((TaskType)object);
                                break;
                            }
                        }
                    }
                });
            }
        });
    }

    public ISmooksModelProvider getSmooksModelProvider() {
        return this.smooksModelProvider;
    }

    public void setSmooksModelProvider(ISmooksModelProvider smooksModelProvider) {
        this.smooksModelProvider = smooksModelProvider;
    }

    public SmooksResourceListType getSmooksResourceList() {
        if (this.smooksModelProvider != null) {
            SmooksResourceListType m = null;
            EObject smooksModel = this.smooksModelProvider.getSmooksModel();
            if (smooksModel instanceof DocumentRoot) {
                m = ((DocumentRoot)smooksModel).getSmooksResourceList();
            }
            return m;
        }
        return null;
    }

    public EditingDomain getEditingDomain() {
        if (this.smooksModelProvider != null) {
            return this.smooksModelProvider.getEditingDomain();
        }
        return null;
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        if (this.smooksModelProvider != null) {
            this.handleCommandStack(this.smooksModelProvider.getEditingDomain().getCommandStack());
        }
        List<TaskTypeManager.TaskTypeDescriptor> tasks = TaskTypeManager.getAllTaskList();
        for (TaskTypeManager.TaskTypeDescriptor taskTypeDescriptor : tasks) {
            IEditorPart part = this.createEditorPart(taskTypeDescriptor.getId());
            if (part == null || !this.isSingltonEditor(taskTypeDescriptor.getId())) continue;
            this.registeTaskDetailsPage(part, taskTypeDescriptor.getId());
        }
    }

    protected SmooksResourceListType getSmooksResourceListType() {
        if (this.smooksModelProvider != null) {
            return SmooksUIUtils.getSmooks11ResourceListType(this.smooksModelProvider.getSmooksModel());
        }
        return null;
    }

    protected IEditorPart createEditorPart(Object taskID) {
        if (taskID instanceof TemplateAppyTaskNode) {
            String type = ((TemplateAppyTaskNode)taskID).getType();
            SmooksFreemarkerTemplateGraphicalEditor freemarkerPart = new SmooksFreemarkerCSVTemplateGraphicalEditor(this.smooksModelProvider);
            if ("CSV".equals(type)) {
                freemarkerPart = new SmooksFreemarkerCSVTemplateGraphicalEditor(this.smooksModelProvider);
            }
            if ("XML".equals(type)) {
                freemarkerPart = new SmooksFreemarkerTemplateGraphicalEditor(this.smooksModelProvider);
            }
            return freemarkerPart;
        }
        if (taskID.equals("freemarker_csv_template")) {
            SmooksFreemarkerCSVTemplateGraphicalEditor freemarkerPart = new SmooksFreemarkerCSVTemplateGraphicalEditor(this.smooksModelProvider);
            return freemarkerPart;
        }
        if (taskID.equals("java_mapping")) {
            SmooksJavaMappingGraphicalEditor javaMappingPart = new SmooksJavaMappingGraphicalEditor(this.smooksModelProvider);
            return javaMappingPart;
        }
        if (taskID.equals("input")) {
            SmooksReaderFormPage readerPage = new SmooksReaderFormPage(this.getEditor(), "input", "input");
            return readerPage;
        }
        return null;
    }

    protected boolean isSingltonEditor(Object taskID) {
        return !taskID.equals("freemarker_csv_template");
    }

    public Object getAdapter(Class type) {
        if (type == ISmooksModelProvider.class) {
            return this.smooksModelProvider;
        }
        if (type == IProcessProvider.class) {
            return this;
        }
        return super.getAdapter(type);
    }

    public boolean isDirty() {
        boolean dirty = false;
        Collection<Object> editors = this.registedTaskPages.values();
        for (Object object : editors) {
            if (!(object instanceof IEditorPart)) continue;
            boolean bl = dirty = ((IEditorPart)object).isDirty() || dirty;
        }
        return dirty || this.processChanged;
    }

    public void doSave(IProgressMonitor monitor) {
        Collection<Object> editors = this.registedTaskPages.values();
        for (Object object : editors) {
            if (!(object instanceof IEditorPart)) continue;
            ((IEditorPart)object).doSave(monitor);
        }
        this.processChanged = false;
        this.firePropertyChange(257);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelectionProvider provider = this.getEditor().getSite().getSelectionProvider();
        if (provider != null) {
            provider.setSelection(event.getSelection());
        }
    }

    protected Control createTaskPanel(Composite parent, FormToolkit toolkit, String taskID) {
        return null;
    }

    protected String generateTaskSpecailID(TaskType task) {
        if (task instanceof TemplateAppyTaskNode && !((TemplateAppyTaskNode)task).getSmooksModel().isEmpty() && ((TemplateAppyTaskNode)task).getSmooksModel().size() == 1) {
            Object freemarker = ((TemplateAppyTaskNode)task).getSmooksModel().get(0);
            String taskID = this.smooksModelIdMap.get(freemarker);
            if (taskID == null) {
                String tempstamp = String.valueOf(System.currentTimeMillis());
                taskID = "freemarker_" + tempstamp;
                this.smooksModelIdMap.put(freemarker, taskID);
            }
            return taskID;
        }
        return null;
    }

    public Object getActiveEditorPage() {
        if (this.pageBook != null) {
            Control control = this.pageBook.getCurrentPage();
            return control.getData();
        }
        return null;
    }

    protected void showTaskControl(Object model) {
        if (this.pageBook == null) {
            return;
        }
        if (model == null) {
            this.pageBook.showEmptyPage();
        }
        final Object finalModel = model;
        this.pageBook.getShell().getDisplay().syncExec(new Runnable(){

            public void run() {
                FormToolkit toolkit = ((AbstractSmooksFormEditor)SmooksProcessGraphicalEditor.this.smooksModelProvider).getToolkit();
                if (finalModel instanceof TaskType) {
                    String id = ((TaskType)finalModel).getId();
                    if (!SmooksProcessGraphicalEditor.this.isSingltonEditor(id)) {
                        String idref = SmooksProcessGraphicalEditor.this.generateTaskSpecailID((TaskType)finalModel);
                        if (idref != null) {
                            if (SmooksProcessGraphicalEditor.this.getRegisteTaskPage(idref) == null) {
                                IEditorPart editor = SmooksProcessGraphicalEditor.this.createEditorPart(finalModel);
                                SmooksProcessGraphicalEditor.this.registeTaskDetailsPage(editor, idref);
                            }
                            id = idref;
                        } else {
                            id = String.valueOf(id) + "_unknown";
                        }
                    }
                    if (id != null) {
                        if (!SmooksProcessGraphicalEditor.this.pageBook.hasPage((Object)id)) {
                            Composite parent = SmooksProcessGraphicalEditor.this.pageBook.createPage((Object)id);
                            Object page = SmooksProcessGraphicalEditor.this.getRegisteTaskPage(id);
                            if (page != null && page instanceof IEditorPart) {
                                try {
                                    parent.setLayout((Layout)new FillLayout());
                                    ITaskNodeProvider nodeProvider = (ITaskNodeProvider)((IEditorPart)page).getAdapter(ITaskNodeProvider.class);
                                    if (nodeProvider != null) {
                                        nodeProvider.setTaskType((TaskType)finalModel);
                                    }
                                    SmooksProcessGraphicalEditor.this.createTaskPage((IEditorPart)page, parent);
                                    SmooksProcessGraphicalEditor.this.pageBook.showPage((Object)id);
                                    parent.setData(page);
                                }
                                catch (Throwable e) {
                                    e.printStackTrace();
                                    SmooksProcessGraphicalEditor.this.pageBook.removePage((Object)id);
                                    SmooksProcessGraphicalEditor.this.pageBook.showPage(SmooksProcessGraphicalEditor.this.emptyKey);
                                }
                            } else {
                                Control control = SmooksProcessGraphicalEditor.this.createTaskPanel(parent, toolkit, id);
                                if (control != null) {
                                    SmooksProcessGraphicalEditor.this.pageBook.showPage((Object)id);
                                } else {
                                    SmooksProcessGraphicalEditor.this.pageBook.removePage((Object)id);
                                    SmooksProcessGraphicalEditor.this.pageBook.showPage(SmooksProcessGraphicalEditor.this.emptyKey);
                                }
                            }
                        } else {
                            Object page = SmooksProcessGraphicalEditor.this.getRegisteTaskPage(id);
                            ITaskNodeProvider nodeProvider = (ITaskNodeProvider)((IEditorPart)page).getAdapter(ITaskNodeProvider.class);
                            if (nodeProvider != null) {
                                nodeProvider.setTaskType((TaskType)finalModel);
                            }
                            SmooksProcessGraphicalEditor.this.pageBook.showPage((Object)id);
                        }
                    }
                }
            }
        });
        this.updateGlobalActions();
    }

    protected IEditorSite createSite(IEditorPart editor) {
        return new SmooksTaskDetailsEditorSite((MultiPageEditorPart)this.getEditor(), editor, this);
    }

    protected void createTaskPage(IEditorPart editorPart, Composite parent) throws PartInitException {
        IEditorSite site = this.createSite(editorPart);
        editorPart.init(site, this.getEditorInput());
        editorPart.createPartControl(parent);
    }

    public Object getRegisteTaskPage(String id) {
        return this.registedTaskPages.get(id);
    }

    protected Control createEmptyTaskPanel(Composite parent, FormToolkit toolkit) {
        parent.setLayout((Layout)new FillLayout());
        return toolkit.createLabel(parent, "Select the task node");
    }

    @Override
    public void sourceChange(Object model) {
        List<TaskTypeManager.TaskTypeDescriptor> tasks;
        if (this.getProcessGraphViewer() != null) {
            this.initProcessGraphicalViewer();
        }
        Collection<Object> editors = this.registedTaskPages.values();
        for (Object object : editors) {
            if (!(object instanceof IEditorPart)) continue;
            ((IEditorPart)object).removePropertyListener((IPropertyListener)this);
            if (((IEditorPart)object).getEditorSite() == null) continue;
            ((IEditorPart)object).dispose();
        }
        this.registedTaskPages.clear();
        if (this.pageBook != null) {
            tasks = TaskTypeManager.getAllTaskList();
            for (TaskTypeManager.TaskTypeDescriptor taskTypeDescriptor : tasks) {
                this.pageBook.removePage((Object)taskTypeDescriptor.getId(), true);
            }
            for (String id : this.smooksModelIdMap.values()) {
                this.pageBook.removePage((Object)id, true);
            }
        }
        tasks = TaskTypeManager.getAllTaskList();
        for (TaskTypeManager.TaskTypeDescriptor taskTypeDescriptor : tasks) {
            IEditorPart part = this.createEditorPart(taskTypeDescriptor.getId());
            if (part == null) continue;
            this.registeTaskDetailsPage(part, taskTypeDescriptor.getId());
        }
    }

    public void propertyChanged(Object source, int propId) {
        this.firePropertyChange(propId);
        if (propId == 257) {
            this.getManagedForm().dirtyStateChanged();
        }
    }

    public void dispose() {
        Collection<Object> editors = this.registedTaskPages.values();
        for (Object object : editors) {
            if (!(object instanceof IEditorPart)) continue;
            ((IEditorPart)object).removePropertyListener((IPropertyListener)this);
            if (((IEditorPart)object).getEditorSite() == null) continue;
            ((IEditorPart)object).dispose();
        }
        this.registedTaskPages.clear();
        super.dispose();
    }

    @Override
    public void validateEnd(List<Diagnostic> diagnosticResult) {
        Collection<Object> editors = this.registedTaskPages.values();
        for (Object object : editors) {
            if (!(object instanceof ISmooksModelValidateListener)) continue;
            ((ISmooksModelValidateListener)object).validateEnd(diagnosticResult);
        }
        ProcessType process = this.getProcess();
        this.validateProcess(process);
    }

    @Override
    public void validateStart() {
        Collection<Object> editors = this.registedTaskPages.values();
        for (Object object : editors) {
            if (!(object instanceof ISmooksModelValidateListener)) continue;
            ((ISmooksModelValidateListener)object).validateStart();
        }
    }

    protected void validateProcess(ProcessType process) {
        if (process != null) {
            this.validateTasks(process.getTask());
            GraphViewer viewer = this.getProcessGraphViewer();
            if (viewer != null) {
                viewer.refresh();
            }
        }
    }

    protected void validateTasks(List<TaskType> tasks) {
        if (tasks == null) {
            return;
        }
        for (TaskType taskType : tasks) {
            this.validateTask(taskType);
            this.validateTasks(taskType.getTask());
        }
    }

    protected void validateTask(TaskType t) {
        if (t == null) {
            return;
        }
        TaskType task = t;
        task.setProblemType(0);
        task.cleanProblemMessages();
        String id = task.getId();
        if ("input".equals(id)) {
            List<InputType> inputLists = SmooksUIUtils.getInputTypeList(this.getSmooksResourceListType());
            if (inputLists == null || inputLists.isEmpty()) {
                task.setProblemType(2);
                task.addProblemMessage(Messages.SmooksProcessGraphicalEditor_Empty_Input_File);
            } else {
                boolean noactived = true;
                for (InputType inputType : inputLists) {
                    if (!inputType.isActived()) continue;
                    noactived = false;
                    break;
                }
                if (noactived) {
                    task.setProblemType(2);
                    task.addProblemMessage(Messages.SmooksProcessGraphicalEditor_No_Input_File_Active);
                } else {
                    List<Object> inputs = SelectorCreationDialog.generateInputData(this.getSmooksResourceListType());
                    if (inputs == null || inputs.size() == 0) {
                        task.setProblemType(1);
                        task.addProblemMessage(Messages.SmooksProcessGraphicalEditor_No_Input_Task_Found);
                    }
                }
            }
        }
        if ("java_mapping".equals(id)) {
            List<Object> inputs = SelectorCreationDialog.generateInputData(this.getSmooksResourceListType());
            if (inputs == null || inputs.size() == 0) {
                task.setProblemType(2);
                task.addProblemMessage(Messages.SmooksProcessGraphicalEditor_No_Input_Specified);
            }
            SmooksResourceListType sr = this.getSmooksResourceListType();
            EList rcs = sr.getAbstractResourceConfig();
            boolean correct = false;
            for (AbstractResourceConfig abstractResourceConfig : rcs) {
                if (!(abstractResourceConfig instanceof BeanType)) continue;
                correct = true;
                break;
            }
            if (!correct) {
                task.setProblemType(1);
                task.addProblemMessage(Messages.SmooksProcessGraphicalEditor_Java_Mapping_Not_Found);
            }
        }
        if ("freemarker_csv_template".equals(id)) {
            SmooksResourceListType sr = this.getSmooksResourceListType();
            EList rcs = sr.getAbstractResourceConfig();
            boolean correct = false;
            boolean multipleTemplate = false;
            int freemarkerCount = 0;
            for (AbstractResourceConfig abstractResourceConfig : rcs) {
                if (abstractResourceConfig instanceof BeanType) {
                    correct = true;
                }
                if (abstractResourceConfig instanceof Freemarker) {
                    ++freemarkerCount;
                }
                if (freemarkerCount > 1) {
                    multipleTemplate = true;
                }
                if (!correct && multipleTemplate) break;
            }
            if (!correct) {
                task.setProblemType(2);
                task.addProblemMessage(Messages.SmooksProcessGraphicalEditor_4);
            }
            if (multipleTemplate) {
                task.setProblemType(1);
                task.addProblemMessage(Messages.SmooksProcessGraphicalEditor_ValidationError_MultipleTemplate);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.lockProcessChangeEvent) {
            return;
        }
        String name = evt.getPropertyName();
        Object newtask = evt.getNewValue();
        Object oldtask = evt.getOldValue();
        if ("pro_add_child".equals(name) || "pro_remove_child".equals(name)) {
            if (this.getProcessGraphViewer() != null) {
                this.getProcessGraphViewer().refresh();
                this.getProcessGraphViewer().applyLayout();
            }
            this.processChanged = true;
            this.getManagedForm().dirtyStateChanged();
        }
        if ("pro_add_child".equals(name)) {
            this.showTaskControl(newtask);
        }
        if ("pro_remove_child".equals(name)) {
            this.showTaskControl(null);
            this.disposeTaskDetails(oldtask);
        }
        this.validateEnd(null);
    }

    private void disposeTaskDetails(Object deleteTask) {
        final Object finalModel = deleteTask;
        this.pageBook.getShell().getDisplay().syncExec(new Runnable(){

            public void run() {
                String idref;
                String id;
                if (finalModel instanceof TaskType && !SmooksProcessGraphicalEditor.this.isSingltonEditor(id = ((TaskType)finalModel).getId()) && (id = (idref = SmooksProcessGraphicalEditor.this.generateTaskSpecailID((TaskType)finalModel)) != null ? idref : String.valueOf(id) + "_unknown") != null && SmooksProcessGraphicalEditor.this.pageBook.hasPage((Object)id)) {
                    SmooksProcessGraphicalEditor.this.pageBook.removePage((Object)id);
                    Object registPage = SmooksProcessGraphicalEditor.this.getRegisteTaskPage(id);
                    SmooksProcessGraphicalEditor.this.removeTaskDetailsPage((IEditorPart)registPage, id);
                }
            }
        });
    }

    @Override
    public void initFailed(int messageType, String message) {
        this.currentMessage = message;
        this.currentMessageType = messageType;
        this.updateHeaderFormMessage();
    }

    protected void updateHeaderFormMessage() {
        if (this.getManagedForm() != null) {
            this.getManagedForm().getMessageManager().removeAllMessages();
            this.getManagedForm().getMessageManager().update();
            this.getProcessGraphViewer().getControl().setEnabled(true);
            this.getProcessGraphViewer().getControl().setBackground(this.getManagedForm().getToolkit().getColors().getBackground());
        }
        if (this.currentMessageType != 0 && this.currentMessage != null) {
            if (this.getProcessGraphViewer() != null) {
                this.getProcessGraphViewer().getControl().setBackground(GraphicsConstants.BORDER_CORLOR);
                this.getProcessGraphViewer().getControl().setEnabled(false);
                this.getProcessGraphViewer().setInput(new Object());
                this.showTaskControl(null);
            }
            if (this.getManagedForm() != null) {
                String[] messages = this.currentMessage.split("\n");
                ArrayList<SmooksMessage> messageList = new ArrayList<SmooksMessage>();
                int i = 0;
                while (i < messages.length) {
                    String message = messages[i];
                    if (message != null) {
                        message.trim();
                    }
                    if (message.length() != 0) {
                        messageList.add(new SmooksMessage(this.currentMessageType, message));
                    }
                    ++i;
                }
                String mainMessage = null;
                mainMessage = messageList.isEmpty() ? this.currentMessage : ((IMessage)messageList.get(0)).getMessage();
                this.getManagedForm().getForm().getForm().setMessage(mainMessage, this.currentMessageType, messageList.toArray(new IMessage[0]));
            }
        }
    }

    @Override
    public IAction getAction(String actionId) {
        if (this.processMapActived) {
            this.updateProcessActions(this.processGraphViewer.getSelection());
            if (ActionFactory.DELETE.getId().equals(actionId)) {
                for (IAction action : this.processPanelActions) {
                    if (!(action instanceof DeleteTaskNodeAction)) continue;
                    return action;
                }
            }
        } else {
            IEditorPart editor = (IEditorPart)this.getActiveEditorPage();
            if (editor != null && editor instanceof SmooksGraphicalEditorPart) {
                SmooksGraphicalMenuContextProvider provider = (SmooksGraphicalMenuContextProvider)((SmooksGraphicalEditorPart)editor).getContextMenuProvider();
                return provider.getActionRegistry().getAction((Object)actionId);
            }
        }
        return null;
    }
}

