/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.graphical.editors;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.jboss.tools.smooks.graphical.editors.Messages;
import org.jboss.tools.smooks.graphical.editors.process.TaskType;
import org.jboss.tools.smooks.graphical.editors.process.TemplateAppyTaskNode;
import org.jboss.tools.smooks.model.freemarker.Freemarker;
import org.jboss.tools.smooks.model.javabean12.BeanType;
import org.jboss.tools.smooks.model.smooks.AbstractResourceConfig;
import org.jboss.tools.smooks.model.smooks.SmooksResourceListType;
import org.jboss.tools.smooks.model.xsl.Xsl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskTypeManager {
    public static final String TASK_ID_INPUT = "input";
    public static final String TASK_ID_JAVA_MAPPING = "java_mapping";
    public static final String TASK_ID_XSL_TEMPLATE = "xsl_template";
    public static final String TASK_ID_FREEMARKER_CSV_TEMPLATE = "freemarker_csv_template";
    public static final String TASK_ID_FREEMARKER_XML_TEMPLATE = "freemarker_xml_template";
    private static List<TaskTypeDescriptor> allTaskList = null;

    public static String[] getChildTaskIDs(String parentId) {
        if (parentId == null) {
            return null;
        }
        if (parentId.equals(TASK_ID_INPUT)) {
            return new String[]{TASK_ID_JAVA_MAPPING};
        }
        if (parentId.equals(TASK_ID_JAVA_MAPPING)) {
            return new String[]{TASK_ID_FREEMARKER_CSV_TEMPLATE};
        }
        return null;
    }

    public static List<TaskTypeDescriptor> getAllTaskList() {
        if (allTaskList == null) {
            allTaskList = new ArrayList<TaskTypeDescriptor>();
            allTaskList.add(new TaskTypeDescriptor(TASK_ID_INPUT, Messages.TaskTypeManager_Input, "icons/full/obj32/input_task.jpg"));
            allTaskList.add(new TaskTypeDescriptor(TASK_ID_JAVA_MAPPING, Messages.TaskTypeManager_JavaMappingTaskLabel, "icons/full/obj32/java_mapping_task.jpg"));
            allTaskList.add(new TaskTypeDescriptor(TASK_ID_FREEMARKER_CSV_TEMPLATE, Messages.TaskTypeManager_ApplyTemplateTaskLabel, "icons/full/obj32/freemarker_task.jpg"));
        }
        return allTaskList;
    }

    public static List<Object> getAssociatedSmooksElementsType(TaskType taskType) {
        return null;
    }

    public static List<Object> getAssociatedSmooksElementsType(String taskID) {
        ArrayList<Object> elementsType = new ArrayList<Object>();
        if (taskID == null) {
            return null;
        }
        if (TASK_ID_JAVA_MAPPING.equals(taskID)) {
            elementsType.add(BeanType.class);
        }
        if (TASK_ID_FREEMARKER_CSV_TEMPLATE.equals(taskID)) {
            elementsType.add(Freemarker.class);
        }
        if (TASK_ID_XSL_TEMPLATE.equals(taskID)) {
            elementsType.add(Xsl.class);
        }
        return elementsType;
    }

    public static String getTaskLabel(TaskType task) {
        String taskId;
        if (task != null && (taskId = task.getId()) != null) {
            if (taskId.equals(TASK_ID_FREEMARKER_CSV_TEMPLATE)) {
                String messageType = "";
                if (task instanceof TemplateAppyTaskNode) {
                    messageType = ((TemplateAppyTaskNode)task).getType();
                }
                if (messageType == null) {
                    messageType = "";
                }
                if (messageType.length() > 0) {
                    return String.valueOf(Messages.TaskTypeManager_ApplyTemplateTaskLabel) + " (" + messageType + ")";
                }
                return Messages.TaskTypeManager_ApplyTemplateTaskLabel;
            }
            if (taskId.equals(TASK_ID_INPUT)) {
                return Messages.TaskTypeManager_InputTaskLabel;
            }
            if (taskId.equals(TASK_ID_JAVA_MAPPING)) {
                return Messages.TaskTypeManager_JavaMappingTaskLabel;
            }
            if (taskId.equals(TASK_ID_XSL_TEMPLATE)) {
                return Messages.TaskTypeManager_ApplyXSLTemplateTaskLabel;
            }
        }
        return "";
    }

    public static List<Object> getAssociatedSmooksElements(TaskType taskType, SmooksResourceListType smooksResourceList) {
        List<Object> elementTypes = TaskTypeManager.getAssociatedSmooksElementsType(taskType.getId());
        EList resourceConfigList = smooksResourceList.getAbstractResourceConfig();
        ArrayList<Object> associatedElements = new ArrayList<Object>();
        for (AbstractResourceConfig abstractResourceConfig : resourceConfigList) {
            if (!TaskTypeManager.isSameType(abstractResourceConfig, elementTypes) || !TaskTypeManager.canRemove(abstractResourceConfig, taskType)) continue;
            associatedElements.add(abstractResourceConfig);
        }
        return associatedElements;
    }

    private static boolean canRemove(AbstractResourceConfig abstractResourceConfig, TaskType taskType) {
        if (abstractResourceConfig instanceof Freemarker) {
            return taskType.inTheTask(abstractResourceConfig);
        }
        return true;
    }

    private static boolean isSameType(Object element, List<Object> elementTypes) {
        for (Class clazz : elementTypes) {
            if (!clazz.isInstance(element)) continue;
            return true;
        }
        return false;
    }

    public static final class TaskTypeDescriptor {
        private String id;
        private String label;
        private String imagePath;

        public TaskTypeDescriptor(String id, String label, String imagePath) {
            this.id = id;
            this.label = label;
            this.imagePath = imagePath;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getImagePath() {
            return this.imagePath;
        }

        public void setImagePath(String imagePath) {
            this.imagePath = imagePath;
        }
    }
}

