/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.graphical.editors.commands;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.jboss.tools.smooks.gef.model.AbstractSmooksGraphicalModel;
import org.jboss.tools.smooks.gef.tree.model.TreeNodeConnection;

public class DeleteSmooksGraphicalModelCommand
extends Command {
    private AbstractSmooksGraphicalModel graphModel;
    private AbstractSmooksGraphicalModel parentModel;
    private List<TreeNodeConnection> deletedConnections = new ArrayList<TreeNodeConnection>();
    private int oldIndex = -1;

    public DeleteSmooksGraphicalModelCommand(AbstractSmooksGraphicalModel graphModel) {
        this.graphModel = graphModel;
        this.parentModel = graphModel.getParent();
    }

    public boolean canExecute() {
        return this.graphModel != null && this.parentModel != null;
    }

    public void execute() {
        if (this.deletedConnections != null) {
            this.deletedConnections.clear();
        } else {
            this.deletedConnections = new ArrayList<TreeNodeConnection>();
        }
        this.oldIndex = this.parentModel.getChildrenWithoutDynamic().indexOf(this.graphModel);
        AbstractSmooksGraphicalModel.disconnectAllConnectionsWithEvent(this.graphModel, this.deletedConnections);
        this.parentModel.removeChild(this.graphModel);
    }

    public void redo() {
        super.redo();
    }

    public void undo() {
        if (this.oldIndex != -1 && this.parentModel != null) {
            this.parentModel.addChild(this.oldIndex, this.graphModel);
            this.reconnectAllConnections();
        }
        super.undo();
    }

    private void reconnectAllConnections() {
        if (this.deletedConnections != null) {
            for (TreeNodeConnection connection : this.deletedConnections) {
                connection.connect();
            }
        }
    }
}

