/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.graphical.editors.editparts.freemarker;

import java.util.ArrayList;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;
import org.jboss.tools.smooks.graphical.editors.autolayout.IAutoLayout;
import org.jboss.tools.smooks.graphical.editors.editparts.freemarker.FreemarkerTemplateEditPart;
import org.jboss.tools.smooks.graphical.editors.editparts.javamapping.JavaBeanEditPart;

public class FreemarkerAutoLayout
implements IAutoLayout {
    private int INPUT_JAVA_WIDTH = 200;
    private int SPACE_XSL = 20;
    private int INIT_X = 200;
    private int INIT_Y = 80;

    public void visit(DirectedGraph graph) {
        NodeList nodeList = graph.nodes;
        int javaHeight = 0;
        int javaWidth = 0;
        Node inputNode = null;
        int java_y = this.INIT_Y;
        ArrayList<Node> javaNodes = new ArrayList<Node>();
        for (Node node : nodeList) {
            Object data = node.data;
            if (data instanceof JavaBeanEditPart) {
                javaHeight = javaHeight + this.SPACE_XSL + node.height;
                javaWidth = Math.max(javaWidth, node.width);
                node.y = java_y;
                java_y = java_y + this.SPACE_XSL + node.height;
                javaNodes.add(node);
            }
            if (!(data instanceof FreemarkerTemplateEditPart)) continue;
            inputNode = node;
        }
        javaHeight -= this.INIT_Y;
        int java_x = this.INIT_X;
        if (inputNode != null) {
            inputNode.x = this.INIT_X;
            java_x = this.INIT_X;
            int input_y = this.INIT_Y;
            if (javaHeight > inputNode.height) {
                int cha;
                input_y = cha = (javaHeight - inputNode.height) / 2;
            }
            inputNode.y = input_y;
            inputNode.x = java_x + javaWidth + this.INPUT_JAVA_WIDTH;
        }
        for (Node node : javaNodes) {
            node.x = java_x;
        }
    }
}

