/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.graphical.editors.editparts.freemarker;

import java.beans.PropertyChangeEvent;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.jboss.tools.smooks.gef.model.AbstractSmooksGraphicalModel;
import org.jboss.tools.smooks.gef.tree.editparts.TreeNodeEditPart;
import org.jboss.tools.smooks.gef.tree.figures.TreeNodeFigure;
import org.jboss.tools.smooks.graphical.editors.model.freemarker.FreemarkerTemplateGraphicalModel;
import org.jboss.tools.smooks.graphical.editors.model.freemarker.IFreemarkerTemplateModel;
import org.jboss.tools.smooks.templating.template.TemplateBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FreemarkerXMLNodeEditPart
extends TreeNodeEditPart {
    private Font hiddenLabelFont;
    private Font oldFont;
    private Color oldColor;

    @Override
    public void deactivate() {
        super.deactivate();
        if (this.hiddenLabelFont != null) {
            this.hiddenLabelFont.dispose();
        }
    }

    public Font getHiddenLabelFont() {
        if (this.hiddenLabelFont == null) {
            FontData[] fds;
            IFigure figure = this.getFigure();
            FontData fd = new FontData();
            fd.setStyle(2);
            if (figure != null && (fds = figure.getFont().getFontData()) != null && fds.length > 0) {
                fd.setHeight(fds[0].getHeight());
                fd.setName(fds[0].getName());
                fd.setLocale(fds[0].getLocale());
            }
            this.hiddenLabelFont = new Font(null, fd);
        }
        return this.hiddenLabelFont;
    }

    @Override
    protected boolean canDirectEdit() {
        return super.canDirectEdit();
    }

    @Override
    protected boolean isDragLink() {
        return super.isDragLink();
    }

    @Override
    protected void refreshVisuals() {
        AbstractSmooksGraphicalModel model = (AbstractSmooksGraphicalModel)this.getModel();
        TreeNodeFigure figure = (TreeNodeFigure)this.getFigure();
        Object data = model.getData();
        if (this.oldFont != null && this.oldColor != null) {
            figure.getLabel().setFont(this.oldFont);
            figure.setNodeLabelForegroundColor(this.oldColor);
        }
        super.refreshVisuals();
        if (data instanceof IFreemarkerTemplateModel) {
            AbstractSmooksGraphicalModel pm = model;
            while (pm != null && !(pm instanceof FreemarkerTemplateGraphicalModel)) {
                pm = pm.getParent();
            }
            TemplateBuilder builder = ((FreemarkerTemplateGraphicalModel)pm).getTemplateBuilder();
            if (((IFreemarkerTemplateModel)data).isHidden(builder)) {
                if (this.oldFont == null) {
                    this.oldFont = figure.getLabel().getFont();
                }
                if (this.oldColor == null) {
                    this.oldColor = figure.getLabel().getForegroundColor();
                }
                figure.setNodeLabelForegroundColor(ColorConstants.lightGray);
                figure.getLabel().repaint();
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        String proName = evt.getPropertyName();
        if ("_pro_add_source_connected".equals(proName) || "_pro_add_target_connected".equals(proName) || "_pro_remove_source_connected".equals(proName) || "_pro_remove_target_connected".equals(proName)) {
            AbstractSmooksGraphicalModel pm = (AbstractSmooksGraphicalModel)this.getModel();
            while (pm != null && !(pm instanceof FreemarkerTemplateGraphicalModel)) {
                pm = pm.getParent();
            }
            if (pm != null && pm instanceof FreemarkerTemplateGraphicalModel) {
                List<AbstractSmooksGraphicalModel> children = pm.getChildrenWithoutDynamic();
                this.refreshAllChildren(children);
            }
        }
    }

    private void refreshAllChildren(List<AbstractSmooksGraphicalModel> children) {
        for (AbstractSmooksGraphicalModel abstractSmooksGraphicalModel : children) {
            abstractSmooksGraphicalModel.fireVisualChanged();
            this.refreshAllChildren(abstractSmooksGraphicalModel.getChildrenWithoutDynamic());
        }
    }
}

