/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.graphical.editors.model.freemarker;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.jboss.tools.smooks.configuration.editors.IXMLStructuredObject;
import org.jboss.tools.smooks.gef.model.AbstractSmooksGraphicalModel;
import org.jboss.tools.smooks.gef.tree.model.TreeNodeConnection;
import org.jboss.tools.smooks.graphical.editors.model.freemarker.CSVNodeModel;
import org.jboss.tools.smooks.graphical.editors.model.freemarker.FreemarkerCSVNodeGraphicalModel;
import org.jboss.tools.smooks.graphical.editors.model.freemarker.FreemarkerTemplateGraphicalModel;
import org.jboss.tools.smooks.graphical.editors.model.javamapping.JavaBeanChildGraphModel;
import org.jboss.tools.smooks.graphical.editors.model.javamapping.JavaBeanGraphModel;
import org.jboss.tools.smooks.model.freemarker.Freemarker;
import org.jboss.tools.smooks.model.javabean12.BeanType;
import org.jboss.tools.smooks.model.javabean12.ValueType;
import org.jboss.tools.smooks.model.javabean12.WiringType;
import org.jboss.tools.smooks.templating.model.ModelBuilder;
import org.jboss.tools.smooks.templating.model.ModelBuilderException;
import org.jboss.tools.smooks.templating.model.csv.CSVModelBuilder;
import org.jboss.tools.smooks.templating.template.csv.CSVFreeMarkerTemplateBuilder;
import org.jboss.tools.smooks.templating.template.exception.InvalidMappingException;
import org.jboss.tools.smooks.templating.template.exception.TemplateBuilderException;
import org.jboss.tools.smooks10.model.smooks.util.SmooksModelUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FreemarkerCSVContentGenerator {
    public String generateCSVContents(FreemarkerCSVNodeGraphicalModel csvRecordGraphicalModel) throws TemplateBuilderException, ModelBuilderException {
        TreeNodeConnection recordConnection;
        AbstractSmooksGraphicalModel sourceGraphModel;
        String collectionName = null;
        List<TreeNodeConnection> recordConnections = csvRecordGraphicalModel.getTargetConnections();
        if (recordConnections.size() > 1 || recordConnections.isEmpty()) {
            return null;
        }
        TreeNodeConnection recordRootConnection = recordConnections.get(0);
        AbstractSmooksGraphicalModel javabeanModel = recordRootConnection.getSourceNode();
        List<AbstractSmooksGraphicalModel> javabeanChildren = javabeanModel.getChildrenWithoutDynamic();
        for (AbstractSmooksGraphicalModel abstractSmooksGraphicalModel : javabeanChildren) {
            Object javabean = abstractSmooksGraphicalModel.getData();
            if (!((javabean = AdapterFactoryEditingDomain.unwrap((Object)javabean)) instanceof WiringType)) continue;
            collectionName = ((WiringType)javabean).getBeanIdRef();
        }
        if (collectionName == null) {
            return null;
        }
        AbstractSmooksGraphicalModel freemarkerTemplateGraphmodel = csvRecordGraphicalModel.getParent();
        if (!(freemarkerTemplateGraphmodel instanceof FreemarkerTemplateGraphicalModel)) {
            return null;
        }
        Object freemarker = ((FreemarkerTemplateGraphicalModel)freemarkerTemplateGraphmodel).getData();
        if (!((freemarker = AdapterFactoryEditingDomain.unwrap((Object)freemarker)) instanceof Freemarker)) {
            return null;
        }
        char sperator = SmooksModelUtils.getFreemarkerCSVSeperator((Freemarker)((Freemarker)freemarker));
        char quote = SmooksModelUtils.getFreemarkerCSVQuote((Freemarker)((Freemarker)freemarker));
        boolean includeFieldNames = SmooksModelUtils.getFreemarkerCSVIncludeFieldNames((Freemarker)((Freemarker)freemarker));
        List<AbstractSmooksGraphicalModel> childrenGraphModel = csvRecordGraphicalModel.getChildren();
        ArrayList<String> fieldsName = new ArrayList<String>();
        for (AbstractSmooksGraphicalModel abstractSmooksGraphicalModel : childrenGraphModel) {
            Object cd = abstractSmooksGraphicalModel.getData();
            if (!((cd = AdapterFactoryEditingDomain.unwrap((Object)cd)) instanceof IXMLStructuredObject)) continue;
            fieldsName.add(((IXMLStructuredObject)cd).getNodeName());
        }
        CSVModelBuilder modelBuilder = new CSVModelBuilder(fieldsName.toArray(new String[0]));
        CSVFreeMarkerTemplateBuilder builder = new CSVFreeMarkerTemplateBuilder((ModelBuilder)modelBuilder, sperator, quote, includeFieldNames);
        Document model = builder.getModel();
        List<TreeNodeConnection> connections = csvRecordGraphicalModel.getTargetConnections();
        if (!connections.isEmpty() && connections.size() == 1 && (sourceGraphModel = (recordConnection = connections.get(0)).getSourceNode()) instanceof JavaBeanGraphModel) {
            Object data = ((JavaBeanGraphModel)sourceGraphModel).getData();
            data = AdapterFactoryEditingDomain.unwrap((Object)data);
            String beanName = null;
            if (data instanceof BeanType) {
                beanName = ((BeanType)data).getBeanId();
            }
            if (beanName != null) {
                builder.addCollectionMapping(beanName, this.getRecordElement(model), collectionName);
            }
            List<AbstractSmooksGraphicalModel> graphChildren = csvRecordGraphicalModel.getChildren();
            for (AbstractSmooksGraphicalModel abstractSmooksGraphicalModel : graphChildren) {
                this.addValueMapping(builder, (FreemarkerCSVNodeGraphicalModel)abstractSmooksGraphicalModel, model, collectionName, (JavaBeanGraphModel)sourceGraphModel);
            }
        }
        return builder.buildTemplate();
    }

    protected void addValueMapping(CSVFreeMarkerTemplateBuilder builder, FreemarkerCSVNodeGraphicalModel filedNode, Document model, String recordName, JavaBeanGraphModel recordRootNode) throws InvalidMappingException {
        CSVNodeModel csvFieldNode = (CSVNodeModel)filedNode.getData();
        String elementName = csvFieldNode.getName();
        List<TreeNodeConnection> connections = filedNode.getTargetConnections();
        if (!connections.isEmpty() && connections.size() == 1) {
            TreeNodeConnection recordConnection = connections.get(0);
            AbstractSmooksGraphicalModel sourceGraphModel = recordConnection.getSourceNode();
            String mappingString = FreemarkerCSVContentGenerator.generateJavaSourcePathWithoutRootNode(sourceGraphModel, recordRootNode);
            if (mappingString == null || mappingString.length() == 0) {
                return;
            }
            builder.addValueMapping(mappingString, (Node)this.getFieldElement(model, elementName));
        }
    }

    public static String generateFullJavaSourcePathString(AbstractSmooksGraphicalModel sourceGraphModel, JavaBeanGraphModel recordRootNode) {
        AbstractSmooksGraphicalModel parentModel = sourceGraphModel;
        Object sourceModel = sourceGraphModel.getData();
        sourceModel = AdapterFactoryEditingDomain.unwrap((Object)sourceModel);
        String s = null;
        if (sourceModel instanceof ValueType) {
            s = ((ValueType)sourceModel).getProperty();
        }
        ArrayList<Object> nodesList = new ArrayList<Object>();
        FreemarkerCSVContentGenerator.fillParentList(nodesList, parentModel, recordRootNode);
        String mappingString = "";
        int i = 0;
        while (i < nodesList.size()) {
            Object node = nodesList.get(i);
            String beanName = null;
            if (node instanceof BeanType) {
                beanName = ((BeanType)node).getBeanId();
            }
            if (beanName != null) {
                mappingString = String.valueOf(mappingString) + beanName + ".";
            }
            ++i;
        }
        if (s != null) {
            mappingString = String.valueOf(mappingString) + s;
        }
        return mappingString;
    }

    public static String generateJavaSourcePathWithoutRootNode(AbstractSmooksGraphicalModel sourceGraphModel, JavaBeanGraphModel recordRootNode) {
        AbstractSmooksGraphicalModel parentModel = sourceGraphModel;
        Object sourceModel = sourceGraphModel.getData();
        sourceModel = AdapterFactoryEditingDomain.unwrap((Object)sourceModel);
        String s = null;
        if (sourceModel instanceof ValueType) {
            s = ((ValueType)sourceModel).getProperty();
        }
        ArrayList<Object> nodesList = new ArrayList<Object>();
        FreemarkerCSVContentGenerator.fillParentList(nodesList, parentModel, recordRootNode);
        if (!nodesList.isEmpty()) {
            nodesList.remove(0);
        }
        String mappingString = "";
        int i = 0;
        while (i < nodesList.size()) {
            Object node = nodesList.get(i);
            String beanName = null;
            if (node instanceof BeanType) {
                beanName = ((BeanType)node).getBeanId();
            }
            if (beanName != null) {
                mappingString = String.valueOf(mappingString) + beanName + ".";
            }
            ++i;
        }
        if (s != null) {
            mappingString = String.valueOf(mappingString) + s;
        }
        return mappingString;
    }

    private static boolean fillParentList(List<Object> list, AbstractSmooksGraphicalModel node, JavaBeanGraphModel recordRootNode) {
        if (node instanceof JavaBeanChildGraphModel) {
            node = node.getParent();
        }
        if (node == recordRootNode) {
            list.add(recordRootNode.getData());
            return true;
        }
        if (node instanceof JavaBeanGraphModel) {
            Object parent = node.getData();
            List<TreeNodeConnection> connections = ((JavaBeanGraphModel)node).getTargetConnections();
            for (TreeNodeConnection connection : connections) {
                AbstractSmooksGraphicalModel sourcenode = connection.getSourceNode();
                if (!FreemarkerCSVContentGenerator.fillParentList(list, sourcenode, recordRootNode)) continue;
                parent = AdapterFactoryEditingDomain.unwrap((Object)parent);
                list.add(parent);
                return true;
            }
        }
        return false;
    }

    private Element getRecordElement(Document model) {
        return model.getDocumentElement();
    }

    private Element getFieldElement(Document model, String fieldName) {
        return (Element)model.getElementsByTagName(fieldName).item(0);
    }
}

